/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import org.exolab.javasource.Header;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JComment;
import org.exolab.javasource.JInterface;
import org.exolab.javasource.JSourceWriter;
import org.exolab.javasource.JStructure;

public class JCompUnit {
    private static final String DEFAULT_HEADER = "$Id$";
    private JComment header = null;
    private String packageName = null;
    private String fileName = null;
    private Vector classes = null;
    private Vector interfaces = null;

    public JCompUnit(String string, String string2) {
        this.packageName = string;
        this.fileName = string2;
        this.init();
    }

    public JCompUnit(JClass jClass) {
        this.packageName = jClass.getPackageName();
        String string = jClass.getLocalName();
        this.fileName = string + ".java";
        this.init();
        this.classes.add(jClass);
    }

    public JCompUnit(JInterface jInterface) {
        this.packageName = jInterface.getPackageName();
        this.fileName = jInterface.getLocalName() + ".java";
        this.init();
        this.interfaces.add(jInterface);
    }

    private void init() {
        this.classes = new Vector();
        this.interfaces = new Vector();
    }

    public void addStructure(JStructure jStructure) throws IllegalArgumentException {
        if (jStructure instanceof JInterface) {
            this.addInterface((JInterface)jStructure);
        } else if (jStructure instanceof JClass) {
            this.addClass((JClass)jStructure);
        } else {
            String string = "Unknown JStructure subclass '" + jStructure.getClass().getName() + "'.";
            throw new IllegalArgumentException(string);
        }
    }

    public void addClass(JClass jClass) {
        this.classes.add(jClass);
    }

    public void addInterface(JInterface jInterface) {
        this.interfaces.add(jInterface);
    }

    public SortedSet getImports() {
        Object object;
        TreeSet treeSet = new TreeSet();
        int n = 0;
        while (n < this.classes.size()) {
            JClass jClass = (JClass)this.classes.get(n);
            object = jClass.getImports();
            while (object.hasMoreElements()) {
                treeSet.add(object.nextElement());
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.interfaces.size()) {
            object = (JInterface)this.interfaces.get(n2);
            Enumeration enumeration = ((JStructure)object).getImports();
            while (enumeration.hasMoreElements()) {
                treeSet.add(enumeration.nextElement());
            }
            ++n2;
        }
        return treeSet;
    }

    public String getFilename(String string) {
        File file;
        String string2 = new String(this.fileName);
        String string3 = "";
        if (this.packageName != null && this.packageName.length() > 0) {
            string3 = this.packageName.replace('.', File.separatorChar);
        }
        if (!(file = string == null ? new File(string3) : new File(string, string3)).exists()) {
            file.mkdirs();
        }
        if (file.toString().length() > 0) {
            string2 = file.toString() + File.separator + string2;
        }
        return string2;
    }

    public String getPackageName() {
        return this.packageName;
    }

    protected static String getPackageFromClassName(String string) {
        int n = -1;
        n = string.lastIndexOf(46);
        if (n > 0) {
            return string.substring(0, n);
        }
        return null;
    }

    public void print() {
        this.print(null, null);
    }

    public void print(String string) {
        this.print(string, null);
    }

    public void print(String string, String string2) {
        String string3 = this.getFilename(string);
        File file = new File(string3);
        JSourceWriter jSourceWriter = null;
        try {
            jSourceWriter = new JSourceWriter(new FileWriter(file));
        }
        catch (IOException iOException) {
            System.out.println("unable to create compilation unit file: " + string3);
            return;
        }
        if (string2 == null) {
            string2 = System.getProperty("line.separator");
        }
        jSourceWriter.setLineSeparator(string2);
        this.print(jSourceWriter);
        jSourceWriter.flush();
        jSourceWriter.close();
    }

    public void print(JSourceWriter jSourceWriter) {
        this.resolveNames();
        StringBuffer stringBuffer = new StringBuffer();
        if (this.header != null) {
            this.header.print(jSourceWriter);
        } else {
            jSourceWriter.writeln("/*");
            jSourceWriter.writeln(" * $Id$");
            jSourceWriter.writeln("*/");
        }
        jSourceWriter.writeln();
        jSourceWriter.flush();
        if (this.packageName != null && this.packageName.length() > 0) {
            stringBuffer.setLength(0);
            stringBuffer.append("package ");
            stringBuffer.append(this.packageName);
            stringBuffer.append(';');
            jSourceWriter.writeln(stringBuffer.toString());
            jSourceWriter.writeln();
        }
        jSourceWriter.writeln("  //---------------------------------------------/");
        jSourceWriter.writeln(" //- Imported classes, interfaces and packages -/");
        jSourceWriter.writeln("//---------------------------------------------/");
        jSourceWriter.writeln();
        SortedSet sortedSet = this.getImports();
        String string = this.getPackageName();
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = JStructure.getPackageFromClassName(string2);
            if (string3 == null || string3.equals(string)) continue;
            jSourceWriter.write("import ");
            jSourceWriter.write(string2);
            jSourceWriter.writeln(';');
        }
        jSourceWriter.writeln();
        this.printStructures(jSourceWriter, true);
        this.printStructures(jSourceWriter, false);
        jSourceWriter.flush();
    }

    public final void printStructures(JSourceWriter jSourceWriter, boolean bl) {
        Object object;
        boolean bl2 = true;
        Enumeration enumeration = this.interfaces.elements();
        while (enumeration.hasMoreElements()) {
            object = (JInterface)enumeration.nextElement();
            if (((JStructure)object).getModifiers().isPublic() != bl) continue;
            if (bl2) {
                Header.print(jSourceWriter, bl);
                bl2 = false;
            }
            ((JInterface)object).print(jSourceWriter, true);
            jSourceWriter.writeln();
        }
        object = this.classes.elements();
        while (object.hasMoreElements()) {
            JClass jClass = (JClass)object.nextElement();
            if (jClass.getModifiers().isPublic() != bl) continue;
            if (bl2) {
                Header.print(jSourceWriter, bl);
                bl2 = false;
            }
            jClass.print(jSourceWriter, true);
            jSourceWriter.writeln();
        }
    }

    public void setHeader(JComment jComment) {
        this.header = jComment;
    }

    private void resolveNames() {
    }
}

