/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.net.URIResolver;
import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Resolver;
import org.xml.sax.Locator;

public abstract class ComponentReader {
    protected Locator _locator = null;
    private Resolver _resolver;
    private URIResolver _uriResolver;

    public abstract String elementName();

    public abstract Object getObject();

    public void finish() throws XMLException {
    }

    public Locator getDocumentLocator() {
        return this._locator;
    }

    public Resolver getResolver() {
        return this._resolver;
    }

    public URIResolver getURIResolver() {
        return this._uriResolver;
    }

    public void setResolver(Resolver resolver) {
        this._resolver = resolver;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this._uriResolver = uRIResolver;
    }

    public static boolean isWhiteSpace(char[] cArray, int n, int n2) {
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            char c = cArray[n4];
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    return false;
                }
            }
            ++n4;
        }
        return true;
    }

    public void error(String string) throws XMLException {
        if (this._locator != null) {
            string = string + "\n   line: " + this._locator.getLineNumber();
        }
        throw new XMLException(string);
    }

    public void illegalAttribute(String string) throws XMLException {
        String string2 = "Illegal attribute '" + string + "' found on element <" + this.elementName() + ">.";
        if (this._locator != null) {
            string2 = string2 + "\n   line: " + this._locator.getLineNumber();
        }
        throw new XMLException(string2);
    }

    public void illegalElement(String string) throws XMLException {
        String string2 = "Illegal element '" + string + "' found as child of <" + this.elementName() + ">.";
        if (this._locator != null) {
            string2 = string2 + "\n   line: " + this._locator.getLineNumber();
        }
        throw new XMLException(string2);
    }

    public void redefinedElement(String string) throws XMLException {
        this.redefinedElement(string, null);
    }

    public void redefinedElement(String string, String string2) throws XMLException {
        String string3 = "redefintion of element '" + string + "' within element <" + this.elementName() + ">.";
        if (this._locator != null) {
            string3 = string3 + "\n   line: " + this._locator.getLineNumber();
        }
        if (string2 != null) {
            string3 = string3 + "\n   " + string2;
        }
        throw new XMLException(string3 + "\n");
    }

    public void outOfOrder(String string) throws XMLException {
        StringBuffer stringBuffer = new StringBuffer("out of order element <");
        stringBuffer.append(string);
        stringBuffer.append("> found in <");
        stringBuffer.append(this.elementName());
        stringBuffer.append(">.");
        throw new XMLException(stringBuffer.toString());
    }

    public static int toInt(String string) throws IllegalArgumentException {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = string + " is not a valid integer. ";
            throw new IllegalArgumentException(string2);
        }
    }

    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
    }

    public void characters(char[] cArray, int n, int n2) throws XMLException {
    }

    public void endElement(String string, String string2) throws XMLException {
    }

    public void startElement(String string, String string2, AttributeSet attributeSet, Namespaces namespaces) throws XMLException {
    }
}

