/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.exolab.castor.types.GMonthDay;
import org.exolab.castor.types.OperationNotSupportedException;

public class GMonth
extends GMonthDay {
    private static final String MONTH_FORMAT = "--MM--";
    private static final String BAD_GMONTH = "Bad gMonth format: ";

    public GMonth() {
    }

    public GMonth(short s) {
        this.setMonth(s);
    }

    public GMonth(int n) {
        this.setMonth((short)n);
    }

    public GMonth(String string) throws ParseException {
        this();
        GMonth.parseGMonthInternal(string, this);
    }

    public Date toDate() {
        Date date = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(MONTH_FORMAT);
        if (this.isUTC()) {
            SimpleTimeZone simpleTimeZone = new SimpleTimeZone(0, "UTC");
            int n = 0;
            n = (this.getZoneMinute() + this.getZoneHour() * 60) * 60 * 1000;
            n = this.isZoneNegative() ? -n : n;
            simpleTimeZone.setRawOffset(n);
            simpleTimeZone.setID(TimeZone.getAvailableIDs(n)[0]);
            simpleDateFormat.setTimeZone(simpleTimeZone);
        }
        try {
            date = simpleDateFormat.parse(this.toString());
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return null;
        }
        return date;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('-');
        stringBuffer.append('-');
        stringBuffer.append(this.getMonth());
        if (stringBuffer.length() == 3) {
            stringBuffer.insert(2, 0);
        }
        stringBuffer.append('-');
        stringBuffer.append('-');
        if (this.isUTC()) {
            if (this.getZoneHour() == 0 && this.getZoneMinute() == 0) {
                stringBuffer.append('Z');
            } else {
                StringBuffer stringBuffer2 = new StringBuffer();
                if (this.isZoneNegative()) {
                    stringBuffer2.append('-');
                } else {
                    stringBuffer2.append('+');
                }
                if (this.getZoneHour() / 10 == 0) {
                    stringBuffer2.append(0);
                }
                stringBuffer2.append(this.getZoneHour());
                stringBuffer2.append(':');
                if (this.getZoneMinute() / 10 == 0) {
                    stringBuffer2.append(0);
                }
                stringBuffer2.append(this.getZoneMinute());
                stringBuffer.append(stringBuffer2.toString());
                stringBuffer2 = null;
            }
        }
        return stringBuffer.toString();
    }

    public static Object parse(String string) throws ParseException {
        return GMonth.parseGMonth(string);
    }

    public static GMonth parseGMonth(String string) throws ParseException {
        GMonth gMonth = new GMonth();
        return GMonth.parseGMonthInternal(string, gMonth);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static GMonth parseGMonthInternal(String string, GMonth gMonth) throws ParseException {
        if (string == null) {
            throw new IllegalArgumentException("The string to be parsed must not be null.");
        }
        if (gMonth == null) {
            gMonth = new GMonth();
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = -1;
        int n3 = 0;
        int n4 = 63;
        while (n < cArray.length) {
            char c = cArray[n++];
            switch (c) {
                case '-': {
                    if (n4 == 63 && n2 == -1) {
                        n4 = 31;
                    } else if (n4 == 31 && n2 == -1) {
                        n4 = 15;
                    } else if (n4 == 15) {
                        if (!bl2) throw new ParseException(BAD_GMONTH + string + "\nThe month field must have 2 digits.", n);
                        gMonth.setMonth((short)n2);
                        n4 = 7;
                        n2 = -1;
                    } else if (n4 == 7 && n2 == -1) {
                        n4 = 3;
                    } else {
                        if (n4 != 3 || n2 != -1) throw new ParseException(BAD_GMONTH + string + "\nA gMonth must follow the pattern --MM--(Z|((+|-)hh:mm)).", n);
                        gMonth.setUTC();
                        gMonth.setZoneNegative(true);
                        n4 = 1;
                    }
                    bl = false;
                    bl2 = false;
                    break;
                }
                case 'Z': {
                    if (n4 != 3) {
                        throw new ParseException(BAD_GMONTH + string + "\n'Z' " + "is wrongly placed.", n);
                    }
                    gMonth.setUTC();
                    break;
                }
                case '+': {
                    if (n4 != 3) {
                        throw new ParseException(BAD_GMONTH + string + "\n'+' " + "is wrongly placed.", n);
                    }
                    gMonth.setUTC();
                    n4 = 1;
                    bl = false;
                    bl2 = false;
                    break;
                }
                case ':': {
                    if (n4 != 1) {
                        throw new ParseException(BAD_GMONTH + string + "\n':' " + "is wrongly placed.", n);
                    }
                    n3 = n2;
                    n2 = -1;
                    n4 = 0;
                    bl = false;
                    bl2 = false;
                    break;
                }
                default: {
                    if ('0' > c || c > '9') throw new ParseException(string + ": Invalid character: " + c, n);
                    if (bl) {
                        n2 = (short)(n2 * 10 + (c - 48));
                        bl2 = true;
                        break;
                    }
                    bl = true;
                    n2 = (short)(c - 48);
                    break;
                }
            }
        }
        if (n4 != 3 && n4 != 0) {
            throw new ParseException(BAD_GMONTH + string + "\nA gMonth must follow the pattern --MM--(Z|((+|-)hh:mm)).", n);
        }
        if (n4 != 0) return gMonth;
        if (n2 == -1) throw new ParseException(string + "\n In a time zone, the minute field must always be present.", n);
        gMonth.setZone((short)n3, (short)n2);
        return gMonth;
    }

    public short getDay() {
        String string = "GMonth: couldn't access to the Day field.";
        throw new OperationNotSupportedException(string);
    }

    public void setDay(short s) {
        String string = "GMonth: couldn't access to the Day field.";
        throw new OperationNotSupportedException(string);
    }
}

