/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.exolab.castor.types.DateTimeBase;
import org.exolab.castor.types.OperationNotSupportedException;

public class Date
extends DateTimeBase {
    private static final int YEAR_FLAG = 15;
    private static final int MONTH_FLAG = 7;
    private static final int DAY_FLAG = 3;
    private static final int TIMEZONE_FLAG = 1;
    private static final String BAD_DATE = "Bad Date format: ";
    public static final String DATE_FORMAT = "yyyy-MM-dd";

    public Date() {
    }

    public Date(short[] sArray) {
        this.setValues(sArray);
    }

    public Date(java.util.Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        this.setCentury((short)(gregorianCalendar.get(1) / 100));
        this.setYear((short)(gregorianCalendar.get(1) % 100));
        this.setMonth((short)(gregorianCalendar.get(2) + 1));
        this.setDay((short)gregorianCalendar.get(5));
    }

    public Date(String string) throws ParseException {
        this();
        Date.parseDateInternal(string, this);
    }

    public void setValues(short[] sArray) {
        if (sArray.length != 4) {
            throw new IllegalArgumentException("Date#setValues: not the right number of values");
        }
        this.setCentury(sArray[0]);
        this.setYear(sArray[1]);
        this.setMonth(sArray[2]);
        this.setDay(sArray[3]);
    }

    public short[] getValues() {
        short[] sArray = null;
        sArray = new short[]{this.getCentury(), this.getYear(), this.getMonth(), this.getDay()};
        return sArray;
    }

    public java.util.Date toDate() {
        java.util.Date date = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
        if (this.isUTC()) {
            SimpleTimeZone simpleTimeZone = new SimpleTimeZone(0, "UTC");
            int n = 0;
            n = (this.getZoneMinute() + this.getZoneHour() * 60) * 60 * 1000;
            n = this.isZoneNegative() ? -n : n;
            simpleTimeZone.setRawOffset(n);
            simpleTimeZone.setID(TimeZone.getAvailableIDs(n)[0]);
            simpleDateFormat.setTimeZone(simpleTimeZone);
        }
        try {
            date = simpleDateFormat.parse(this.toString());
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return null;
        }
        return date;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isNegative()) {
            stringBuffer.append('-');
        }
        stringBuffer.append(this.getCentury());
        if (stringBuffer.length() == 1) {
            stringBuffer.insert(0, 0);
        }
        if (this.getYear() / 10 == 0) {
            stringBuffer.append(0);
        }
        stringBuffer.append(this.getYear());
        stringBuffer.append('-');
        if (this.getMonth() / 10 == 0) {
            stringBuffer.append(0);
        }
        stringBuffer.append(this.getMonth());
        stringBuffer.append('-');
        if (this.getDay() / 10 == 0) {
            stringBuffer.append(0);
        }
        stringBuffer.append(this.getDay());
        if (this.isUTC()) {
            if (this.getZoneHour() == 0 && this.getZoneMinute() == 0) {
                stringBuffer.append('Z');
            } else {
                StringBuffer stringBuffer2 = new StringBuffer();
                if (this.isZoneNegative()) {
                    stringBuffer2.append('-');
                } else {
                    stringBuffer2.append('+');
                }
                if (this.getZoneHour() / 10 == 0) {
                    stringBuffer2.append(0);
                }
                stringBuffer2.append(this.getZoneHour());
                stringBuffer2.append(':');
                if (this.getZoneMinute() / 10 == 0) {
                    stringBuffer2.append(0);
                }
                stringBuffer2.append(this.getZoneMinute());
                stringBuffer.append(stringBuffer2.toString());
                stringBuffer2 = null;
            }
        }
        return stringBuffer.toString();
    }

    public static Object parse(String string) throws ParseException {
        return Date.parseDate(string);
    }

    public static Date parseDate(String string) throws ParseException {
        Date date = new Date();
        return Date.parseDateInternal(string, date);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Date parseDateInternal(String string, Date date) throws ParseException {
        int n;
        char[] cArray;
        if (string == null) {
            throw new IllegalArgumentException("The string to be parsed must not be null.");
        }
        if (date == null) {
            date = new Date();
        }
        if ((cArray = string.toCharArray())[n = 0] == '-') {
            ++n;
            date.setNegative();
        }
        boolean bl = false;
        boolean bl2 = false;
        short s = 0;
        short s2 = 0;
        int n2 = 15;
        while (n < cArray.length) {
            char c = cArray[n++];
            switch (c) {
                case '-': {
                    if (n2 == 15) {
                        if (s == 0 && s2 == 0) throw new ParseException(BAD_DATE + string + "\n'0000' is not allowed as a year.", n);
                        if (!bl2) {
                            throw new ParseException(BAD_DATE + string + "\nThe Century field must have 2 digits.", n);
                        }
                        date.setCentury(s);
                        date.setYear(s2);
                        s2 = -1;
                        n2 = 7;
                    } else if (n2 == 7) {
                        if (!bl2 || s2 != -1) throw new ParseException(BAD_DATE + string + "\nThe month field must have 2 digits.", n);
                        date.setMonth(s);
                        n2 = 3;
                    } else {
                        if (n2 != 3 || s2 != -1) throw new ParseException(BAD_DATE + string + "\n '-' " + "is wrongly placed.", n);
                        if (!bl2) throw new ParseException(BAD_DATE + string + "\nThe day field must have 2 digits.", n);
                        date.setUTC();
                        date.setZoneNegative(true);
                        date.setDay(s);
                        n2 = 1;
                    }
                    bl = false;
                    bl2 = false;
                    break;
                }
                case 'Z': {
                    if (n2 != 3) {
                        throw new ParseException("'Z' is wrongly placed.", n);
                    }
                    date.setUTC();
                    break;
                }
                case '+': {
                    if (n2 != 3) {
                        throw new ParseException("'+' is wrongly placed.", n);
                    }
                    if (!bl2 || s2 != -1) throw new ParseException(BAD_DATE + string + "\nThe day field must have 2 digits.", n);
                    date.setDay(s);
                    date.setUTC();
                    n2 = 1;
                    bl = false;
                    bl2 = false;
                    break;
                }
                case ':': {
                    if (n2 != 1) {
                        throw new ParseException(BAD_DATE + string + "\n':' " + "is wrongly placed.", n);
                    }
                    s2 = s;
                    s = -1;
                    n2 = 0;
                    bl = false;
                    bl2 = false;
                    break;
                }
                default: {
                    if ('0' > c || c > '9') throw new ParseException(string + ": Invalid character: " + c, n);
                    if (bl) {
                        if (bl2) {
                            s2 = (short)(s2 * 10 + (c - 48));
                            break;
                        }
                        s = (short)(s * 10 + (c - 48));
                        bl2 = true;
                        break;
                    }
                    bl = true;
                    s = (short)(c - 48);
                    break;
                }
            }
        }
        if (n2 != 3 && n2 != 0) {
            throw new ParseException(BAD_DATE + string + "\nA date must follow the pattern CCYY-MM-DD(Z|((+|-)hh:mm)).", n);
        }
        if (n2 == 3) {
            if (!bl2 || s2 != -1) throw new ParseException(BAD_DATE + string + "\nThe day field must have 2 digits.", n);
            date.setDay(s);
            return date;
        } else {
            if (n2 != 0) return date;
            if (s == -1) throw new ParseException(string + "\n In a time zone, the minute field must always be present.", n);
            date.setZone(s2, s);
        }
        return date;
    }

    public short getHour() {
        String string = "Date: couldn't access to the Hour field.";
        throw new OperationNotSupportedException(string);
    }

    public short getMinute() {
        String string = "Date: couldn't access to the Minute field.";
        throw new OperationNotSupportedException(string);
    }

    public short getSeconds() {
        String string = "Date: couldn't access to the Second field.";
        throw new OperationNotSupportedException(string);
    }

    public short getMilli() {
        String string = "Date: couldn't access to the Millisecond field.";
        throw new OperationNotSupportedException(string);
    }

    public void setHour(short s) {
        String string = "Date: couldn't access to the Hour field.";
        throw new OperationNotSupportedException(string);
    }

    public void setMinute(short s) {
        String string = "Date: couldn't access to the Minute field.";
        throw new OperationNotSupportedException(string);
    }

    public void setSecond(short s) {
        String string = "Date: couldn't access to the second field.";
        throw new OperationNotSupportedException(string);
    }

    public void setMilliSecond(short s) {
        String string = "Date: couldn't access to the Millisecond field.";
        throw new OperationNotSupportedException(string);
    }
}

