/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import org.exolab.castor.jdo.LockNotGrantedException;
import org.exolab.castor.jdo.ObjectDeletedException;
import org.exolab.castor.persist.DepositBox;
import org.exolab.castor.persist.OID;
import org.exolab.castor.persist.ObjectDeletedWaitingForLockException;
import org.exolab.castor.persist.TransactionContext;

final class ObjectLock
implements DepositBox {
    static final short ACTION_READ = 1;
    static final short ACTION_WRITE = 2;
    static final short ACTION_CREATE = 3;
    static final short ACTION_UPDATE = 4;
    static int idcount = 0;
    static final int[] lock = new int[0];
    private int _id;
    static final boolean TRACE = false;
    private Object _object;
    private OID _oid;
    private TransactionContext _writeLock;
    private LinkedTx _readLock;
    private LinkedTx _readWaiting;
    private int _waitCount;
    private LinkedTx _writeWaiting;
    private TransactionContext _confirmWaiting;
    private short _confirmWaitingAction;
    private int _gateCount;
    private long _timeStamp;
    private boolean _deleted;
    private boolean _invalidated;

    ObjectLock(OID oID) {
        this._oid = oID;
        int[] nArray = lock;
        synchronized (nArray) {
            this._id = idcount++;
        }
    }

    OID getOID() {
        return this._oid;
    }

    void setOID(OID oID) {
        this._oid = oID;
    }

    void enter() {
        ++this._gateCount;
    }

    void leave() {
        --this._gateCount;
    }

    boolean isEntered() {
        return this._gateCount != 0;
    }

    boolean isDisposable() {
        return this._gateCount == 0 && this.isFree() && this._waitCount == 0;
    }

    boolean hasLock(TransactionContext transactionContext, boolean bl) {
        if (this._writeLock == transactionContext) {
            return true;
        }
        if (this._confirmWaiting == transactionContext) {
            if (this._confirmWaitingAction == 2 || this._confirmWaitingAction == 3) {
                return true;
            }
            return !bl && this._confirmWaitingAction == 1;
        }
        if (bl) {
            return false;
        }
        LinkedTx linkedTx = this._readLock;
        while (linkedTx != null) {
            if (linkedTx.tx == transactionContext) {
                return true;
            }
            linkedTx = linkedTx.next;
        }
        return false;
    }

    boolean isFree() {
        return this._writeLock == null && this._readLock == null && this._writeWaiting == null && this._readWaiting == null && this._confirmWaiting == null && this._waitCount == 0;
    }

    boolean isExclusivelyOwned(TransactionContext transactionContext) {
        if (this._writeLock == null && this._readLock == null) {
            return false;
        }
        if (this._writeLock == null && this._readLock.tx == transactionContext && this._readLock.next.tx == null) {
            return true;
        }
        return this._writeLock == transactionContext && this._readLock == null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void acquireLoadLock(TransactionContext var1_1, boolean var2_2, int var3_3) throws LockNotGrantedException, ObjectDeletedWaitingForLockException {
        block25: {
            block28: {
                block27: {
                    var4_4 = var3_3 > 0 ? System.currentTimeMillis() + (long)(var3_3 * 1000) : 0x7FFFFFFFFFFFFFFFL;
                    try lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            if (this._deleted) {
                                throw new ObjectDeletedWaitingForLockException("Object deleted");
                            }
                            if (this._confirmWaiting != null) {
                                try {
                                    try {
                                        ++this._waitCount;
                                        this.wait();
                                    }
                                    catch (InterruptedException var6_6) {
                                        throw new LockNotGrantedException("Thread interrupted acquiring lock!");
                                    }
                                    var8_9 = null;
                                    --this._waitCount;
                                    break block25;
                                }
                                catch (Throwable var7_12) {
                                    var8_9 = null;
                                    --this._waitCount;
                                    throw var7_12;
                                }
                            }
                            if (this._writeLock == var1_1) {
                                var10_10 = null;
                                this.removeWaiting(var1_1);
                                var1_1.setWaitOnLock(null);
                                return;
                            }
                            if (this._readLock == null && this._writeLock == null && var2_2) {
                                this._confirmWaiting = var1_1;
                                this._confirmWaitingAction = (short)2;
                                break;
                            }
                            if (this._readLock == null && this._writeLock == null && !var2_2) {
                                if (this._object == null) {
                                    this._confirmWaiting = var1_1;
                                    this._confirmWaitingAction = 1;
                                    break block27;
                                }
                                this._readLock = new LinkedTx(var1_1, null);
                                break block28;
                            }
                            if (this._readLock != null && !var2_2) {
                                var6_7 = this._readLock;
                                while (true) {
                                    if (var6_7 == null) break;
                                    if (var6_7.tx == var1_1) {
                                        throw new IllegalStateException("Transaction: " + var1_1 + " has already hold the write lock on " + this._oid + " Acquire shouldn't be called twice");
                                    }
                                    var6_7 = var6_7.next;
                                }
                                this._readLock = new LinkedTx(var1_1, this._readLock);
                                var10_10 = null;
                                this.removeWaiting(var1_1);
                                var1_1.setWaitOnLock(null);
                                return;
                            }
                            if (var3_3 == 0) {
                                v0 = new StringBuffer();
                                if (var2_2) {
                                    v1 = "persist.writeLockTimeout";
                                    throw new LockNotGrantedException(v0.append(v1).append(this._oid).append("/").append(this._id).append(" by ").append(var1_1).toString());
                                }
                                v1 = "persist.readLockTimeout";
                                throw new LockNotGrantedException(v0.append(v1).append(this._oid).append("/").append(this._id).append(" by ").append(var1_1).toString());
                            }
                            var1_1.setWaitOnLock(this);
                            this.detectDeadlock(var1_1, 10);
                            if (var2_2) {
                                this._writeWaiting = new LinkedTx(var1_1, this._writeWaiting);
                            } else {
                                this._readWaiting = new LinkedTx(var1_1, this._readWaiting);
                            }
                            try {
                                var6_5 = var4_4 - System.currentTimeMillis();
                                this.wait(var6_5 < 0L ? 0L : var6_5);
                            }
                            catch (InterruptedException var6_8) {
                                if (var2_2) {
                                    v2 = "persist.writeLockTimeout";
                                    throw new LockNotGrantedException(v2);
                                }
                                v2 = "persist.readLockTimeout" + this._oid + "/" + this._id + " by " + var1_1;
                                throw new LockNotGrantedException(v2);
                            }
                            if (this._deleted) {
                                throw new ObjectDeletedWaitingForLockException("object deleted" + this._oid + "/" + this._id + " by " + var1_1);
                            }
                            if (System.currentTimeMillis() > var4_4) {
                                var3_3 = 0;
                            }
                            this.removeWaiting(var1_1);
                            var1_1.setWaitOnLock(null);
                            break block25;
                            break;
                        }
                    }
                    catch (Throwable var9_13) {
                        var10_11 = null;
                        this.removeWaiting(var1_1);
                        var1_1.setWaitOnLock(null);
                        throw var9_13;
                    }
                    var10_10 = null;
                    this.removeWaiting(var1_1);
                    var1_1.setWaitOnLock(null);
                    return;
                }
                var10_10 = null;
                this.removeWaiting(var1_1);
                var1_1.setWaitOnLock(null);
                return;
            }
            var10_10 = null;
            this.removeWaiting(var1_1);
            var1_1.setWaitOnLock(null);
            return;
        }
        var10_10 = null;
        this.removeWaiting(var1_1);
        var1_1.setWaitOnLock(null);
        ** while (true)
    }

    synchronized void acquireCreateLock(TransactionContext transactionContext) throws LockNotGrantedException {
        while (this._deleted || this._confirmWaiting != null) {
            Object var4_2;
            try {
                try {
                    ++this._waitCount;
                    this.wait();
                    while (this._deleted) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new LockNotGrantedException("Thread interrupted acquiring lock!");
                }
                var4_2 = null;
                --this._waitCount;
            }
            catch (Throwable throwable) {
                var4_2 = null;
                --this._waitCount;
                throw throwable;
            }
        }
        if (this._readLock != null || this._writeLock != null) {
            throw new LockNotGrantedException("Lock already exist!");
        }
        this._confirmWaiting = transactionContext;
        this._confirmWaitingAction = (short)3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void acquireUpdateLock(TransactionContext transactionContext, int n) throws LockNotGrantedException, ObjectDeletedException, ObjectDeletedWaitingForLockException {
        long l = n > 0 ? System.currentTimeMillis() + (long)(n * 1000) : Long.MAX_VALUE;
        try {
            while (true) {
                Object var10_9;
                block15: {
                    if (this._deleted || this._confirmWaiting != null) {
                        Object var7_6;
                        try {
                            try {
                                ++this._waitCount;
                                this.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                throw new LockNotGrantedException("Thread interrupted acquiring lock!");
                            }
                            var7_6 = null;
                            --this._waitCount;
                            break block15;
                        }
                        catch (Throwable throwable) {
                            var7_6 = null;
                            --this._waitCount;
                            throw throwable;
                        }
                    }
                    if (this._writeLock == transactionContext) {
                        var10_9 = null;
                        this.removeWaiting(transactionContext);
                        transactionContext.setWaitOnLock(null);
                        return;
                    }
                    if (this._writeLock == null && this._readLock == null) {
                        this._confirmWaiting = transactionContext;
                        this._confirmWaitingAction = (short)4;
                        var10_9 = null;
                        this.removeWaiting(transactionContext);
                        transactionContext.setWaitOnLock(null);
                        return;
                    }
                    if (n == 0) {
                        throw new LockNotGrantedException("persist.writeLockTimeout");
                    }
                    transactionContext.setWaitOnLock(this);
                    this.detectDeadlock(transactionContext, 10);
                    this._writeWaiting = new LinkedTx(transactionContext, this._writeWaiting);
                    long l2 = System.currentTimeMillis();
                    try {
                        long l3 = l - System.currentTimeMillis();
                        this.wait(l3 < 0L ? 0L : l3);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new LockNotGrantedException("persist.writeLockTimeout" + this._oid + "/" + this._id + " by " + transactionContext);
                    }
                    if (this._deleted) {
                        throw new ObjectDeletedWaitingForLockException("object deleted" + this._oid + "/" + this._id + " by " + transactionContext);
                    }
                    if (System.currentTimeMillis() > l) {
                        n = 0;
                    }
                    this.removeWaiting(transactionContext);
                    transactionContext.setWaitOnLock(null);
                }
                var10_9 = null;
                this.removeWaiting(transactionContext);
                transactionContext.setWaitOnLock(null);
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.removeWaiting(transactionContext);
            transactionContext.setWaitOnLock(null);
            throw throwable;
        }
    }

    public synchronized void setObject(TransactionContext transactionContext, Object object) {
        if (this._confirmWaiting != null && this._confirmWaiting == transactionContext) {
            this._timeStamp = System.currentTimeMillis();
            this._object = object;
            if (this._confirmWaitingAction == 1) {
                this._readLock = new LinkedTx(transactionContext, null);
            } else {
                this._writeLock = transactionContext;
            }
            this._confirmWaiting = null;
            this.notifyAll();
        } else if (this._writeLock != null && this._writeLock == transactionContext) {
            this._timeStamp = System.currentTimeMillis();
            this._object = object;
        } else {
            throw new IllegalArgumentException("Transaction tx does not own this lock, " + this.toString() + "!");
        }
    }

    public synchronized Object getObject(TransactionContext transactionContext) {
        if (this._confirmWaiting != null && this._confirmWaiting == transactionContext) {
            return this._object;
        }
        if (this._writeLock != null && this._writeLock == transactionContext) {
            return this._object;
        }
        LinkedTx linkedTx = this._readLock;
        while (linkedTx != null) {
            if (linkedTx.tx == transactionContext) {
                return this._object;
            }
            linkedTx = linkedTx.next;
        }
        throw new IllegalArgumentException("Transaction tx does not own this lock!");
    }

    public synchronized long getTimeStamp() {
        return this._timeStamp;
    }

    synchronized void confirm(TransactionContext transactionContext, boolean bl) {
        if (this._confirmWaiting == transactionContext) {
            if (bl) {
                if (this._confirmWaitingAction == 1) {
                    if (this._readLock == null) {
                        this._readLock = new LinkedTx(transactionContext, null);
                    }
                } else {
                    this._writeLock = transactionContext;
                }
            }
            this._confirmWaiting = null;
            this.notifyAll();
        } else if (this._confirmWaiting == null) {
            if (!bl) {
                if (this._writeLock != null) {
                    this._deleted = true;
                    this._object = null;
                    this._timeStamp = System.currentTimeMillis();
                    this.notifyAll();
                } else if (this._readLock != null) {
                    if (this._readLock.tx == transactionContext) {
                        this._readLock = this._readLock.next;
                    } else {
                        LinkedTx linkedTx = this._readLock;
                        while (linkedTx != null) {
                            if (linkedTx.next != null && linkedTx.next.tx == transactionContext) {
                                linkedTx.next = linkedTx.next.next;
                                this.notifyAll();
                                return;
                            }
                            linkedTx = linkedTx.next;
                        }
                    }
                }
            }
            this.notifyAll();
        } else {
            throw new IllegalStateException("Confirm transaction does not match the locked transaction");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void upgrade(TransactionContext transactionContext, int n) throws LockNotGrantedException, ObjectDeletedWaitingForLockException {
        if (this._confirmWaiting != null) {
            IllegalStateException illegalStateException = new IllegalStateException("Internal error: acquire when confirmWaiting is not null");
            throw illegalStateException;
        }
        if (!this.hasLock(transactionContext, false)) {
            IllegalStateException illegalStateException = new IllegalStateException("Transaction doesn't previously acquire this lock");
            throw illegalStateException;
        }
        long l = n > 0 ? System.currentTimeMillis() + (long)(n * 1000) : Long.MAX_VALUE;
        try {
            while (true) {
                Object var10_9;
                if (this._writeLock == transactionContext) {
                    var10_9 = null;
                    this.removeWaiting(transactionContext);
                    transactionContext.setWaitOnLock(null);
                    return;
                }
                if (this._writeLock == null && this._readLock.tx == transactionContext && this._readLock.next == null) {
                    this._writeLock = transactionContext;
                    this._readLock = null;
                    var10_9 = null;
                    this.removeWaiting(transactionContext);
                    transactionContext.setWaitOnLock(null);
                    return;
                }
                if (n == 0) {
                    throw new LockNotGrantedException("persist.writeTimeout" + this._oid + "/" + this._id + " by " + transactionContext);
                }
                transactionContext.setWaitOnLock(this);
                this.detectDeadlock(transactionContext, 10);
                this._writeWaiting = new LinkedTx(transactionContext, this._writeWaiting);
                long l2 = System.currentTimeMillis();
                try {
                    long l3 = l - System.currentTimeMillis();
                    this.wait(l3 < 0L ? 0L : l3);
                }
                catch (InterruptedException interruptedException) {
                    throw new LockNotGrantedException("persist.writeLockTimeout");
                }
                if (this._deleted) {
                    throw new IllegalStateException("internal error: object deleted" + this._oid + "/" + this._id + " by " + transactionContext);
                }
                if (System.currentTimeMillis() > l) {
                    n = 0;
                }
                this.removeWaiting(transactionContext);
                transactionContext.setWaitOnLock(null);
                var10_9 = null;
                this.removeWaiting(transactionContext);
                transactionContext.setWaitOnLock(null);
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.removeWaiting(transactionContext);
            transactionContext.setWaitOnLock(null);
            throw throwable;
        }
    }

    synchronized void release(TransactionContext transactionContext) {
        try {
            transactionContext.setWaitOnLock(null);
            if (this._writeLock == transactionContext) {
                this._writeLock = null;
                if (this._invalidated || this._deleted) {
                    this._timeStamp = System.currentTimeMillis();
                    this._object = null;
                }
                this._deleted = false;
                this._invalidated = false;
            } else if (this._readLock != null) {
                if (this._readLock.tx == transactionContext) {
                    this._readLock = this._readLock.next;
                } else {
                    LinkedTx linkedTx = this._readLock;
                    while (linkedTx != null) {
                        if (linkedTx.next != null && linkedTx.next.tx == transactionContext) {
                            linkedTx.next = linkedTx.next.next;
                            break;
                        }
                        linkedTx = linkedTx.next;
                    }
                    if (linkedTx == null) {
                        throw new IllegalStateException("persist.notOwnerLock" + this._oid + "/" + this._id + " by " + transactionContext);
                    }
                }
            } else {
                throw new IllegalStateException("persist.notOwnerLock" + this._oid + "/" + this._id + " by " + transactionContext);
            }
            this.notifyAll();
        }
        catch (ThreadDeath threadDeath) {
            this.release(transactionContext);
            throw threadDeath;
        }
    }

    synchronized void delete(TransactionContext transactionContext) {
        if (transactionContext != this._writeLock) {
            throw new IllegalStateException("persist.notOwnerLock oid:" + this._oid + "/" + this._id + " by " + transactionContext);
        }
        try {
            this._deleted = true;
            this._object = null;
            this.notifyAll();
        }
        catch (ThreadDeath threadDeath) {
            this.release(transactionContext);
            throw threadDeath;
        }
    }

    synchronized void invalidate(TransactionContext transactionContext) {
        if (transactionContext != this._writeLock) {
            throw new IllegalStateException("persist.notOwnerLock oid:" + this._oid + "/" + this._id + " by " + transactionContext);
        }
        this._invalidated = true;
    }

    private void detectDeadlock(TransactionContext transactionContext, int n) throws LockNotGrantedException {
        if (n <= 0) {
            return;
        }
        if (this._writeLock != null) {
            ObjectLock objectLock = this._writeLock.getWaitOnLock();
            if (objectLock != null) {
                if (objectLock._writeLock == transactionContext) {
                    throw new LockNotGrantedException("persist.deadlock");
                }
                LinkedTx linkedTx = objectLock._readLock;
                while (linkedTx != null) {
                    if (linkedTx.tx == transactionContext) {
                        throw new LockNotGrantedException("persist.deadlock");
                    }
                    linkedTx = linkedTx.next;
                }
                objectLock.detectDeadlock(transactionContext, n - 1);
            }
        } else {
            LinkedTx linkedTx = this._readLock;
            while (linkedTx != null) {
                ObjectLock objectLock = linkedTx.tx.getWaitOnLock();
                if (objectLock != null && linkedTx.tx != transactionContext) {
                    if (objectLock._writeLock == transactionContext) {
                        throw new LockNotGrantedException("persist.deadlock");
                    }
                    LinkedTx linkedTx2 = objectLock._readLock;
                    while (linkedTx2 != null) {
                        if (linkedTx2.tx == transactionContext) {
                            throw new LockNotGrantedException("persist.deadlock");
                        }
                        linkedTx2 = linkedTx2.next;
                    }
                    objectLock.detectDeadlock(transactionContext, n - 1);
                }
                linkedTx = linkedTx.next;
            }
        }
    }

    private void removeWaiting(TransactionContext transactionContext) {
        try {
            LinkedTx linkedTx;
            if (this._writeWaiting != null) {
                if (this._writeWaiting.tx == transactionContext) {
                    this._writeWaiting = this._writeWaiting.next;
                } else {
                    linkedTx = this._writeWaiting;
                    while (linkedTx.next != null) {
                        if (linkedTx.next.tx == transactionContext) {
                            linkedTx.next = linkedTx.next.next;
                            break;
                        }
                        linkedTx = linkedTx.next;
                    }
                }
            }
            if (this._readWaiting != null) {
                if (this._readWaiting.tx == transactionContext) {
                    this._readWaiting = this._readWaiting.next;
                } else {
                    linkedTx = this._readWaiting;
                    while (linkedTx.next != null) {
                        if (linkedTx.next.tx == transactionContext) {
                            linkedTx.next = linkedTx.next.next;
                            break;
                        }
                        linkedTx = linkedTx.next;
                    }
                }
            }
            if (this._deleted && this._readWaiting == null && this._writeWaiting == null && this._confirmWaiting == null) {
                this._deleted = false;
            }
        }
        catch (ThreadDeath threadDeath) {
            this.removeWaiting(transactionContext);
            throw threadDeath;
        }
    }

    public String toString() {
        return this._oid.toString() + "/" + this._id + " " + (this._readLock == null ? "-" : "R") + "/" + (this._writeLock == null ? "-" : "W");
    }

    static class LinkedTx {
        TransactionContext tx;
        LinkedTx next;

        LinkedTx(TransactionContext transactionContext, LinkedTx linkedTx) {
            this.tx = transactionContext;
            this.next = linkedTx;
        }
    }
}

