/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.drivers;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.StringTokenizer;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.KeyGenerator;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.util.Messages;

public final class SequenceKeyGenerator
implements KeyGenerator {
    protected final PersistenceFactory _factory;
    protected final String _factoryName;
    protected final String _seqName;
    private byte _style;
    private final int _sqlType;
    private int _increment;
    private boolean _triggerPresent;

    public SequenceKeyGenerator(PersistenceFactory persistenceFactory, Properties properties, int n) throws MappingException {
        this._factoryName = persistenceFactory.getFactoryName();
        boolean bl = "true".equals(properties.getProperty("returning"));
        this._triggerPresent = "true".equals(properties.getProperty("trigger", "false"));
        if (!(this._factoryName.equals("oracle") || this._factoryName.equals("postgresql") || this._factoryName.equals("interbase") || this._factoryName.equals("sapdb") || this._factoryName.equals("db2"))) {
            throw new MappingException(Messages.format("mapping.keyGenNotCompatible", this.getClass().getName(), this._factoryName));
        }
        if (!this._factoryName.equals("oracle") && bl) {
            throw new MappingException(Messages.format("mapping.keyGenParamNotCompat", "returning=\"true\"", this.getClass().getName(), this._factoryName));
        }
        this._factory = persistenceFactory;
        this._seqName = properties.getProperty("sequence", "{0}_seq");
        this._style = (byte)(this._factoryName.equals("postgresql") || this._factoryName.equals("interbase") || this._factoryName.equals("db2") ? -1 : (bl ? 0 : 1));
        if (this._triggerPresent && !bl) {
            this._style = 1;
        }
        if (this._triggerPresent && this._style == -1) {
            throw new MappingException(Messages.format("mapping.keyGenParamNotCompat", "trigger=\"true\"", this.getClass().getName(), this._factoryName));
        }
        this._sqlType = n;
        if (n != 4 && n != 2 && n != 3 && n != -5) {
            throw new MappingException(Messages.format("mapping.keyGenSQLType", this.getClass().getName(), new Integer(n)));
        }
        try {
            this._increment = Integer.parseInt(properties.getProperty("increment", "1"));
        }
        catch (NumberFormatException numberFormatException) {
            this._increment = 1;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object generateKey(Connection var1_1, String var2_2, String var3_3, Properties var4_4) throws PersistenceException {
        block21: {
            block20: {
                block19: {
                    var5_5 = null;
                    var8_6 = MessageFormat.format(this._seqName, new String[]{var2_2, var3_3});
                    var10_7 = this._factory.quoteName(var2_2);
                    try {
                        try {
                            if (this._factory.getFactoryName().equals("interbase")) {
                                var5_5 = var1_1.prepareStatement("SELECT gen_id(" + var8_6 + "," + this._increment + ") FROM rdb$database");
                                var6_8 = var5_5.executeQuery();
                            } else if (this._factory.getFactoryName().equals("db2")) {
                                var5_5 = var1_1.prepareStatement("SELECT nextval FOR " + var8_6 + " FROM SYSIBM.SYSDUMMY1");
                                var6_8 = var5_5.executeQuery();
                            } else if (this._style == -1) {
                                var5_5 = var1_1.prepareStatement("SELECT nextval('" + var8_6 + "')");
                                var6_8 = var5_5.executeQuery();
                            } else if (this._triggerPresent && this._factoryName.equals("postgresql")) {
                                var11_9 /* !! */  = var4_4.get("insertStatement");
                                var12_11 /* !! */  = Class.forName("org.postgresql.Statement");
                                var13_12 = var12_11 /* !! */ .getMethod("getInsertedOID", null);
                                var14_13 = (Integer)var13_12.invoke(var11_9 /* !! */ , null);
                                var5_5 = var1_1.prepareStatement("SELECT " + this._factory.quoteName(var3_3) + " FROM " + var10_7 + " WHERE OID=?");
                                var5_5.setInt(1, var14_13);
                                var6_8 = var5_5.executeQuery();
                            } else {
                                var5_5 = var1_1.prepareStatement("SELECT " + this._factory.quoteName(var8_6 + ".currval") + " FROM " + var10_7);
                                var6_8 = var5_5.executeQuery();
                            }
                            if (var6_8.next() == false) throw new PersistenceException(Messages.message("persist.keyGenFailed"));
                            var7_14 = var6_8.getInt(1);
                            if (this._sqlType == 4) {
                                var11_9 /* !! */  = new Integer(var7_14);
                                var16_15 = null;
                                if (var5_5 == null) return var11_9 /* !! */ ;
                                break block19;
                            }
                            if (this._sqlType == -5) {
                                var12_11 /* !! */  = new Long(var7_14);
                                break block20;
                            }
                            var13_12 = new BigDecimal((double)var7_14);
                            break block21;
                        }
                        catch (Exception var11_10) {
                            throw new PersistenceException(Messages.format("persist.keyGenSQL", var11_10.toString()));
                        }
                    }
                    catch (Throwable var15_23) {
                        var16_18 = null;
                        if (var5_5 == null) throw var15_23;
                        try {
                            var5_5.close();
                            throw var15_23;
                        }
                        catch (SQLException var17_22) {
                            throw var15_23;
                        }
                    }
                }
                ** try [egrp 2[TRYBLOCK] [2 : 571->581)] { 
lbl57:
                // 1 sources

                var5_5.close();
                return var11_9 /* !! */ ;
lbl59:
                // 1 sources

                catch (SQLException var17_19) {
                    // empty catch block
                }
                return var11_9 /* !! */ ;
            }
            var16_16 = null;
            if (var5_5 == null) return var12_11 /* !! */ ;
            ** try [egrp 2[TRYBLOCK] [2 : 571->581)] { 
lbl66:
            // 1 sources

            var5_5.close();
            return var12_11 /* !! */ ;
lbl68:
            // 1 sources

            catch (SQLException var17_20) {
                // empty catch block
            }
            return var12_11 /* !! */ ;
        }
        var16_17 = null;
        if (var5_5 == null) return var13_12;
        ** try [egrp 2[TRYBLOCK] [2 : 571->581)] { 
lbl75:
        // 1 sources

        var5_5.close();
        return var13_12;
lbl77:
        // 1 sources

        catch (SQLException var17_21) {
            // empty catch block
        }
        return var13_12;
    }

    public byte getStyle() {
        return this._style;
    }

    public String patchSQL(String string, String string2) throws MappingException {
        if (this._style == -1) {
            return string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!stringTokenizer.hasMoreTokens() || !stringTokenizer.nextToken().equalsIgnoreCase("INSERT")) {
            throw new MappingException(Messages.format("mapping.keyGenCannotParse", string));
        }
        if (!stringTokenizer.hasMoreTokens() || !stringTokenizer.nextToken().equalsIgnoreCase("INTO")) {
            throw new MappingException(Messages.format("mapping.keyGenCannotParse", string));
        }
        if (!stringTokenizer.hasMoreTokens()) {
            throw new MappingException(Messages.format("mapping.keyGenCannotParse", string));
        }
        String string3 = stringTokenizer.nextToken();
        if (string3.startsWith("\"")) {
            string3 = string3.substring(1, string3.length() - 1);
        }
        String string4 = MessageFormat.format(this._seqName, string3, string2);
        String string5 = this._factory.quoteName(string4 + ".nextval");
        int n = string.indexOf(40);
        int n2 = string.indexOf(40, n + 1);
        if (n < 0) {
            throw new MappingException(Messages.format("mapping.keyGenCannotParse", string));
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (!this._triggerPresent) {
            if (n2 < 0) {
                n2 = n;
                n = string.indexOf(" VALUES ");
                stringBuffer.insert(n2 + 1, string5);
                stringBuffer.insert(n + 1, "(" + this._factory.quoteName(string2) + ") ");
            } else {
                stringBuffer.insert(n2 + 1, string5 + ",");
                stringBuffer.insert(n + 1, this._factory.quoteName(string2) + ",");
            }
        }
        if (this._style == 0) {
            stringBuffer.append(" RETURNING ");
            stringBuffer.append(this._factory.quoteName(string2));
            stringBuffer.append(" INTO ?");
        }
        return stringBuffer.toString();
    }

    public boolean isInSameConnection() {
        return true;
    }
}

