/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import java.text.ParseException;
import java.util.Enumeration;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.types.GDay;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public class XSGDay
extends XSType {
    private static final JType jType = new JClass("org.exolab.castor.types.GDay");
    private GDay _maxInclusive;
    private GDay _maxExclusive;
    private GDay _minInclusive;
    private GDay _minExclusive;

    public XSGDay() {
        super((short)9);
    }

    public String newInstanceCode() {
        return "new " + this.getJType().getName() + "();";
    }

    public JType getJType() {
        return jType;
    }

    public GDay getMaxExclusive() {
        return this._maxExclusive;
    }

    public GDay getMaxInclusive() {
        return this._maxInclusive;
    }

    public GDay getMinExclusive() {
        return this._minExclusive;
    }

    public GDay getMinInclusive() {
        return this._minInclusive;
    }

    public void setMaxExclusive(GDay gDay) {
        this._maxExclusive = gDay;
        this._maxInclusive = null;
    }

    public void setMaxInclusive(GDay gDay) {
        this._maxInclusive = gDay;
        this._maxExclusive = null;
    }

    public void setMinExclusive(GDay gDay) {
        this._minExclusive = gDay;
        this._minInclusive = null;
    }

    public void setMinInclusive(GDay gDay) {
        this._minInclusive = gDay;
        this._minExclusive = null;
    }

    public boolean hasMinimum() {
        return this._minInclusive != null || this._minExclusive != null;
    }

    public boolean hasMaximum() {
        return this._maxInclusive != null || this._maxExclusive != null;
    }

    public void setFacets(SimpleType simpleType) {
        Enumeration enumeration = XSType.getFacets(simpleType);
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String string = facet.getName();
            try {
                if ("maxExclusive".equals(string)) {
                    this.setMaxExclusive(GDay.parseGDay(facet.getValue()));
                    continue;
                }
                if ("maxInclusive".equals(string)) {
                    this.setMaxInclusive(GDay.parseGDay(facet.getValue()));
                    continue;
                }
                if ("minExclusive".equals(string)) {
                    this.setMinExclusive(GDay.parseGDay(facet.getValue()));
                    continue;
                }
                if ("minInclusive".equals(string)) {
                    this.setMinInclusive(GDay.parseGDay(facet.getValue()));
                    continue;
                }
                if (!"pattern".equals(string)) continue;
                System.out.println("Warning: The facet 'pattern' is not currently supported for XSGDay.");
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
                return;
            }
        }
    }

    public void validationCode(JSourceCode jSourceCode, String string, String string2) {
        GDay gDay;
        if (jSourceCode == null) {
            jSourceCode = new JSourceCode();
        }
        jSourceCode.add("DateTimeValidator typeValidator = new DateTimeValidator();");
        if (this.hasMinimum()) {
            jSourceCode.add("try {");
            jSourceCode.indent();
            gDay = this.getMinExclusive();
            if (gDay != null) {
                jSourceCode.add("org.exolab.castor.types.GDay min =org.exolab.castor.types.GDay.parseGDay(\"" + gDay.toString() + "\");");
                jSourceCode.add("typeValidator.setMinExclusive(");
            } else {
                gDay = this.getMinInclusive();
                jSourceCode.add("org.exolab.castor.types.GDay min =org.exolab.castor.types.GDay.parseGDay(\"" + gDay.toString() + "\");");
                jSourceCode.add("typeValidator.setMinInclusive(");
            }
            jSourceCode.append("min");
            jSourceCode.append(");");
            jSourceCode.unindent();
            jSourceCode.add("} catch (java.text.ParseException e) {");
            jSourceCode.indent();
            jSourceCode.add("System.out.println(e);");
            jSourceCode.add("e.printStackTrace();");
            jSourceCode.add("return;");
            jSourceCode.unindent();
            jSourceCode.add("}");
        }
        if (this.hasMaximum()) {
            jSourceCode.add("try {");
            jSourceCode.indent();
            gDay = this.getMaxExclusive();
            if (gDay != null) {
                jSourceCode.add("org.exolab.castor.types.GDay max =org.exolab.castor.types.GDay.parseGDay(\"" + gDay.toString() + "\");");
                jSourceCode.add("typeValidator.setMaxExclusive(");
            } else {
                gDay = this.getMaxInclusive();
                jSourceCode.add("org.exolab.castor.types.GDay max =org.exolab.castor.types.Date.parseGDay(\"" + gDay.toString() + "\");");
                jSourceCode.add("typeValidator.setMaxInclusive(");
            }
            jSourceCode.append("max");
            jSourceCode.append(");");
            jSourceCode.unindent();
            jSourceCode.add("} catch (java.text.ParseException e) {");
            jSourceCode.indent();
            jSourceCode.add("System.out.println(e);");
            jSourceCode.add("e.printStackTrace();");
            jSourceCode.add("return;");
            jSourceCode.unindent();
            jSourceCode.add("}");
        }
        jSourceCode.add(string2 + ".setValidator(typeValidator);");
    }
}

