/*
 * Decompiled with CFR 0.152.
 */
package jpasswordgenerator;

import java.util.Properties;
import shared.settings.JSettingsHelper;

public class JSettings
extends JSettingsHelper {
    public static final String SETTINGS_FILE = "jpasswordgenerator.properties";
    public static final String COMMENT = "JPasswordGenerator settings";
    private static final String[] SET = new String[]{"SET1", "SET2", "SET3", "SET4", "SET5", "SET6"};
    private static final String[] ISSET = new String[]{"ISSET1", "ISSET2", "ISSET3", "ISSET4", "ISSET5", "ISSET6"};
    private static final String MIN = "Min";
    private static final String MAX = "Max";
    private static final String PASSFONTSIZE = "PassFontSize";
    private static final String[] DEF_SET = new String[]{"ABCDEFGHIJKLMNOPQRSTUVWXYZ", "abcdefghijklmnopqrstuvwxyz", "0123456789", "/\\#*+-_.:,;!\"\u00a7$%&(){[]}?@~|<>", "", ""};
    private static final String[] DEF_ISSET = new String[]{"true", "true", "true", "true", "false", "false"};
    private static final String DEF_MIN = "8";
    private static final String DEF_MAX = "8";
    private static final String DEF_PASSFONTSIZE = "36";
    private String[] m_set = new String[6];
    private boolean[] m_bSet = new boolean[6];
    private int m_min;
    private int m_max;
    private int m_passFontSize;

    public JSettings(boolean bl) {
        super(bl);
    }

    protected String getComment() {
        return COMMENT;
    }

    public String getDefSet(int n) {
        assert (n >= 0 && n < 6);
        return DEF_SET[n];
    }

    public String getSet(int n) {
        assert (n >= 0 && n < 6);
        return this.m_set[n];
    }

    public void setSet(int n, String string) {
        assert (n >= 0 && n < 6);
        this.m_set[n] = string;
    }

    public boolean isSet(int n) {
        assert (n >= 0 && n < 6);
        return this.m_bSet[n];
    }

    public void setIsSet(int n, boolean bl) {
        assert (n >= 0 && n < 6);
        this.m_bSet[n] = bl;
    }

    public int getMin() {
        return this.m_min;
    }

    public void setMin(int n) {
        this.m_min = n;
    }

    public int getMax() {
        return this.m_max;
    }

    public void setMax(int n) {
        this.m_max = n;
    }

    public int getPassFontSize() {
        return this.m_passFontSize;
    }

    public void setPassFontSize(int n) {
        this.m_passFontSize = n;
    }

    protected void doLoad(Properties properties) {
        for (int i = 0; i < 6; ++i) {
            this.m_set[i] = properties.getProperty(SET[i], DEF_SET[i]);
            this.m_bSet[i] = new Boolean(properties.getProperty(ISSET[i], DEF_ISSET[i]));
        }
        this.m_min = new Integer(properties.getProperty(MIN, "8"));
        this.m_max = new Integer(properties.getProperty(MAX, "8"));
        this.m_passFontSize = new Integer(properties.getProperty(PASSFONTSIZE, DEF_PASSFONTSIZE));
    }

    protected void doSave(Properties properties) {
        for (int i = 0; i < 6; ++i) {
            properties.setProperty(SET[i], this.m_set[i]);
            properties.setProperty(ISSET[i], Boolean.toString(this.m_bSet[i]));
        }
        properties.setProperty(MIN, Integer.toString(this.m_min));
        properties.setProperty(MAX, Integer.toString(this.m_max));
        properties.setProperty(PASSFONTSIZE, Integer.toString(this.m_passFontSize));
    }
}

