/*
 * Decompiled with CFR 0.152.
 */
package shared.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import shared.table.JTableColSortData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JTableDataModel<T>
extends AbstractTableModel
implements Comparator<T> {
    protected ArrayList<T> m_data;
    protected JTableColSortData m_sortData;

    public JTableDataModel() {
        this.doInit(0, true);
    }

    public JTableDataModel(int sortCol, boolean bSortUp) {
        this.doInit(sortCol, bSortUp);
    }

    protected void doInit(int sortCol, boolean bSortUp) {
        this.m_data = new ArrayList();
        this.m_sortData = new JTableColSortData(sortCol, bSortUp);
    }

    @Override
    public abstract Object getValueAt(int var1, int var2);

    @Override
    public abstract int getColumnCount();

    public int getSortCol() {
        return this.m_sortData.getSortCol();
    }

    public boolean getSortUp() {
        return this.m_sortData.getSortUp();
    }

    public void setSortCol(int col) {
        this.m_sortData.setSortCol(col);
    }

    public void setSortUp(boolean bUp) {
        this.m_sortData.setSortUp(bUp);
    }

    public Icon getColIcon(int col) {
        ImageIcon icon = null;
        String str = this.getColIconStr(col);
        if (str != null && str.length() > 0) {
            icon = new ImageIcon(str);
        }
        return icon;
    }

    public String getColIconStr(int col) {
        return null;
    }

    public T getItem(int row) {
        assert (row >= 0 && row < this.m_data.size());
        return row >= 0 && row < this.m_data.size() ? (T)this.m_data.get(row) : null;
    }

    public int findRow(T data) {
        int i = 0;
        for (T item : this.m_data) {
            if (data == item) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public void setData(ArrayList<T> data) {
        if (data != null) {
            this.m_data = data;
            this.sort();
            this.fireTableDataChanged();
        }
    }

    public ArrayList<T> getData() {
        return this.m_data;
    }

    public void addData(T data) {
        if (this.m_data == null) {
            this.m_data = new ArrayList();
        }
        this.m_data.add(data);
        this.fireTableDataChanged();
        this.sort();
    }

    public T getRowData(int row) {
        assert (row >= 0 && row < this.m_data.size());
        return row >= 0 && row < this.m_data.size() ? (T)this.m_data.get(row) : null;
    }

    @Override
    public int getRowCount() {
        return this.m_data.size();
    }

    public void removeRow(int row) {
        if (row >= 0 && row < this.m_data.size()) {
            this.m_data.remove(row);
            this.fireTableRowsDeleted(row, row);
            this.sort();
        }
    }

    public void insertRow(T data, int row) {
        if (row >= 0 && row <= this.m_data.size()) {
            if (row < this.m_data.size()) {
                this.m_data.add(row, data);
            } else {
                this.m_data.add(data);
            }
            this.fireTableRowsInserted(row, row);
            this.sort();
        }
    }

    public void removeAll() {
        int rows = this.m_data.size();
        this.m_data.clear();
        this.fireTableRowsDeleted(0, rows);
    }

    public void sort() {
        Collections.sort(this.m_data, this);
        this.fireTableDataChanged();
    }

    @Override
    public int compare(T data1, T data2) {
        int h = 0;
        switch (this.m_sortData.getSortCol()) {
            case 0: {
                h = data1.toString().compareTo(data2.toString());
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (!this.m_sortData.getSortUp()) {
            h = -h;
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        boolean flag = false;
        if (obj instanceof JTableDataModel) {
            JTableDataModel comp = (JTableDataModel)obj;
            if (comp.m_sortData.equals(comp.m_sortData)) {
                flag = true;
            }
        }
        return flag;
    }

    public void updateColHeader(JTable table) {
        int anzahl = this.getColumnCount();
        TableColumnModel colModel = table.getColumnModel();
        for (int i = 0; i < anzahl; ++i) {
            TableColumn tableCol = colModel.getColumn(i);
            JLabel label = (JLabel)((Object)tableCol.getHeaderRenderer());
            if (label != null) {
                label.setIcon(this.getColIcon(i));
                continue;
            }
            String str = this.getColIconStr(i);
            str = str == null || str.length() == 0 ? this.getColumnName(i) : String.format("<html><img src=\"%s\">&nbsp;%s</html>", str, this.getColumnName(i));
            tableCol.setHeaderValue(str);
        }
        table.getTableHeader().repaint();
    }
}

