/*
 * Decompiled with CFR 0.152.
 */
package shared.image;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import javax.swing.JComponent;
import javax.swing.RepaintManager;

public class JImageView
extends JComponent
implements Printable {
    private Object m_interpolation = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
    private Image m_img;

    public boolean hasImage() {
        return this.m_img != null;
    }

    public void setImage(Image img) {
        this.m_img = img;
    }

    public void setImage(String imgPath) {
        this.m_img = Toolkit.getDefaultToolkit().createImage(imgPath);
    }

    public void paintComponent(Graphics g) {
        Graphics gd = g.create();
        this.doPaint(gd, this.getSize(), false);
    }

    public boolean doPaint(Graphics g, Dimension dim, boolean bPrint) {
        if (this.m_img != null) {
            double dx = 0.0;
            double dy = 0.0;
            double d = 0.0;
            Graphics2D g2d = (Graphics2D)g;
            int w = this.m_img.getWidth(this);
            int h = this.m_img.getHeight(this);
            if (dim == null) {
                dim = new Dimension(w, h);
            }
            dx = (double)dim.width / (double)w;
            dy = (double)dim.height / (double)h;
            d = Math.min(dx, dy);
            g2d.scale(d, d);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.m_interpolation);
            Rectangle rect = g2d.getClipBounds();
            if (rect != null) {
                g2d.drawImage(this.m_img, (int)rect.getX(), (int)rect.getY(), (int)(rect.getX() + rect.getWidth()), (int)(rect.getY() + rect.getHeight()), (int)rect.getX(), (int)rect.getY(), (int)(rect.getX() + rect.getWidth()), (int)(rect.getY() + rect.getHeight()), this);
            }
        }
        return false;
    }

    public int print(Graphics pg, PageFormat pageFormat, int pageIndex) {
        if (this.m_img != null && pageIndex == 0) {
            pg.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
            RepaintManager currentManager = RepaintManager.currentManager(this);
            currentManager.setDoubleBufferingEnabled(false);
            Graphics2D g2d = (Graphics2D)pg;
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            this.doPaint(pg, new Dimension((int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight()), true);
            currentManager.setDoubleBufferingEnabled(true);
            System.gc();
            return 0;
        }
        return 1;
    }
}

