/*
 * Decompiled with CFR 0.152.
 */
package shared.base64;

import java.io.UnsupportedEncodingException;

public class JBase64 {
    private static final char[] m_b64Tbl = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/', '='};

    public static String encode(String str) {
        return JBase64.encode(str, "ISO-8859-1");
    }

    public static String encode(String str, String charSet) {
        String b64Str = null;
        try {
            b64Str = JBase64.encode(str.getBytes(charSet));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return b64Str;
    }

    public static String encode(byte[] buf) {
        return JBase64.encode(buf, 0, buf.length);
    }

    public static String encode(byte[] buf, int offset, int size) {
        int val;
        StringBuffer strBuf = new StringBuffer();
        int i = offset;
        while (size >= 3) {
            val = (buf[i] & 0xFC) >>> 2;
            strBuf.append(m_b64Tbl[val]);
            val = (buf[i++] & 3) << 4;
            strBuf.append(m_b64Tbl[val |= (buf[i] & 0xF0) >>> 4]);
            val = (buf[i++] & 0xF) << 2;
            strBuf.append(m_b64Tbl[val |= (buf[i] & 0xC0) >>> 6]);
            val = buf[i++] & 0x3F;
            strBuf.append(m_b64Tbl[val]);
            size -= 3;
        }
        if (size != 0) {
            if (size == 1) {
                val = (buf[i] & 0xFC) >>> 2;
                strBuf.append(m_b64Tbl[val]);
                val = (buf[i] & 3) << 4;
                strBuf.append(m_b64Tbl[val]);
                strBuf.append(m_b64Tbl[64]);
                strBuf.append(m_b64Tbl[64]);
            } else if (size == 2) {
                val = (buf[i] & 0xFC) >>> 2;
                strBuf.append(m_b64Tbl[val]);
                val = (buf[i++] & 3) << 4;
                strBuf.append(m_b64Tbl[val |= (buf[i] & 0xF0) >>> 4]);
                val = (buf[i] & 0xF) << 2;
                strBuf.append(m_b64Tbl[val]);
                strBuf.append(m_b64Tbl[64]);
            }
        }
        return strBuf.toString();
    }

    public static byte[] decode(String str) {
        byte[] buf = null;
        int size = JBase64.getDataSize(str);
        if (size > 0) {
            int val;
            buf = new byte[size];
            int i = 0;
            int j = 0;
            for (size = str.length() - (str.length() / 4 * 3 - size); size >= 4 && (val = JBase64.getVal(str.charAt(i++))) != -1; size -= 4) {
                int n = j;
                buf[n] = (byte)(buf[n] | val << 2);
                if ((val = JBase64.getVal(str.charAt(i++))) == -1) break;
                int n2 = j++;
                buf[n2] = (byte)(buf[n2] | (val & 0x30) >>> 4);
                int n3 = j;
                buf[n3] = (byte)(buf[n3] | (val & 0xF) << 4);
                if ((val = JBase64.getVal(str.charAt(i++))) == -1) break;
                int n4 = j++;
                buf[n4] = (byte)(buf[n4] | (val & 0x3C) >>> 2);
                int n5 = j;
                buf[n5] = (byte)(buf[n5] | (val & 3) << 6);
                if ((val = JBase64.getVal(str.charAt(i++))) == -1) break;
                int n6 = j++;
                buf[n6] = (byte)(buf[n6] | val & 0x3F);
            }
            if (size == 3) {
                if ((val = JBase64.getVal(str.charAt(i++))) != -1) {
                    int n = j;
                    buf[n] = (byte)(buf[n] | val << 2);
                    if ((val = JBase64.getVal(str.charAt(i++))) != -1) {
                        int n7 = j++;
                        buf[n7] = (byte)(buf[n7] | (val & 0x30) >>> 4);
                        int n8 = j;
                        buf[n8] = (byte)(buf[n8] | (val & 0xF) << 4);
                        if ((val = JBase64.getVal(str.charAt(i++))) != -1) {
                            int n9 = j;
                            buf[n9] = (byte)(buf[n9] | (val & 0x3C) >>> 2);
                            size -= 3;
                        }
                    }
                }
            } else if (size == 2 && (val = JBase64.getVal(str.charAt(i++))) != -1) {
                int n = j;
                buf[n] = (byte)(buf[n] | val << 2);
                if ((val = JBase64.getVal(str.charAt(i++))) != -1) {
                    int n10 = j;
                    buf[n10] = (byte)(buf[n10] | (val & 0x30) >>> 4);
                    size -= 2;
                }
            }
        }
        return (byte[])(size == 0 ? buf : null);
    }

    private static int getVal(char c) {
        for (int i = 0; i < 64; ++i) {
            if (m_b64Tbl[i] != c) continue;
            return i;
        }
        return -1;
    }

    public static int getDataSize(String str) {
        int size = 0;
        assert (str.length() % 4 == 0);
        if (str.length() >= 4) {
            size = str.length() / 4 * 3;
            if (str.charAt(str.length() - 1) == m_b64Tbl[64]) {
                --size;
            }
            if (str.charAt(str.length() - 2) == m_b64Tbl[64]) {
                --size;
            }
        }
        return size;
    }
}

