/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

final class GamePanel
extends JPanel
implements Runnable {
    private int rows;
    private int cols;
    private int mines;
    private Tile[][] tiles;
    private Tile activeTile;
    private Thread watcher;

    GamePanel(int n) {
        switch (n) {
            case 0: {
                this.rows = 9;
                this.cols = 9;
                this.mines = 10;
                break;
            }
            case 1: {
                this.rows = 16;
                this.cols = 16;
                this.mines = 40;
                break;
            }
            case 2: {
                this.rows = 16;
                this.cols = 30;
                this.mines = 99;
                break;
            }
            case 3: {
                this.rows = JMines.getConfig().read("game.custom.rows", 9);
                this.cols = JMines.getConfig().read("game.custom.cols", 9);
                this.mines = JMines.getConfig().read("game.custom.mines", 10);
            }
        }
        this.tiles = new Tile[this.rows][this.cols];
        this.setLayout(new GridLayout(this.rows, this.cols, 1, 1));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createLoweredBevelBorder()));
        this.createTiles();
    }

    int getRows() {
        return this.rows;
    }

    int getCols() {
        return this.cols;
    }

    int getMines() {
        return this.mines;
    }

    void setActiveTile(Tile tile) {
        this.activeTile = tile;
    }

    Tile getActiveTile() {
        return this.activeTile;
    }

    void createTiles() {
        int n = 0;
        while (n < this.rows) {
            int n2 = 0;
            while (n2 < this.cols) {
                this.tiles[n][n2] = new Tile(n, n2);
                this.add(this.tiles[n][n2]);
                ++n2;
            }
            ++n;
        }
    }

    void initTiles() {
        int n = 0;
        while (n < this.rows) {
            int n2 = 0;
            while (n2 < this.cols) {
                this.tiles[n][n2].init();
                this.tiles[n][n2].repaint();
                ++n2;
            }
            ++n;
        }
    }

    void createMines() {
        int n = 0;
        while (n < this.mines) {
            int n2;
            int n3;
            while (this.tiles[n3 = (int)Math.floor((double)this.rows * Math.random())][n2 = (int)Math.floor((double)this.cols * Math.random())].isMine()) {
            }
            this.tiles[n3][n2].setMine(true);
            ++n;
        }
    }

    void countSurroundingMines() {
        int n = 0;
        while (n < this.rows) {
            int n2 = 0;
            while (n2 < this.cols) {
                int n3 = 0;
                if (n == 0) {
                    if (n2 == 0) {
                        if (this.tiles[0][1].isMine()) {
                            ++n3;
                        }
                        if (this.tiles[1][1].isMine()) {
                            ++n3;
                        }
                        if (this.tiles[1][0].isMine()) {
                            ++n3;
                        }
                    } else if (n2 == this.cols - 1) {
                        if (this.tiles[1][n2].isMine()) {
                            ++n3;
                        }
                        if (this.tiles[1][n2 - 1].isMine()) {
                            ++n3;
                        }
                        if (this.tiles[0][n2 - 1].isMine()) {
                            ++n3;
                        }
                    } else {
                        if (this.tiles[0][n2 + 1].isMine()) {
                            ++n3;
                        }
                        if (this.tiles[1][n2 + 1].isMine()) {
                            ++n3;
                        }
                        if (this.tiles[1][n2].isMine()) {
                            ++n3;
                        }
                        if (this.tiles[1][n2 - 1].isMine()) {
                            ++n3;
                        }
                        if (this.tiles[0][n2 - 1].isMine()) {
                            ++n3;
                        }
                    }
                } else if (n == this.rows - 1) {
                    if (n2 == 0) {
                        if (this.tiles[n - 1][0].isMine()) {
                            ++n3;
                        }
                        if (this.tiles[n - 1][1].isMine()) {
                            ++n3;
                        }
                        if (this.tiles[n][1].isMine()) {
                            ++n3;
                        }
                    } else if (n2 == this.cols - 1) {
                        if (this.tiles[n][n2 - 1].isMine()) {
                            ++n3;
                        }
                        if (this.tiles[n - 1][n2 - 1].isMine()) {
                            ++n3;
                        }
                        if (this.tiles[n - 1][n2].isMine()) {
                            ++n3;
                        }
                    } else {
                        if (this.tiles[n][n2 - 1].isMine()) {
                            ++n3;
                        }
                        if (this.tiles[n - 1][n2 - 1].isMine()) {
                            ++n3;
                        }
                        if (this.tiles[n - 1][n2].isMine()) {
                            ++n3;
                        }
                        if (this.tiles[n - 1][n2 + 1].isMine()) {
                            ++n3;
                        }
                        if (this.tiles[n][n2 + 1].isMine()) {
                            ++n3;
                        }
                    }
                } else if (n2 == 0) {
                    if (this.tiles[n - 1][0].isMine()) {
                        ++n3;
                    }
                    if (this.tiles[n - 1][1].isMine()) {
                        ++n3;
                    }
                    if (this.tiles[n][1].isMine()) {
                        ++n3;
                    }
                    if (this.tiles[n + 1][1].isMine()) {
                        ++n3;
                    }
                    if (this.tiles[n + 1][0].isMine()) {
                        ++n3;
                    }
                } else if (n2 == this.cols - 1) {
                    if (this.tiles[n + 1][n2].isMine()) {
                        ++n3;
                    }
                    if (this.tiles[n + 1][n2 - 1].isMine()) {
                        ++n3;
                    }
                    if (this.tiles[n][n2 - 1].isMine()) {
                        ++n3;
                    }
                    if (this.tiles[n - 1][n2 - 1].isMine()) {
                        ++n3;
                    }
                    if (this.tiles[n - 1][n2].isMine()) {
                        ++n3;
                    }
                } else {
                    if (this.tiles[n - 1][n2].isMine()) {
                        ++n3;
                    }
                    if (this.tiles[n - 1][n2 + 1].isMine()) {
                        ++n3;
                    }
                    if (this.tiles[n][n2 + 1].isMine()) {
                        ++n3;
                    }
                    if (this.tiles[n + 1][n2 + 1].isMine()) {
                        ++n3;
                    }
                    if (this.tiles[n + 1][n2].isMine()) {
                        ++n3;
                    }
                    if (this.tiles[n + 1][n2 - 1].isMine()) {
                        ++n3;
                    }
                    if (this.tiles[n][n2 - 1].isMine()) {
                        ++n3;
                    }
                    if (this.tiles[n - 1][n2 - 1].isMine()) {
                        ++n3;
                    }
                }
                this.tiles[n][n2].setCount(n3);
                this.tiles[n][n2].setColor(n3);
                ++n2;
            }
            ++n;
        }
    }

    void revealMines() {
        int n = 0;
        while (n < this.rows) {
            int n2 = 0;
            while (n2 < this.cols) {
                if (this.tiles[n][n2].isMine() && this.tiles[n][n2].getState() != 52) {
                    this.tiles[n][n2].setState(51);
                    this.tiles[n][n2].repaint();
                }
                ++n2;
            }
            ++n;
        }
    }

    void showFlagErrors() {
        int n = 0;
        while (n < this.rows) {
            int n2 = 0;
            while (n2 < this.cols) {
                if (this.tiles[n][n2].getState() == 12 && !this.tiles[n][n2].isMine()) {
                    this.tiles[n][n2].setState(53);
                    this.tiles[n][n2].repaint();
                }
                ++n2;
            }
            ++n;
        }
    }

    void pressSurroundingTiles(int n, int n2) {
        if (n == 0) {
            if (n2 == 0) {
                this.tiles[0][1].press();
                this.tiles[1][1].press();
                this.tiles[1][0].press();
            } else if (n2 == this.cols - 1) {
                this.tiles[1][n2].press();
                this.tiles[1][n2 - 1].press();
                this.tiles[0][n2 - 1].press();
            } else {
                this.tiles[0][n2 + 1].press();
                this.tiles[1][n2 + 1].press();
                this.tiles[1][n2].press();
                this.tiles[1][n2 - 1].press();
                this.tiles[0][n2 - 1].press();
            }
        } else if (n == this.rows - 1) {
            if (n2 == 0) {
                this.tiles[n - 1][0].press();
                this.tiles[n - 1][1].press();
                this.tiles[n][1].press();
            } else if (n2 == this.cols - 1) {
                this.tiles[n][n2 - 1].press();
                this.tiles[n - 1][n2 - 1].press();
                this.tiles[n - 1][n2].press();
            } else {
                this.tiles[n][n2 - 1].press();
                this.tiles[n - 1][n2 - 1].press();
                this.tiles[n - 1][n2].press();
                this.tiles[n - 1][n2 + 1].press();
                this.tiles[n][n2 + 1].press();
            }
        } else if (n2 == 0) {
            this.tiles[n - 1][n2].press();
            this.tiles[n - 1][n2 + 1].press();
            this.tiles[n][n2 + 1].press();
            this.tiles[n + 1][n2 + 1].press();
            this.tiles[n + 1][n2].press();
        } else if (n2 == this.cols - 1) {
            this.tiles[n + 1][n2].press();
            this.tiles[n + 1][n2 - 1].press();
            this.tiles[n][n2 - 1].press();
            this.tiles[n - 1][n2 - 1].press();
            this.tiles[n - 1][n2].press();
        } else {
            this.tiles[n - 1][n2].press();
            this.tiles[n - 1][n2 + 1].press();
            this.tiles[n][n2 + 1].press();
            this.tiles[n + 1][n2 + 1].press();
            this.tiles[n + 1][n2].press();
            this.tiles[n + 1][n2 - 1].press();
            this.tiles[n][n2 - 1].press();
            this.tiles[n - 1][n2 - 1].press();
        }
    }

    void releaseSurroundingTiles(int n, int n2) {
        if (n == 0) {
            if (n2 == 0) {
                this.tiles[0][1].release();
                this.tiles[1][1].release();
                this.tiles[1][0].release();
            } else if (n2 == this.cols - 1) {
                this.tiles[1][n2].release();
                this.tiles[1][n2 - 1].release();
                this.tiles[0][n2 - 1].release();
            } else {
                this.tiles[0][n2 + 1].release();
                this.tiles[1][n2 + 1].release();
                this.tiles[1][n2].release();
                this.tiles[1][n2 - 1].release();
                this.tiles[0][n2 - 1].release();
            }
        } else if (n == this.rows - 1) {
            if (n2 == 0) {
                this.tiles[n - 1][0].release();
                this.tiles[n - 1][1].release();
                this.tiles[n][1].release();
            } else if (n2 == this.cols - 1) {
                this.tiles[n][n2 - 1].release();
                this.tiles[n - 1][n2 - 1].release();
                this.tiles[n - 1][n2].release();
            } else {
                this.tiles[n][n2 - 1].release();
                this.tiles[n - 1][n2 - 1].release();
                this.tiles[n - 1][n2].release();
                this.tiles[n - 1][n2 + 1].release();
                this.tiles[n][n2 + 1].release();
            }
        } else if (n2 == 0) {
            this.tiles[n - 1][n2].release();
            this.tiles[n - 1][n2 + 1].release();
            this.tiles[n][n2 + 1].release();
            this.tiles[n + 1][n2 + 1].release();
            this.tiles[n + 1][n2].release();
        } else if (n2 == this.cols - 1) {
            this.tiles[n + 1][n2].release();
            this.tiles[n + 1][n2 - 1].release();
            this.tiles[n][n2 - 1].release();
            this.tiles[n - 1][n2 - 1].release();
            this.tiles[n - 1][n2].release();
        } else {
            this.tiles[n - 1][n2].release();
            this.tiles[n - 1][n2 + 1].release();
            this.tiles[n][n2 + 1].release();
            this.tiles[n + 1][n2 + 1].release();
            this.tiles[n + 1][n2].release();
            this.tiles[n + 1][n2 - 1].release();
            this.tiles[n][n2 - 1].release();
            this.tiles[n - 1][n2 - 1].release();
        }
    }

    void clickSurroundingTiles(int n, int n2) {
        if (n == 0) {
            if (n2 == 0) {
                this.tiles[0][1].click();
                this.tiles[1][1].click();
                this.tiles[1][0].click();
            } else if (n2 == this.cols - 1) {
                this.tiles[1][n2].click();
                this.tiles[1][n2 - 1].click();
                this.tiles[0][n2 - 1].click();
            } else {
                this.tiles[0][n2 + 1].click();
                this.tiles[1][n2 + 1].click();
                this.tiles[1][n2].click();
                this.tiles[1][n2 - 1].click();
                this.tiles[0][n2 - 1].click();
            }
        } else if (n == this.rows - 1) {
            if (n2 == 0) {
                this.tiles[n - 1][0].click();
                this.tiles[n - 1][1].click();
                this.tiles[n][1].click();
            } else if (n2 == this.cols - 1) {
                this.tiles[n][n2 - 1].click();
                this.tiles[n - 1][n2 - 1].click();
                this.tiles[n - 1][n2].click();
            } else {
                this.tiles[n][n2 - 1].click();
                this.tiles[n - 1][n2 - 1].click();
                this.tiles[n - 1][n2].click();
                this.tiles[n - 1][n2 + 1].click();
                this.tiles[n][n2 + 1].click();
            }
        } else if (n2 == 0) {
            this.tiles[n - 1][n2].click();
            this.tiles[n - 1][n2 + 1].click();
            this.tiles[n][n2 + 1].click();
            this.tiles[n + 1][n2 + 1].click();
            this.tiles[n + 1][n2].click();
        } else if (n2 == this.cols - 1) {
            this.tiles[n + 1][n2].click();
            this.tiles[n + 1][n2 - 1].click();
            this.tiles[n][n2 - 1].click();
            this.tiles[n - 1][n2 - 1].click();
            this.tiles[n - 1][n2].click();
        } else {
            this.tiles[n - 1][n2].click();
            this.tiles[n - 1][n2 + 1].click();
            this.tiles[n][n2 + 1].click();
            this.tiles[n + 1][n2 + 1].click();
            this.tiles[n + 1][n2].click();
            this.tiles[n + 1][n2 - 1].click();
            this.tiles[n][n2 - 1].click();
            this.tiles[n - 1][n2 - 1].click();
        }
    }

    int countRemovedTiles() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.rows) {
            int n3 = 0;
            while (n3 < this.cols) {
                if (this.tiles[n2][n3].getState() == 50) {
                    ++n;
                }
                ++n3;
            }
            ++n2;
        }
        return n;
    }

    int countFlaggedTiles() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.rows) {
            int n3 = 0;
            while (n3 < this.cols) {
                int n4 = this.tiles[n2][n3].getState();
                if (n4 == 12 || n4 == 22) {
                    ++n;
                }
                ++n3;
            }
            ++n2;
        }
        return n;
    }

    void startWatcher() {
        if (this.watcher == null) {
            this.watcher = new Thread(this);
            this.watcher.start();
        }
    }

    void stopWatcher() {
        if (this.watcher != null) {
            this.watcher = null;
        }
    }

    public void run() {
        long l = 0L;
        long l2 = System.currentTimeMillis();
        while (this.watcher != null) {
            l2 += 250L;
            while (l2 > (l = System.currentTimeMillis())) {
                try {
                    Thread.sleep(l2 - l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.countFlaggedTiles() != this.mines || this.countRemovedTiles() != this.rows * this.cols - this.mines) continue;
            JMines.gameOver(true, "Congrats, You win!");
        }
    }
}

