/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

final class Clock
extends JLabel
implements Runnable {
    private Thread clock;
    private boolean isTimeMode;
    private DateFormat tf;
    private DateFormat df;

    Clock() {
        this.setHorizontalAlignment(0);
        this.setBorder(BorderFactory.createCompoundBorder(new EtchedBorder(1), new EmptyBorder(2, 5, 2, 5)));
        this.isTimeMode = JMines.getConfig().read("clock.timemode", true);
        this.tf = DateFormat.getTimeInstance(2);
        this.df = DateFormat.getDateInstance(0);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    Clock.this.isTimeMode = !Clock.this.isTimeMode;
                    Clock.this.setTime(System.currentTimeMillis());
                    JMines.getConfig().write("clock.timemode", Clock.this.isTimeMode);
                }
            }
        });
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.setTime(System.currentTimeMillis());
            this.start();
        } else {
            this.stop();
        }
    }

    private void setTime(long l) {
        Date date = new Date(l);
        this.setText(this.isTimeMode ? this.tf.format(date) : this.df.format(date));
        this.setToolTipText(this.isTimeMode ? this.df.format(date) : this.tf.format(date));
    }

    public void start() {
        if (this.clock == null) {
            this.clock = new Thread(this);
            this.clock.start();
        }
    }

    public void stop() {
        if (this.clock != null) {
            this.clock = null;
        }
    }

    public void run() {
        long l = 0L;
        long l2 = System.currentTimeMillis();
        while (this.clock != null) {
            l2 += 1000L;
            while (l2 > (l = System.currentTimeMillis())) {
                try {
                    Thread.sleep(l2 - l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.setTime(l);
        }
    }
}

