/******************************************************************************
 * Project JKobo
 * XKobo arcade style game
 *
 * Copyright (C) 1997 John "Jake" Wetzel All Rights Reserved
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *****************************************************************************/

/***************************** FILE INFORMATION ******************************
 * NAME OF FILE 	  : MyShip.java
 * CONCEPT & ARCHITECTURE : Akira Higuchi
 * MAIN PROGRAMMER	  : Jake Wetzel
 * DATE CREATED 	  : 10-25-98
 * DESCRIPTION		  :
 * CHANGE LOG		  :
 *	  WHO		  WHEN			  WHY
 *	  ---		  ----			  ---
 *
 *****************************************************************************/

/******************************* IMPORT FILES ********************************/

import java.awt.Graphics;
import java.awt.Image;
import java.lang.Math;
import java.util.Random;

import Enemies;
import Manage;
import ScaleParms;
import Space;


class MyShip implements GlobalDefines, EnemyDefines
{
  static final int NORMAL = 0;
  static final int DEAD   = 1;

  static final int BEAMV1 = 12;
  static final int BEAMV2 = (BEAMV1 * 2 / 3);

  static final int SPACE = 0;
  static final int WALL = 1;
  static final int U_MASK = (1 << 0);
  static final int R_MASK = (1 << 1);
  static final int D_MASK = (1 << 2);
  static final int L_MASK = (1 << 3);
  static final int CORE   = (1 << 4);
  static final int HARD   = (1 << 5);
  static final int HIT_MASK = (CORE | U_MASK | R_MASK | D_MASK | L_MASK);


/******************************** GLOBAL DATA ********************************/

  int state;
  int di;      /* direction */
  int virtx, virty; /* scroll position */
  int x, y;
  int lapx, lapy;
  int beamx[], beamy[];
  int beamdi[], beamst[];
  int beamv1, beamv2;


/**************************** FUNCTION DECLARATIONS  *************************/

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : MyShip
 * DESCRIPTION	  :
 *****************************************************************************/
  MyShip()
  {
    int sl;

    sl = JKobo.Context.getScaleLog2();
    beamx = new int[BEAM_MAX];
    beamy = new int[BEAM_MAX];
    beamdi = new int[BEAM_MAX];
    beamst = new int[BEAM_MAX];
    beamv1 = BEAMV1 << sl;
    beamv2 = BEAMV2 << sl;

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getX
 * DESCRIPTION	  :
 *****************************************************************************/
  final int getX()
  {
    return(x);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getY
 * DESCRIPTION	  :
 *****************************************************************************/
  final int getY()
  {
    return(y);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getVirtX
 * DESCRIPTION	  :
 *****************************************************************************/
  final int getVirtX()
  {
    return(virtx);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getVirtY
 * DESCRIPTION	  :
 *****************************************************************************/
  final int getVirtY()
  {
    return(virty);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : init
 * DESCRIPTION	  :
 *****************************************************************************/
  int init()
  {
    int i, wsize, scrx, scry;
    ScaleParms sp;


    sp = JKobo.Context.getScaleParms();
    wsize = sp.getWindowWidth();
    scrx = sp.getSpaceWidth();
    scry = sp.getSpaceHeight();
    x = scrx >>> 1;
    y = (scry >>> 2) * 3;
    virtx = x - (wsize >>> 1);
    virty = y - (wsize >>> 1);
    lapx = lapy = 0;
    di = 1;
    state = NORMAL;

    for(i=0; i<BEAM_MAX; i++)
      beamx[i] = beamy[i] = beamdi[i] = beamst[i] = 0;

    return(0);

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : move
 * DESCRIPTION	  :
 *****************************************************************************/
  int move()
  {
    int i, sl, scrx, scry;
    int wsize, spr_size;
    PlayWin playwin;


    playwin = JKobo.Context.getPlayWin();
    di = playwin.getDirection();
    wsize = JKobo.Context.getScaleParms().getWindowWidth();
    spr_size = JKobo.Context.getScaleParms().getSpriteWidth();
    virtx = x - (wsize >>> 1);
    virty = y - (wsize >>> 1);
    if(state == NORMAL)
      {
	switch(di)
	  {
	  case 1:
	    virty -= JKobo.Context.getScaleParms().getShipAxisMove();
	    break;
	  case 2:
	    virty -= JKobo.Context.getScaleParms().getShipDiagMove();
	    virtx += JKobo.Context.getScaleParms().getShipDiagMove();
	    break;
	  case 3:
	    virtx += JKobo.Context.getScaleParms().getShipAxisMove();
	    break;
	  case 4:
	    virtx += JKobo.Context.getScaleParms().getShipDiagMove();
	    virty += JKobo.Context.getScaleParms().getShipDiagMove();
	    break;
	  case 5:
	    virty += JKobo.Context.getScaleParms().getShipAxisMove();
	    break;
	  case 6:
	    virty += JKobo.Context.getScaleParms().getShipDiagMove();
	    virtx -= JKobo.Context.getScaleParms().getShipDiagMove();
	    break;
	  case 7:
	    virtx -= JKobo.Context.getScaleParms().getShipAxisMove();
	    break;
	  case 8:
	    virtx -= JKobo.Context.getScaleParms().getShipDiagMove();
	    virty -= JKobo.Context.getScaleParms().getShipDiagMove();
	    break;
	  }
      }
    else if(state == DEAD)
      {
	lapx = JKobo.Context.getRandom().nextInt();
	lapy = JKobo.Context.getRandom().nextInt();
	JKobo.Context.getEnemies().make(EXPLOSION, x + (lapx >>> 26) - 32,
					y + (lapy >>> 26) - 32, 0, 0, 0);
      }

    lapx = lapy = 0;
    scrx = JKobo.Context.getScaleParms().getSpaceWidth();
    scry = JKobo.Context.getScaleParms().getSpaceHeight();
    if(virtx < 0)
      {
	virtx += scrx;
	lapx = scrx;
      }
    if(virtx >= scrx)
      {
	virtx -= scrx;
	lapx = -scrx;
      }
    if(virty < 0)
      {
	virty += scry;
	lapy = scry;
      }
    if(virty >= scry)
      {
	virty -= scry;
	lapy = -scry;
      }
    x = virtx + (wsize >>> 1);
    y = virty + (wsize >>> 1);
    playwin.setXOffset(virtx);
    playwin.setYOffset(virty);

    if((state == NORMAL) && playwin.getShot() == true)
      shot();

    for(i=0; i<BEAM_MAX; i++)
      {
	if(beamst[i] == 0)
	  continue;
	beamx[i] += lapx;
	beamy[i] += lapy;
	switch(beamdi[i])
	  {
	  case 1:
	    beamy[i] -= beamv1;
	    break;
	  case 2:
	    beamy[i] -= beamv2;
	    beamx[i] += beamv2;
	    break;
	  case 3:
	    beamx[i] += beamv1;
	    break;
	  case 4:
	    beamx[i] += beamv2;
	    beamy[i] += beamv2;
	    break;
	  case 5:
	    beamy[i] += beamv1;
	    break;
	  case 6:
	    beamy[i] += beamv2;
	    beamx[i] -= beamv2;
	    break;
	  case 7:
	    beamx[i] -= beamv1;
	    break;
	  case 8:
	    beamx[i] -= beamv2;
	    beamy[i] -= beamv2;
	    break;
	  }
	if((Math.abs(beamx[i] - x) >= (wsize >> 1) + spr_size) ||
	   (Math.abs(beamy[i] - y) >= (wsize >> 1) + spr_size))
	  beamst[i] = 0;
      }

    return(0);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : put
 * DESCRIPTION	  :
 *****************************************************************************/
  int put()
  {
    int i, mx, my;
    int h, w, xshift, yshift;
    PlayWin playwin;
    ScaleParms sp;


    if(state != NORMAL)
      return(0);

    sp = JKobo.Context.getScaleParms();
    playwin = JKobo.Context.getPlayWin();
    mx = playwin.getMouseX();
    my = playwin.getMouseY();
    w = sp.getSpriteWidth();
    h = sp.getSpriteHeight();
    xshift = sp.getSpriteWidthShift();
    yshift = sp.getSpriteHeightShift();
    playwin.copySprite((di - 1) << xshift, 3 << yshift, w, h,
		       x - (w >>> 1), y - (h >>> 1));

    for(i=0; i<BEAM_MAX; i++)
      {
	if(beamst[i] != 0)
	  {
	    playwin.copySprite((beamdi[i] - 1) << xshift, 2 << yshift, w, h,
			       beamx[i] - (w >>> 1), beamy[i] - (h >>> 1));
	  }
      }

    if((mx == 0) && (my == 0))
      return(0);

/*
    playwin.copySprite(15 << xshift, 5 << yshift, 5 << sl, 5 << sl,
		       (x + mx - 2) << sl, (y + my - 2) << sl);
*/

    return(0);

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : shot
 * DESCRIPTION	  :
 *****************************************************************************/
  int shot()
  {
    int i, j;

    for(i=0; i<BEAM_MAX && beamst[i]!=0; i++);
    for(j=i+1; j<BEAM_MAX && beamst[j]!=0; j++);

    if(j >= BEAM_MAX)
      return(1);

    beamdi[i] = di;
    beamx[j] = beamx[i] = x;
    beamy[j] = beamy[i] = y;
    beamst[i] = 1;
    beamdi[j] = (di > 4) ? (di-4) : (di+4);
    beamst[j] = 1;

    return(0);

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : hitStructure
 * DESCRIPTION	  :
 *****************************************************************************/
  int hitStructure()
  {
    int x1, y1, scrx, scry;
    int i, spr_shift;
    Space space;
    ScaleParms sp;


    space = JKobo.Context.getSpace();
    sp = JKobo.Context.getScaleParms();
    scrx = sp.getSpaceWidth();
    scry = sp.getSpaceHeight();
    spr_shift = sp.getSpriteWidthShift();
    for(i=0; i<BEAM_MAX; i++)
      {
	if(beamst[i] == 0)
	  continue;
	x1 = (beamx[i] & (scrx - 1)) >>> spr_shift;
	y1 = (beamy[i] & (scry - 1)) >>> spr_shift;
	if((space.getChipNumber(x1, y1) & HIT_MASK) != 0)
	  beamst[i] = 0;
      }
    x1 = (x & (scrx - 1)) >>> spr_shift;
    y1 = (y & (scry - 1)) >>> spr_shift;
    if((space.getChipNumber(x1, y1) & HIT_MASK) != 0)
      {
	destroyed();
      }

    return(0);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : hitBeam
 * DESCRIPTION	  :
 *****************************************************************************/
  int hitBeam(int ex, int ey, int hitsize)
  {
    int i;

    for(i=0; i<BEAM_MAX; i++)
      {
	if(beamst[i] == 0)
	  continue;
	if(Math.abs(ex-beamx[i]) >= hitsize)
	  continue;
	if(Math.abs(ey-beamy[i]) >= hitsize)
	  continue;
	if(JKobo.Context.getCheatMode() == false)
	  beamst[i] = 0;
	return(1);
      }

    return(0);

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : destroyed
 * DESCRIPTION	  :
 *****************************************************************************/
  void destroyed()
  {

    if(state != NORMAL)
      return;
    JKobo.Context.getManage().lostMyShip();
    state = DEAD;

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : setPosition
 * DESCRIPTION	  :
 *****************************************************************************/
  void setPosition(int px, int py)
  {
    int wsize;


    wsize = JKobo.Context.getScaleParms().getWindowWidth();
    x = px;
    y = py;
    virtx = x - (wsize >>> 1);
    virty = y - (wsize >>> 1);

  }

}  /* END OF CLASS : MyShip */


/* END OF FILE : MyShip.java */

