/******************************************************************************
 * Project JKobo
 * XKobo arcade style game
 *
 * Copyright (C) 1997 John "Jake" Wetzel All Rights Reserved
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *****************************************************************************/

/***************************** FILE INFORMATION ******************************
 * NAME OF FILE 	  : JKobo.java
 * CONCEPT & ARCHITECTURE : Akira Higuchi
 * MAIN PROGRAMMER	  : Jake Wetzel
 * DATE CREATED 	  : 10-25-98
 * DESCRIPTION		  :
 * CHANGE LOG		  :
 *	  WHO		  WHEN			  WHY
 *	  ---		  ----			  ---
 *
 *****************************************************************************/

/******************************* IMPORT FILES ********************************/

import java.lang.String;
import java.util.Random;

import Kobo;


class JKobo implements ErrorDefines
{
  static final String NAME = "JKobo";
  static final String VERSION = "Version 1.6";
  static final String DATE = "Wed Nov  1 18.00.12 JST 1995";
  static final int WAIT_MSEC  = 30;

/******************************** GLOBAL DATA ********************************/

  static Kobo Context;

/**************************** FUNCTION DECLARATIONS  *************************/

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : main
 * DESCRIPTION	  :
 *****************************************************************************/
  public static void main(String args[])
  {
    int i;
    int sprite_policy;
    boolean cheat_mode;
    int scale;
    long wait_msec;
    String locale[];


    wait_msec = WAIT_MSEC;
    scale = sprite_policy = 0;
    cheat_mode = false;
    locale = new String[3];

    for(i=0; i<args.length; i++)
      {
	if(args[i].equalsIgnoreCase("-doublesize"))
	  scale = 1;
	else if(args[i].equalsIgnoreCase("-quadsize"))
	  scale = 2;
	else if(args[i].equalsIgnoreCase("-cheat"))
	  cheat_mode = true;
	else if(args[i].equalsIgnoreCase("-language"))
	  locale[0] = args[++i];
	else if(args[i].equalsIgnoreCase("-country"))
	  locale[1] = args[++i];
	else if(args[i].equalsIgnoreCase("-variant"))
	  locale[2] = args[++i];
	else if(args[i].equalsIgnoreCase("-wait"))
	  {
	    wait_msec = Long.parseLong(args[++i]);
	    if(wait_msec < WAIT_MSEC)
	      wait_msec = WAIT_MSEC;
	  }
	else
	  {
	    System.out.println("\n" + NAME + " " + VERSION);
	    System.out.println("Usage: " + NAME + " [-doublesize]");
	    System.out.println("             [-quadsize]");
	    System.out.println("             [-cheat]");
	    System.out.println("             [-language lang]");
	    System.out.println("             [-country cntry]");
	    System.out.println("             [-variant var]");
	    System.out.println("             [-wait XXX]");
	    System.out.println("");
	    System.exit(1);
	  }
      }

    try
      {
	Context = new Kobo(locale);
	JKobo.Context.setCheatMode(cheat_mode);
	JKobo.Context.setScaleLog2(scale);
	JKobo.Context.setWaitTime(wait_msec);
	JKobo.Context.init();
	JKobo.Context.getManage().init();
      }
    catch(KoboException e)
      {
	System.err.println(e.getMessage());
	System.err.flush();
	if(e.state == FATAL)
	  System.exit(1);
      }

  }

}  /* END OF CLASS : JKobo */


/* END OF FILE : JKobo.java */

