/******************************************************************************
 * Project JKobo
 * XKobo arcade style game
 *
 * Copyright (C) 1997 John "Jake" Wetzel All Rights Reserved
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *****************************************************************************/

/***************************** FILE INFORMATION ******************************
 * NAME OF FILE 	  : Beam.java
 * CONCEPT & ARCHITECTURE : Akira Higuchi
 * MAIN PROGRAMMER	  : Jake Wetzel
 * DATE CREATED 	  : 10-25-98
 * DESCRIPTION		  :
 * CHANGE LOG		  :
 *	  WHO		  WHEN			  WHY
 *	  ---		  ----			  ---
 *
 *****************************************************************************/

/******************************* IMPORT FILES ********************************/

import Enemy;
import ScaleParms;


class Beam extends EnemyKind implements EnemyDefines, GlobalDefines
{

/******************************** GLOBAL DATA ********************************/

/**************************** FUNCTION DECLARATIONS  *************************/

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : Beam
 * DESCRIPTION	  :
 *****************************************************************************/
  Beam()
  {
    int sl;

    sl = JKobo.Context.getScaleLog2();
    score    = 0;
    hitsize  = 2 << sl;
    chipposx = 0;
    chipposy = 0;
    chipsize = 6 << sl;

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : make
 * DESCRIPTION	  :
 *****************************************************************************/
  void make(Enemy e)
  {

    e.di = 1;
    e.shield = -1;

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : move
 * DESCRIPTION	  :
 *****************************************************************************/
  void move(Enemy e)
  {

    if(e.norm >= ((JKobo.Context.getScaleParms().getWindowWidth() >> 1)+
		  (JKobo.Context.getScaleParms().getSpriteWidth() << 1)))
      e.state = NOTUSE;
    if(++e.di > 8)
      e.di = 1;

  }

}  /* END OF CLASS : Beam */


/* END OF FILE : Beam.java */

