/*
 * Decompiled with CFR 0.152.
 */
package org.vafada.jimagemapper;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import org.vafada.jimagemapper.Shape;

public class Rectangle
extends Shape {
    private java.awt.Rectangle _rectangle;

    public Rectangle(int n, int n2, int n3, int n4) {
        this._rectangle = new java.awt.Rectangle(n, n2, n3, n4);
    }

    @Override
    public void draw(Graphics2D graphics2D, double d) {
        java.awt.Rectangle rectangle = this.computeZoomedRectangle(d);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this.active) {
            this.drawHighlighted(graphics2D, d);
        }
    }

    @Override
    public void drawHighlighted(Graphics2D graphics2D, double d) {
        java.awt.Rectangle rectangle = this.computeZoomedRectangle(d);
        graphics2D.setColor(new Color(1.0f, 1.0f, 1.0f, 0.5f));
        graphics2D.fillRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 1, rectangle.height - 1);
    }

    private java.awt.Rectangle computeZoomedRectangle(double d) {
        int n = (int)Math.round((double)this._rectangle.x * d);
        int n2 = (int)Math.round((double)this._rectangle.y * d);
        double d2 = Math.round(this._rectangle.getWidth() * d);
        double d3 = Math.round(this._rectangle.getHeight() * d);
        return new java.awt.Rectangle(n, n2, (int)d2, (int)d3);
    }

    @Override
    public boolean contains(Point point, double d) {
        java.awt.Rectangle rectangle = this.computeZoomedRectangle(d);
        return rectangle.contains(point);
    }

    public int getX() {
        return this._rectangle.x;
    }

    public int getY() {
        return this._rectangle.y;
    }

    public int getHeight() {
        return this._rectangle.height;
    }

    public int getWidth() {
        return this._rectangle.width;
    }

    public static Rectangle computeOriginalRectangle(Rectangle rectangle, double d) {
        int n = (int)Math.round((double)rectangle.getX() / d);
        int n2 = (int)Math.round((double)rectangle.getY() / d);
        int n3 = (int)Math.round((double)rectangle.getWidth() / d);
        int n4 = (int)Math.round((double)rectangle.getHeight() / d);
        return new Rectangle(n, n2, n3, n4);
    }
}

