/*
 * Decompiled with CFR 0.152.
 */
package org.vafada.jimagemapper;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.vafada.jimagemapper.AttributeBean;
import org.vafada.jimagemapper.AttributesDialog;
import org.vafada.jimagemapper.Circle;
import org.vafada.jimagemapper.JImageMapper;
import org.vafada.jimagemapper.Polygon;
import org.vafada.jimagemapper.Rectangle;
import org.vafada.jimagemapper.Shape;

public class DrawingLayer
extends JPanel {
    private int currentShape = 1;
    private List shapes;
    private boolean isMouseUp = true;
    private Point startPoint;
    private Point endPoint;
    private Rectangle currentRectangle;
    private Circle currentCircle;
    private List lines;
    private boolean isDrawingPolygon = false;
    private Shape activeShape;
    private JPopupMenu popupMenu;
    private JImageMapper parent;

    public DrawingLayer(JImageMapper jImageMapper) {
        this.parent = jImageMapper;
        this.lines = new ArrayList();
        this.shapes = new ArrayList();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (DrawingLayer.this.currentShape == 1 || DrawingLayer.this.currentShape == 2) {
                    if (DrawingLayer.this.isMouseUp) {
                        DrawingLayer.this.isMouseUp = false;
                        DrawingLayer.this.startPoint = mouseEvent.getPoint();
                        DrawingLayer.this.endPoint = mouseEvent.getPoint();
                    }
                } else if (DrawingLayer.this.currentShape == 3) {
                    if (!DrawingLayer.this.isDrawingPolygon) {
                        DrawingLayer.this.isDrawingPolygon = true;
                        DrawingLayer.this.lines.clear();
                        DrawingLayer.this.startPoint = mouseEvent.getPoint();
                        DrawingLayer.this.endPoint = mouseEvent.getPoint();
                        DrawingLayer.this.lines.add(DrawingLayer.this.startPoint);
                    }
                } else if (DrawingLayer.this.currentShape == 4 && DrawingLayer.this.activeShape != null && mouseEvent.isPopupTrigger()) {
                    DrawingLayer.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (DrawingLayer.this.currentShape == 1 || DrawingLayer.this.currentShape == 2) {
                    if (!DrawingLayer.this.isMouseUp) {
                        DrawingLayer.this.endPoint = new Point(mouseEvent.getX(), mouseEvent.getY());
                        AttributesDialog attributesDialog = new AttributesDialog(DrawingLayer.this.parent);
                        if (!attributesDialog.isClosed()) {
                            if (DrawingLayer.this.currentShape == 1 && DrawingLayer.this.currentRectangle != null) {
                                DrawingLayer.this.currentRectangle = Rectangle.computeOriginalRectangle(DrawingLayer.this.currentRectangle, DrawingLayer.this.parent.getZoomLevel());
                                DrawingLayer.this.currentRectangle.setAttribute(attributesDialog.getAttributes());
                                DrawingLayer.this.shapes.add(0, DrawingLayer.this.currentRectangle);
                            } else if (DrawingLayer.this.currentShape == 2) {
                                DrawingLayer.this.currentCircle = Circle.computeOriginalCircle(DrawingLayer.this.currentCircle, DrawingLayer.this.parent.getZoomLevel());
                                DrawingLayer.this.currentCircle.setAttribute(attributesDialog.getAttributes());
                                DrawingLayer.this.shapes.add(0, DrawingLayer.this.currentCircle);
                            }
                        }
                        DrawingLayer.this.isMouseUp = true;
                        DrawingLayer.this.repaint();
                    }
                } else if (DrawingLayer.this.currentShape == 3) {
                    if (DrawingLayer.this.isDrawingPolygon) {
                        DrawingLayer.this.startPoint = mouseEvent.getPoint();
                        DrawingLayer.this.endPoint = mouseEvent.getPoint();
                        if (DrawingLayer.this.lines.size() >= 3) {
                            Point point = (Point)DrawingLayer.this.lines.get(0);
                            int n = (int)point.distance(DrawingLayer.this.endPoint);
                            if (n <= 5) {
                                DrawingLayer.this.endPoint = (Point)point.clone();
                                DrawingLayer.this.isDrawingPolygon = false;
                                DrawingLayer.this.lines.add(DrawingLayer.this.endPoint);
                                AttributesDialog attributesDialog = new AttributesDialog(DrawingLayer.this.parent);
                                if (!attributesDialog.isClosed()) {
                                    DrawingLayer.this.addPolygon(attributesDialog.getAttributes());
                                }
                                DrawingLayer.this.lines.clear();
                            } else {
                                DrawingLayer.this.lines.add(DrawingLayer.this.endPoint);
                            }
                        } else {
                            DrawingLayer.this.lines.add(DrawingLayer.this.endPoint);
                        }
                        DrawingLayer.this.repaint();
                    }
                } else if (DrawingLayer.this.currentShape == 4 && DrawingLayer.this.activeShape != null && mouseEvent.isPopupTrigger()) {
                    DrawingLayer.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (!(DrawingLayer.this.currentShape != 1 && DrawingLayer.this.currentShape != 2 || DrawingLayer.this.isMouseUp)) {
                    DrawingLayer.this.endPoint = new Point(mouseEvent.getX(), mouseEvent.getY());
                }
                DrawingLayer.this.repaint();
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (DrawingLayer.this.currentShape == 4 && !DrawingLayer.this.popupMenu.isShowing()) {
                    DrawingLayer.this.activeShape = null;
                    Shape shape2 = null;
                    for (Shape shape2 : DrawingLayer.this.shapes) {
                        if (!shape2.contains(mouseEvent.getPoint(), DrawingLayer.this.parent.getZoomLevel())) continue;
                        DrawingLayer.this.activeShape = shape2;
                        break;
                    }
                    if (DrawingLayer.this.activeShape != null) {
                        DrawingLayer.this.setCursor(Cursor.getPredefinedCursor(12));
                        DrawingLayer.this.activeShape.setActive(true);
                    } else {
                        DrawingLayer.this.setCursor(Cursor.getDefaultCursor());
                    }
                    for (int i = 0; i < DrawingLayer.this.shapes.size(); ++i) {
                        Shape shape3 = (Shape)DrawingLayer.this.shapes.get(i);
                        if (shape3 == DrawingLayer.this.activeShape) continue;
                        shape3.setActive(false);
                    }
                } else if (DrawingLayer.this.currentShape == 3 && DrawingLayer.this.isDrawingPolygon) {
                    DrawingLayer.this.endPoint = new Point(mouseEvent.getX(), mouseEvent.getY());
                }
                DrawingLayer.this.repaint();
            }
        });
        this.popupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Edit");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttributeBean attributeBean = DrawingLayer.this.activeShape.getAttribute();
                AttributesDialog attributesDialog = new AttributesDialog(DrawingLayer.this.parent, attributeBean);
                if (!attributesDialog.isClosed()) {
                    DrawingLayer.this.activeShape.setAttribute(attributesDialog.getAttributes());
                }
                DrawingLayer.this.activeShape.setActive(false);
                DrawingLayer.this.repaint();
                DrawingLayer.this.activeShape = null;
            }
        });
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Delete");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DrawingLayer.this.shapes.remove(DrawingLayer.this.activeShape);
                DrawingLayer.this.activeShape = null;
                DrawingLayer.this.repaint();
            }
        });
        this.popupMenu.add(jMenuItem);
        this.setOpaque(false);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.BLACK);
        if (this.currentShape == 1 || this.currentShape == 2) {
            if (!this.isMouseUp) {
                if (this.currentShape == 1) {
                    this.currentRectangle = this.generateRectangle(this.startPoint, this.endPoint);
                    graphics2D.drawRect(this.currentRectangle.getX(), this.currentRectangle.getY(), this.currentRectangle.getWidth(), this.currentRectangle.getHeight());
                } else if (this.currentShape == 2) {
                    this.currentCircle = this.generateCircle(this.startPoint, this.endPoint);
                    graphics2D.drawOval(this.currentCircle.getX(), this.currentCircle.getY(), this.currentCircle.getDiameter(), this.currentCircle.getDiameter());
                }
            }
        } else if (this.currentShape == 3) {
            n = this.lines.size();
            for (int i = 0; i < n - 1; ++i) {
                Point point = (Point)this.lines.get(i);
                Point point2 = (Point)this.lines.get(i + 1);
                graphics2D.drawLine(point.x, point.y, point2.x, point2.y);
            }
            if (this.isDrawingPolygon) {
                graphics2D.drawLine(this.startPoint.x, this.startPoint.y, this.endPoint.x, this.endPoint.y);
            }
        }
        for (n = this.shapes.size() - 1; n >= 0; --n) {
            Shape shape = (Shape)this.shapes.get(n);
            shape.draw(graphics2D, this.parent.getZoomLevel());
        }
    }

    private Circle generateCircle(Point point, Point point2) {
        int n;
        int n2 = Math.abs(point.y - point2.y);
        int n3 = n2 > (n = Math.abs(point.x - point2.x)) ? n2 : n;
        return new Circle(point.x - n3, point.y - n3, n3 * 2);
    }

    private Rectangle generateRectangle(Point point, Point point2) {
        Point point3 = point;
        Point point4 = point2;
        if (point2.x > point.x && point2.y > point.y) {
            point3 = new Point(point);
            point4 = new Point(point2);
        } else if (point2.x > point.x && point2.y < point.y) {
            point3 = new Point(point.x, point2.y);
            point4 = new Point(point2.x, point.y);
        } else if (point2.x < point.x && point2.y < point.y) {
            point3 = point2;
            point4 = point;
        } else if (point2.x < point.x && point2.y > point.y) {
            point3 = new Point(point2.x, point.y);
            point4 = new Point(point.x, point2.y);
        }
        return new Rectangle(point3.x, point3.y, point4.x - point3.x, point4.y - point3.y);
    }

    private void addPolygon(AttributeBean attributeBean) {
        int[] nArray = new int[this.lines.size()];
        int[] nArray2 = new int[this.lines.size()];
        for (int i = 0; i < this.lines.size(); ++i) {
            Point point = (Point)this.lines.get(i);
            nArray[i] = point.x;
            nArray2[i] = point.y;
        }
        Polygon polygon = new Polygon(nArray, nArray2);
        polygon = Polygon.computeOriginalPolygon(polygon, this.parent.getZoomLevel());
        polygon.setAttribute(attributeBean);
        this.shapes.add(0, polygon);
    }

    public List getShapes() {
        return this.shapes;
    }

    public void setCurrentShape(int n) {
        this.currentShape = n;
    }

    public void deleteShapes() {
        this.lines.clear();
        this.shapes.clear();
        this.repaint();
    }
}

