/*
 * Decompiled with CFR 0.152.
 */
package org.vafada.jimagemapper;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import org.vafada.jimagemapper.Shape;

public class Circle
extends Shape {
    private int x;
    private int y;
    private int diameter;

    public Circle(int n, int n2, int n3) {
        this.x = n;
        this.y = n2;
        this.diameter = n3;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int n) {
        this.x = n;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int n) {
        this.y = n;
    }

    public int getDiameter() {
        return this.diameter;
    }

    public void setDiameter(int n) {
        this.diameter = n;
    }

    public Point getCenter() {
        int n = this.diameter / 2;
        int n2 = this.x + n;
        int n3 = this.y + n;
        return new Point(n2, n3);
    }

    public int getRadius() {
        return this.diameter / 2;
    }

    @Override
    public boolean contains(Point point, double d) {
        int n = (int)((double)this.x * d);
        int n2 = (int)((double)this.diameter * d);
        int n3 = n2 / 2;
        int n4 = n + n3;
        int n5 = (int)((double)this.y * d);
        int n6 = n5 + n3;
        Point point2 = new Point(n4, n6);
        return point2.distance(point) - (double)(n2 / 2) <= 2.0;
    }

    @Override
    public void draw(Graphics2D graphics2D, double d) {
        int n = (int)Math.round((double)this.x * d);
        int n2 = (int)Math.round((double)this.y * d);
        int n3 = (int)Math.round((double)this.diameter * d);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawOval(n, n2, n3, n3);
        if (this.active) {
            this.drawHighlighted(graphics2D, d);
        }
    }

    @Override
    public void drawHighlighted(Graphics2D graphics2D, double d) {
        int n = (int)Math.round((double)this.x * d);
        int n2 = (int)Math.round((double)this.y * d);
        int n3 = (int)Math.round((double)this.diameter * d);
        graphics2D.setColor(new Color(1.0f, 1.0f, 1.0f, 0.5f));
        graphics2D.fillOval(n, n2, n3, n3);
    }

    public static Circle computeOriginalCircle(Circle circle, double d) {
        int n = (int)Math.round((double)circle.x / d);
        int n2 = (int)Math.round((double)circle.y / d);
        int n3 = (int)Math.round((double)circle.diameter / d);
        return new Circle(n, n2, n3);
    }
}

