/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.print;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.gerhardb.lib.print.PreviewPanel;
import org.gerhardb.lib.print.PreviewablePage;
import org.gerhardb.lib.print.PrintJobUtils;
import org.gerhardb.lib.print.PrintUtils;
import org.gerhardb.lib.print.PrintableBase;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.swing.SwingUtils;
import org.gerhardb.lib.util.Icons;
import org.gerhardb.lib.util.startup.AppStarter;

public class PageablePreviewer {
    private PrintableBase myPrintableBase;
    PreviewablePage myPreviewablePage;
    PreviewPanel myPreviewPanel;
    int myCurrentPageZeroBased = -1;
    int myLastPageZeroBased = 0;
    JButton myFirst = new JButton(AppStarter.getString("PageablePreviewer.0"));
    JButton myPrior = new JButton(AppStarter.getString("PageablePreviewer.1"));
    JButton myNext = new JButton(AppStarter.getString("PageablePreviewer.2"));
    JButton myLast = new JButton(AppStarter.getString("PageablePreviewer.3"));
    JButton[] myActionBtns;
    JFrame myFrame = new JFrame(AppStarter.getString("print.preview"));

    public PageablePreviewer(final PrintableBase pageable, JProgressBar bar, boolean exitOnClose) {
        JButton highResButton = new JButton(AppStarter.getString("ContactSheetPrintOptions.3"));
        highResButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PageFormat showMe = PageablePreviewer.this.getSavedPageFormat(pageable);
                PrintableBase printMe = pageable.makeCopy();
                printMe.setPageFormat(showMe);
                PrintUtils.threadedDefaultPrint(printMe, PageablePreviewer.this.myFrame);
            }
        });
        JButton lowResButton = new JButton(AppStarter.getString("ContactSheetPrintOptions.4"));
        lowResButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PrintJobUtils.threadedDefaultPrint(PageablePreviewer.this.myPrintableBase, PageablePreviewer.this.myFrame);
            }
        });
        JButton[] printButtons = new JButton[]{lowResButton};
        this.go(pageable, printButtons, bar, exitOnClose);
    }

    public PageablePreviewer(PrintableBase pageable, JButton[] buttons, JProgressBar bar, boolean exitOnClose) {
        this.go(pageable, buttons, bar, exitOnClose);
    }

    private PageFormat getSavedPageFormat(PrintableBase pageable) {
        PageFormat defaultFormat = pageable.getPageFormat(0);
        Paper p = new Paper();
        p.setImageableArea(defaultFormat.getImageableX(), defaultFormat.getImageableY(), defaultFormat.getImageableWidth(), defaultFormat.getImageableHeight());
        p.setSize(defaultFormat.getWidth(), defaultFormat.getHeight());
        PageFormat rtnMe = new PageFormat();
        rtnMe.setPaper(p);
        rtnMe.setOrientation(1);
        return rtnMe;
    }

    private void go(PrintableBase pageable, JButton[] buttons, JProgressBar bar, boolean exitOnClose) {
        this.myPrintableBase = pageable;
        this.myActionBtns = buttons;
        this.myLastPageZeroBased = this.myPrintableBase.getNumberOfPages() - 1;
        this.myPreviewablePage = new PreviewablePage(this.myPrintableBase, this);
        this.myPreviewPanel = new PreviewPanel(this.myPreviewablePage);
        if (exitOnClose) {
            this.myFrame.setDefaultCloseOperation(3);
            this.myFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
        }
        this.setupDialog(bar);
        this.showPreview(0);
        this.myFrame.setIconImage(Icons.icon(26).getImage());
        this.myFrame.setVisible(true);
    }

    private void showPreview(int page) {
        this.myCurrentPageZeroBased = page;
        if (this.myCurrentPageZeroBased < 1) {
            this.myCurrentPageZeroBased = 0;
        } else if (this.myCurrentPageZeroBased > this.myLastPageZeroBased) {
            this.myCurrentPageZeroBased = this.myLastPageZeroBased;
        }
        this.myPreviewablePage.setPageIndex(this.myCurrentPageZeroBased);
        this.updateButtons();
    }

    void updateButtons() {
        if (this.myCurrentPageZeroBased > 0) {
            this.myPrior.setEnabled(true);
        } else {
            this.myPrior.setEnabled(false);
        }
        if (this.myLastPageZeroBased > 0) {
            this.myLast.setEnabled(true);
        } else {
            this.myLast.setEnabled(false);
        }
        if (this.myCurrentPageZeroBased < this.myLastPageZeroBased) {
            this.myNext.setEnabled(true);
        } else {
            this.myNext.setEnabled(false);
        }
    }

    void painting(boolean painting) {
        for (int i = 0; i < this.myActionBtns.length; ++i) {
            this.myActionBtns[i].setEnabled(!painting);
        }
        this.myFirst.setEnabled(!painting);
        if (painting) {
            this.myPrior.setEnabled(false);
            this.myNext.setEnabled(false);
            this.myLast.setEnabled(false);
        } else {
            this.updateButtons();
        }
    }

    void setupDialog(JProgressBar bar) {
        this.myFirst.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PageablePreviewer.this.myFrame.setCursor(Cursor.getPredefinedCursor(3));
                PageablePreviewer.this.showPreview(0);
                PageablePreviewer.this.myFrame.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        this.myPrior.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PageablePreviewer.this.myFrame.setCursor(Cursor.getPredefinedCursor(3));
                PageablePreviewer.this.showPreview(PageablePreviewer.this.myCurrentPageZeroBased - 1);
                PageablePreviewer.this.myFrame.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        this.myNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PageablePreviewer.this.myFrame.setCursor(Cursor.getPredefinedCursor(3));
                PageablePreviewer.this.showPreview(PageablePreviewer.this.myCurrentPageZeroBased + 1);
                PageablePreviewer.this.myFrame.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        this.myLast.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PageablePreviewer.this.myFrame.setCursor(Cursor.getPredefinedCursor(3));
                PageablePreviewer.this.showPreview(PageablePreviewer.this.myLastPageZeroBased);
                PageablePreviewer.this.myFrame.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        JButton closeBtn = new JButton(AppStarter.getString("close"));
        closeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PageablePreviewer.this.myFrame.dispose();
            }
        });
        JPanelRows bottomPanel = new JPanelRows(1);
        JPanel aRow = bottomPanel.topRow(1);
        if (this.myLastPageZeroBased > 0) {
            aRow.add(this.myFirst);
            aRow.add(this.myPrior);
            aRow.add(this.myNext);
            aRow.add(this.myLast);
            aRow = bottomPanel.nextRow(1);
        }
        for (int i = 0; i < this.myActionBtns.length; ++i) {
            aRow.add(this.myActionBtns[i]);
        }
        aRow.add(closeBtn);
        if (bar != null) {
            aRow = bottomPanel.nextRow(new BorderLayout());
            bar.setIndeterminate(false);
            bar.setStringPainted(false);
            aRow.add((Component)bar, "Center");
        }
        JPanel content = new JPanel(new BorderLayout());
        content.add((Component)this.myPreviewPanel, "Center");
        content.add((Component)bottomPanel, "South");
        this.myFrame.setContentPane(content);
        SwingUtils.sizeScreen(this.myFrame, 0.6f);
        SwingUtils.centerOnScreen(this.myFrame);
    }
}

