/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.image;

import java.io.File;
import java.util.HashSet;
import javax.imageio.ImageIO;
import org.gerhardb.lib.image.IOImage;
import org.gerhardb.lib.image.IOImageJava;
import org.gerhardb.lib.image.ImageFactoryPlugin;

class ImageFactoryJava
implements ImageFactoryPlugin {
    static String[] clsEndings;

    ImageFactoryJava() {
    }

    public String[] getEndingsLowercase() {
        return clsEndings;
    }

    public boolean canHandle(File aFile) {
        String name = aFile.getName().toLowerCase();
        for (int i = 0; i < clsEndings.length; ++i) {
            if (!name.endsWith(clsEndings[i])) continue;
            return true;
        }
        return false;
    }

    public IOImage makeImage(File aFile) throws Exception {
        return new IOImageJava(aFile);
    }

    public String toString() {
        return "Java-ImageIO";
    }

    public static void main(String[] args) {
        ImageFactoryJava factory = new ImageFactoryJava();
        String[] endings = factory.getEndingsLowercase();
        for (int i = 0; i < endings.length; ++i) {
            System.out.println(endings[i]);
        }
    }

    static {
        HashSet<String> endingsSet = new HashSet<String>();
        String[] javaEndings = ImageIO.getReaderFormatNames();
        for (int i = 0; i < javaEndings.length; ++i) {
            endingsSet.add(javaEndings[i].toLowerCase());
        }
        clsEndings = endingsSet.toArray(new String[endingsSet.size()]);
    }
}

