/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.image;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.prefs.Preferences;
import org.gerhardb.lib.image.IOImage;
import org.gerhardb.lib.image.ImageFactoryImageJ;
import org.gerhardb.lib.image.ImageFactoryJava;
import org.gerhardb.lib.image.ImageFactoryPlugin;
import org.gerhardb.lib.image.ImageFactorySanselan;
import org.gerhardb.lib.io.FilenameFileFilter;
import org.gerhardb.lib.util.startup.AppStarter;

public class ImageFactory {
    public static String[] TEXT_ENDINGS = new String[]{".txt", ".htm", ".html", ".nat"};
    private static Preferences clsPrefs;
    private static ImageFactory clsImageFactory;
    private FilenameFileFilter myFilter = new FilenameFileFilter();
    private ImageFactoryPlugin[] myPlugins;
    private String[] myPluginsNot;
    private static final String SHOW_TEXT_FILES = "showTextFiles";

    public static ImageFactory getImageFactory() {
        if (clsImageFactory == null) {
            ImageFactory.loadPlugins();
        }
        return clsImageFactory;
    }

    public static void loadPlugins() {
        clsImageFactory = new ImageFactory();
    }

    private ImageFactory() {
        System.out.println("ImageFactory Classpath: " + System.getProperty("java.class.path"));
        ArrayList<ImageFactoryPlugin> plugins = new ArrayList<ImageFactoryPlugin>(20);
        ArrayList pluginsNot = new ArrayList(20);
        plugins.add(new ImageFactoryJava());
        plugins.add(new ImageFactorySanselan());
        plugins.add(new ImageFactoryImageJ());
        this.myPlugins = plugins.toArray(new ImageFactoryPlugin[plugins.size()]);
        this.myPluginsNot = pluginsNot.toArray(new String[pluginsNot.size()]);
        clsPrefs = Preferences.userRoot().node("org/gerhardb/lib/image/ImageFactory");
        this.updateEndings();
    }

    private void updateEndings() {
        HashSet<String> endingsSet = new HashSet<String>();
        for (int i = 0; i < this.myPlugins.length; ++i) {
            String[] someEndings = this.myPlugins[i].getEndingsLowercase();
            for (int j = 0; j < someEndings.length; ++j) {
                endingsSet.add(someEndings[j]);
            }
        }
        if (this.isTextFilesShowingPreferenceSet()) {
            for (int j = 0; j < TEXT_ENDINGS.length; ++j) {
                endingsSet.add(TEXT_ENDINGS[j]);
            }
        }
        String[] allEndings = endingsSet.toArray(new String[endingsSet.size()]);
        this.myFilter.setEndings(allEndings);
    }

    public FilenameFileFilter getFilter() {
        return this.myFilter;
    }

    public String[] getImagePluginsListing() {
        String[] rtnMe = new String[this.myPlugins.length];
        for (int i = 0; i < this.myPlugins.length; ++i) {
            StringBuffer buff = new StringBuffer(200);
            buff.append(this.myPlugins[i].toString());
            buff.append(": ");
            String[] endings = this.myPlugins[i].getEndingsLowercase();
            for (int j = 0; j < endings.length; ++j) {
                if (j > 0) {
                    buff.append(", ");
                }
                buff.append(endings[j]);
            }
            rtnMe[i] = buff.toString();
        }
        return rtnMe;
    }

    public String[] getImagePluginsNotLoadedListing() {
        return this.myPluginsNot;
    }

    public IOImage makeImage(File aFile) throws Exception {
        if (aFile == null) {
            throw new Exception("Null files not allowed");
        }
        if (!aFile.exists()) {
            throw new Exception(AppStarter.getString("ImageFactory.0") + AppStarter.getString("colon") + " " + aFile);
        }
        for (int i = 0; i < this.myPlugins.length; ++i) {
            if (!this.myPlugins[i].canHandle(aFile)) continue;
            try {
                IOImage rtnMe = this.myPlugins[i].makeImage(aFile);
                if (rtnMe == null) continue;
                return rtnMe;
            }
            catch (Exception ex) {
                System.out.println(this.myPlugins[i] + " could NOT handle: " + ex.getMessage());
            }
        }
        throw new Exception("No plugin handled image");
    }

    public IOImage makeImageEZ(File aFile) {
        try {
            return this.makeImage(aFile);
        }
        catch (Exception x) {
            System.out.println(x.getMessage());
            return null;
        }
    }

    public BufferedImage getImageEZ(File file) {
        try {
            IOImage io = this.makeImage(file);
            return io.getImage();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean isTextFilesShowingPreferenceSet() {
        return clsPrefs.getBoolean(SHOW_TEXT_FILES, false);
    }

    public void setTextFilesShowingPreference(boolean enabled) {
        clsPrefs.putBoolean(SHOW_TEXT_FILES, enabled);
        this.updateEndings();
    }

    public static void main(String[] args) {
        System.out.println(ImageFactory.getImageFactory().getFilter().toString());
        String[] formats = ImageFactory.getImageFactory().getImagePluginsListing();
        for (int i = 0; i < formats.length; ++i) {
            System.out.println(formats[i]);
        }
        System.out.println("------------------------------------------------------------------------");
        try {
            ImageFactory.getImageFactory().makeImage(new File("D:/testpics/bad/a.jpg"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

