/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.dirtree.rdp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.tree.DefaultTreeModel;
import org.gerhardb.lib.dirtree.DTNReader;
import org.gerhardb.lib.dirtree.DTNReaderWriter;
import org.gerhardb.lib.dirtree.DirectoryTree;
import org.gerhardb.lib.dirtree.DirectoryTreeNode;
import org.gerhardb.lib.dirtree.rdp.ListShowTreeCoordinator;
import org.gerhardb.lib.dirtree.rdp.PathManager;
import org.gerhardb.lib.util.ICancel;
import org.gerhardb.lib.util.startup.AppStarter;
import org.gerhardb.lib.util.startup.ILoadingMessage;
import org.gerhardb.lib.util.startup.Loading;

public class TreeManager {
    DirectoryTreeNode myRootNode;
    DTNReaderWriter myReaderWriter;
    ListShowTreeCoordinator myCoordinator;

    public TreeManager(ListShowTreeCoordinator coordinator) {
        this.myCoordinator = coordinator;
        this.myReaderWriter = new DTNReaderWriter(this.myCoordinator.myLSTplugins.getAppIDandTargetType(), this.myCoordinator.myLSTplugins.getCountTargetFiles(), PathManager.getStartingJibsFile());
        this.myCoordinator.myRDPmanager.myTreeManager = this;
    }

    public DTNReaderWriter getDTNReaderWriter() {
        return this.myReaderWriter;
    }

    public void reloadAllNodes() {
        this.myRootNode.reloadNodes();
    }

    public void setDirectory(String dir) {
        try {
            this.myCoordinator.myRDPmanager.myPlugins.getPathManager().setDirectory(0, dir);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.myCoordinator.myRDPmanager.getMoveManager().setUndoOff();
        this.loadSavedTreeDirectory(dir);
    }

    public void store() throws Exception {
        this.myReaderWriter.getWriter().store(this.myRootNode);
    }

    public void setTreeDirectory() {
        int returnVal;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(AppStarter.getString("TreeManager.0"));
        chooser.setFileSelectionMode(1);
        String treeDirectoryName = this.myCoordinator.myPathManager.getDirectoryAbsolute(0);
        if (treeDirectoryName != null) {
            chooser.setCurrentDirectory(new File(treeDirectoryName));
        }
        if ((returnVal = chooser.showOpenDialog(this.myCoordinator.myRDPmanager.myPlugins.getTopFrame())) == 0) {
            try {
                treeDirectoryName = chooser.getSelectedFile().getCanonicalPath();
                if (treeDirectoryName != null) {
                    this.setDirectory(treeDirectoryName);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void loadSavedTreeDirectory(final String savedTreeDirectoryName) {
        final Loading newLoading = new Loading(this.myCoordinator.myRDPmanager.myPlugins.getTopFrame());
        Runnable runMe = new Runnable(){

            public void run() {
                File rootDirFile = new File(savedTreeDirectoryName);
                TreeManager.this.showViewTree(rootDirFile, TreeManager.this.myCoordinator.myRDPmanager.myPlugins.getExtendedDirectoryTree(), newLoading);
                newLoading.dispose();
            }
        };
        newLoading.start(runMe);
    }

    public void showViewTree(File rootDirectoryOrFile, DirectoryTree dirTree, Loading loading) {
        try {
            this.myRootNode = this.makeRootNode(rootDirectoryOrFile, dirTree, loading);
            DefaultTreeModel daModel = new DefaultTreeModel(this.myRootNode);
            dirTree.setModel(daModel);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    private DirectoryTreeNode makeRootNode(File rootDirectory, DirectoryTree tree, Loading loading) throws FileNotFoundException, SecurityException {
        if (!rootDirectory.exists()) {
            throw new FileNotFoundException(AppStarter.getString("TreeManager.1") + " " + rootDirectory + " " + AppStarter.getString("TreeManager.2"));
        }
        if (rootDirectory.isFile()) {
            throw new FileNotFoundException(rootDirectory + " " + AppStarter.getString("TreeManager.3"));
        }
        DirectoryTreeNode.resetRecursiveLoading();
        loading.setCancel(new ICancel(){

            public void cancel() {
                DirectoryTreeNode.cancelRecursiveLoading();
            }
        });
        DirectoryTreeNode rootNode = null;
        if (this.myCoordinator.myBasicOptionsManager.getRememberDirectories()) {
            rootNode = this.populateFromStored(rootDirectory, tree, loading);
        } else {
            loading.setText(AppStarter.getString("TreeManager.5"));
        }
        if (rootNode == null) {
            rootNode = new DirectoryTreeNode(tree, rootDirectory, loading);
            rootNode.populate(loading);
        }
        loading.setCancel(null);
        return rootNode;
    }

    private DirectoryTreeNode populateFromStored(File rootDirectory, DirectoryTree tree, ILoadingMessage loadingMsg) {
        DTNReader reader = this.myReaderWriter.getReader(rootDirectory, tree, loadingMsg);
        return reader.getRootNode();
    }
}

