/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.viewer.shows.full;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.gerhardb.jibs.viewer.IFrame;
import org.gerhardb.jibs.viewer.IRevert;
import org.gerhardb.jibs.viewer.PicInfoDialog;
import org.gerhardb.jibs.viewer.ViewerPreferences;
import org.gerhardb.jibs.viewer.shows.full.JImage;
import org.gerhardb.lib.image.ImageChangeUtil;
import org.gerhardb.lib.playlist.ScrollerChangeEvent;
import org.gerhardb.lib.playlist.ScrollerListener;
import org.gerhardb.lib.playlist.ScrollerSlider;
import org.gerhardb.lib.util.Misc;

public class FullScreen
implements ScrollerListener,
IRevert {
    private IFrame myFrame;
    private JFrame mySurface;
    private JImage myImagePanel = new JImage();
    private JPanel myTopPanel = new JPanel(new BorderLayout());
    private JPanel myBottomPanel = new JPanel(new BorderLayout());
    private GraphicsEnvironment myGE = GraphicsEnvironment.getLocalGraphicsEnvironment();
    private GraphicsDevice myGD = this.myGE.getDefaultScreenDevice();
    private boolean iBlowUp = ViewerPreferences.blowUp();
    private int maxBlow = ViewerPreferences.getMaxBlow();

    public FullScreen(IFrame mf, boolean startNow) {
        this.myFrame = mf;
        this.myFrame.getScroller().setEndMessages(true);
        this.myBottomPanel.setVisible(false);
        this.myImagePanel.setFocusable(true);
        this.mySurface = new JFrame(this.myGD.getDefaultConfiguration());
        this.mySurface.setUndecorated(true);
        this.mySurface.setFocusableWindowState(true);
        this.mySurface.setFocusable(true);
        this.mySurface.setCursor(Misc.getTransparentCursor());
        JToolBar bottomRight = new JToolBar();
        bottomRight.setFloatable(false);
        bottomRight.add(this.myFrame.getActions().makeSaveButton());
        bottomRight.add(this.myFrame.getActions().getAction("file", "saveas"));
        bottomRight.add(this.myFrame.getActions().getAction("edit", "left"));
        bottomRight.add(this.myFrame.getActions().getAction("edit", "right"));
        bottomRight.add(this.myFrame.getActions().getToolBarButton("file", "trash"));
        bottomRight.add(this.myFrame.getActions().getToolBarButton("file", "park"));
        bottomRight.add(this.myFrame.getActions().getToolBarButton("file", "repeat"));
        ScrollerSlider slider = new ScrollerSlider(0, this.myFrame.getScroller());
        this.myBottomPanel.add((Component)slider, "Center");
        this.myBottomPanel.add((Component)bottomRight, "East");
        this.myTopPanel.add((Component)this.myImagePanel, "Center");
        this.myTopPanel.add((Component)this.myBottomPanel, "South");
        this.mySurface.setContentPane(this.myTopPanel);
        this.mySurface.addKeyListener(this.myFrame.getScroller().getScrollerKeyListener());
        this.mySurface.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                switch (event.getKeyCode()) {
                    case 10: {
                        if ((event.getModifiersEx() & 0x80) == 128) {
                            FullScreen.this.revert();
                        }
                        if ((event.getModifiersEx() & 0x200) == 512) {
                            FullScreen.this.revert();
                        }
                        event.consume();
                        return;
                    }
                }
            }

            public void keyReleased(KeyEvent event) {
                switch (event.getKeyCode()) {
                    case 112: {
                        FullScreen.this.revert();
                        FullScreen.this.myFrame.showHelp();
                        event.consume();
                        return;
                    }
                    case 27: 
                    case 113: {
                        FullScreen.this.revert();
                        event.consume();
                        return;
                    }
                    case 114: {
                        FullScreen.this.toggleBottom();
                        event.consume();
                        return;
                    }
                }
            }
        });
        this.mySurface.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent event) {
                if (event.isPopupTrigger() || event.getButton() == 2 || event.getButton() == 3) {
                    if (FullScreen.this.myFrame.getScroller().isBeyond()) {
                        return;
                    }
                    int width = -1;
                    int height = -1;
                    try {
                        BufferedImage image = FullScreen.this.myFrame.getScroller().getCurrentImage();
                        width = image.getWidth();
                        height = image.getHeight();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    new PicInfoDialog(FullScreen.this.myFrame.getScroller().getCurrentFile(), FullScreen.this.mySurface, FullScreen.this.myImagePanel, FullScreen.this, FullScreen.this.myFrame.getActions().getToolBarButton("file", "trash"), FullScreen.this.myFrame.getActions().getToolBarButton("file", "park"), true, width, height, true, FullScreen.this.myFrame.getScroller());
                } else {
                    FullScreen.this.myFrame.getScroller().down();
                }
            }
        });
        try {
            if (ViewerPreferences.getGDFullScreen()) {
                this.myGD.setFullScreenWindow(this.mySurface);
            } else {
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice gd = ge.getDefaultScreenDevice();
                DisplayMode dm = gd.getDisplayMode();
                Dimension dim = new Dimension(dm.getWidth(), dm.getHeight());
                this.myImagePanel.setPreferredSize(dim);
                this.mySurface.pack();
                this.mySurface.setVisible(true);
            }
            this.scrollerChanged(null);
            this.myFrame.getScroller().setAutoFocus(this.mySurface);
            this.myFrame.getScroller().addScrollerListener(this);
            this.myImagePanel.requestFocus(true);
            this.mySurface.requestFocus();
            if (startNow) {
                this.startShow();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public JFrame getFrame() {
        return this.mySurface;
    }

    public void scrollerChanged(ScrollerChangeEvent ce) {
        if (!this.myFrame.getScroller().getValueIsAdjusting()) {
            BufferedImage image = null;
            try {
                image = this.myFrame.getScroller().getCurrentImage();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (image == null) {
                image = this.myFrame.getScroller().getBeyondBounds();
                if (image != null) {
                    this.myImagePanel.setImage(image);
                }
                return;
            }
            if (this.iBlowUp) {
                Rectangle clip = this.myImagePanel.getVisibleRect();
                double clipWidth = clip.getWidth();
                double clipHeight = clip.getHeight();
                if (clipWidth > 0.0 && clipHeight > 0.0) {
                    int imgHeight;
                    int imgWidth = image.getWidth();
                    float thetaDown = ImageChangeUtil.calcThetaDown(imgWidth, imgHeight = image.getHeight(), clipWidth, clipHeight);
                    if (thetaDown > 0.0f && (double)thetaDown < 1.0) {
                        image = ImageChangeUtil.scale(image, thetaDown);
                    } else if (this.iBlowUp) {
                        float thetaUp = ImageChangeUtil.calcThetaUp(imgWidth, imgHeight, clipWidth, clipHeight);
                        if (thetaUp > (float)this.maxBlow) {
                            image = ImageChangeUtil.scale(image, this.maxBlow);
                        } else if (thetaUp > 0.0f) {
                            image = ImageChangeUtil.scale(image, thetaUp);
                        }
                    }
                }
            }
            this.myImagePanel.setImage(image);
        }
    }

    public void revert() {
        this.myFrame.getScroller().stopSlideShow();
        this.myFrame.getScroller().removeScrollerListener(this);
        this.myImagePanel.setCursor(Cursor.getPredefinedCursor(3));
        this.myImagePanel.setBackground(Color.darkGray);
        this.myImagePanel.setImage(null);
        Runnable runSwitch = new Runnable(){

            public void run() {
                FullScreen.this.myGD.setFullScreenWindow(null);
                FullScreen.this.mySurface.setVisible(false);
                FullScreen.this.mySurface.dispose();
                FullScreen.this.myFrame.setWaitCursor(true);
                FullScreen.this.myFrame.gotoRegularScreen();
                FullScreen.this.myFrame.setWaitCursor(false);
            }
        };
        EventQueue.invokeLater(runSwitch);
    }

    public boolean isFullScreen() {
        return true;
    }

    public void startShow() {
        this.myFrame.getScroller().startSlideShow(ViewerPreferences.continuousShow());
    }

    private void toggleBottom() {
        if (this.myBottomPanel.isShowing()) {
            this.myBottomPanel.setVisible(false);
            this.mySurface.setCursor(Misc.getTransparentCursor());
            this.myTopPanel.revalidate();
        } else {
            this.myBottomPanel.setVisible(true);
            this.mySurface.setCursor(Cursor.getDefaultCursor());
            this.myTopPanel.revalidate();
        }
    }
}

