/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.viewer.shows.comic;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import org.gerhardb.jibs.viewer.ViewerPreferences;
import org.gerhardb.jibs.viewer.shows.comic.ComicScreen;
import org.gerhardb.lib.image.ImageChangeUtil;

public class ThumbnailImage
extends JComponent {
    private float THUMBNAIL_PROPORTION_IN_FRAME = 0.9f;
    private int maxBlow = ViewerPreferences.getMaxBlow();
    private BufferedImage myImage;

    public ThumbnailImage() {
        super.setOpaque(true);
        super.setBackground(ComicScreen.BACKGROUND_COLOR);
    }

    public void setImage(BufferedImage image) {
        this.myImage = image;
        this.repaint();
    }

    protected void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        BufferedImage sizedImage = this.getSizedImage(this.myImage);
        if (sizedImage != null) {
            int centerX = (super.getWidth() - sizedImage.getWidth()) / 2;
            int centerY = (super.getHeight() - sizedImage.getHeight()) / 2;
            graphics.drawImage(sizedImage, centerX, centerY, this);
        }
    }

    private BufferedImage getSizedImage(BufferedImage image) {
        int imgHeight;
        if (image == null) {
            return image;
        }
        Rectangle clip = super.getVisibleRect();
        double clipWidth = clip.getWidth() * (double)this.THUMBNAIL_PROPORTION_IN_FRAME;
        double clipHeight = clip.getHeight() * (double)this.THUMBNAIL_PROPORTION_IN_FRAME;
        if (clipWidth == 0.0 && clipHeight == 0.0) {
            return null;
        }
        int imgWidth = image.getWidth();
        float thetaDown = ImageChangeUtil.calcThetaDown(imgWidth, imgHeight = image.getHeight(), clipWidth, clipHeight);
        if (thetaDown > 0.0f && (double)thetaDown < 1.0) {
            image = ImageChangeUtil.scale(image, thetaDown);
        } else {
            float thetaUp = ImageChangeUtil.calcThetaUp(imgWidth, imgHeight, clipWidth, clipHeight);
            if (thetaUp > (float)this.maxBlow) {
                image = ImageChangeUtil.scale(image, this.maxBlow);
            } else if (thetaUp > 0.0f) {
                image = ImageChangeUtil.scale(image, thetaUp);
            }
        }
        return image;
    }
}

