/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.viewer.shows.classic;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.File;
import org.gerhardb.jibs.viewer.IFrame;
import org.gerhardb.jibs.viewer.shows.classic.SingleNoResize;
import org.gerhardb.jibs.viewer.sorter.TilePanel;

public class SingleNoResizeKeyControl
extends SingleNoResize {
    public SingleNoResizeKeyControl(IFrame mf) {
        super(mf);
    }

    public void showImage(Graphics g) {
        Color backgroundColor = OK_COLOR;
        BufferedImage showMe = this.mySaver.getCurrentImage();
        if (showMe == null) {
            showMe = this.myViewerFrame.getScroller().getBeyondBounds();
            if (showMe == null) {
                super.showNoPicture(g);
                return;
            }
            backgroundColor = EMPTY_COLOR;
        }
        this.myShownWidth = showMe.getWidth();
        this.myShownHeight = showMe.getHeight();
        super.setBackground(backgroundColor);
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        int offsetWidth = (int)((float)(this.getWidth() - this.myShownWidth) * this.myOffsetWidthPercentage);
        int offsetHeight = (int)((float)(this.getHeight() - this.myShownHeight) * this.myOffsetHeightPercentage);
        g2.drawImage(showMe, null, offsetWidth, offsetHeight);
        if (this.myViewerFrame.getScroller().getCurrentIOImage() != null) {
            File file = this.myViewerFrame.getScroller().getCurrentIOImage().getFile();
            TilePanel.clsTilePanel.clip(file, g2, super.getWidth(), super.getHeight());
        }
        this.myViewerFrame.statusCurrentPage();
    }

    KeyListener getKeyListener() {
        return new KeyActions();
    }

    private class KeyActions
    implements KeyListener {
        boolean iAmScrolling = false;

        private KeyActions() {
        }

        public void keyTyped(KeyEvent event) {
        }

        public void keyPressed(KeyEvent event) {
            if (!event.isConsumed()) {
                switch (event.getKeyCode()) {
                    case 10: {
                        if ((event.getModifiersEx() & 0x80) == 128) {
                            SingleNoResizeKeyControl.this.revert();
                        }
                        if ((event.getModifiersEx() & 0x200) == 512) {
                            SingleNoResizeKeyControl.this.revert();
                        }
                        event.consume();
                        return;
                    }
                }
                if (event.getKeyCode() == 18) {
                    this.iAmScrolling = true;
                } else if (event.isAltDown()) {
                    this.processScroll(event);
                }
            }
        }

        public void keyReleased(KeyEvent event) {
            if (!event.isConsumed()) {
                if (event.getKeyCode() == 18) {
                    this.iAmScrolling = false;
                } else if (event.isAltDown()) {
                    SingleNoResizeKeyControl.this.processNumPad(event);
                } else if (!this.iAmScrolling) {
                    this.processFuncitionKeys(event);
                }
                if (this.iAmScrolling) {
                    event.consume();
                }
            }
        }

        private void processFuncitionKeys(KeyEvent event) {
            switch (event.getKeyCode()) {
                case 113: {
                    SingleNoResizeKeyControl.this.myViewerFrame.gotoFullScreen(false);
                    event.consume();
                    return;
                }
                case 115: {
                    SingleNoResizeKeyControl.this.myOptions.setFullSizeTileTo(5);
                    SingleNoResizeKeyControl.this.showImage();
                    event.consume();
                    return;
                }
            }
        }

        private void processScroll(KeyEvent event) {
            switch (event.getKeyCode()) {
                case 38: {
                    event.consume();
                    float pixels = (float)(SingleNoResizeKeyControl.this.getHeight() - SingleNoResizeKeyControl.this.myShownHeight) * SingleNoResizeKeyControl.this.myOffsetHeightPercentage;
                    if (pixels > (float)(-SingleNoResizeKeyControl.this.myShownHeight)) {
                        SingleNoResizeKeyControl.this.myOffsetHeightPercentage = SingleNoResizeKeyControl.this.myShownHeight < SingleNoResizeKeyControl.this.getHeight() ? (SingleNoResizeKeyControl.this.myOffsetHeightPercentage -= 0.1f) : (SingleNoResizeKeyControl.this.myOffsetHeightPercentage += 0.1f);
                    }
                    SingleNoResizeKeyControl.this.repaint();
                    return;
                }
                case 40: {
                    event.consume();
                    float pixels = (float)(SingleNoResizeKeyControl.this.getHeight() - SingleNoResizeKeyControl.this.myShownHeight) * SingleNoResizeKeyControl.this.myOffsetHeightPercentage;
                    if (pixels < (float)SingleNoResizeKeyControl.this.getHeight()) {
                        SingleNoResizeKeyControl.this.myOffsetHeightPercentage = SingleNoResizeKeyControl.this.myShownHeight < SingleNoResizeKeyControl.this.getHeight() ? (SingleNoResizeKeyControl.this.myOffsetHeightPercentage += 0.1f) : (SingleNoResizeKeyControl.this.myOffsetHeightPercentage -= 0.1f);
                    }
                    SingleNoResizeKeyControl.this.repaint();
                    return;
                }
                case 37: {
                    event.consume();
                    float pixels = (float)(SingleNoResizeKeyControl.this.getWidth() - SingleNoResizeKeyControl.this.myShownWidth) * SingleNoResizeKeyControl.this.myOffsetWidthPercentage;
                    if (pixels > (float)(-SingleNoResizeKeyControl.this.myShownWidth)) {
                        SingleNoResizeKeyControl.this.myOffsetWidthPercentage = SingleNoResizeKeyControl.this.myShownWidth < SingleNoResizeKeyControl.this.getWidth() ? (SingleNoResizeKeyControl.this.myOffsetWidthPercentage -= 0.1f) : (SingleNoResizeKeyControl.this.myOffsetWidthPercentage += 0.1f);
                    }
                    SingleNoResizeKeyControl.this.repaint();
                    return;
                }
                case 39: {
                    event.consume();
                    float pixels = (float)(SingleNoResizeKeyControl.this.getWidth() - SingleNoResizeKeyControl.this.myShownWidth) * SingleNoResizeKeyControl.this.myOffsetWidthPercentage;
                    if (pixels < (float)SingleNoResizeKeyControl.this.getWidth()) {
                        SingleNoResizeKeyControl.this.myOffsetWidthPercentage = SingleNoResizeKeyControl.this.myShownWidth < SingleNoResizeKeyControl.this.getWidth() ? (SingleNoResizeKeyControl.this.myOffsetWidthPercentage += 0.1f) : (SingleNoResizeKeyControl.this.myOffsetWidthPercentage -= 0.1f);
                    }
                    SingleNoResizeKeyControl.this.repaint();
                    return;
                }
            }
        }
    }
}

