/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.viewer.frame;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.tree.TreePath;
import javax.swing.undo.UndoableEdit;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.viewer.IFrame;
import org.gerhardb.jibs.viewer.IShow;
import org.gerhardb.jibs.viewer.PicInfoScrollPane;
import org.gerhardb.jibs.viewer.ViewerPreferences;
import org.gerhardb.jibs.viewer.frame.LSTX;
import org.gerhardb.jibs.viewer.frame.LoadingShow;
import org.gerhardb.jibs.viewer.frame.Popups;
import org.gerhardb.jibs.viewer.frame.SelectedItemCountListener;
import org.gerhardb.jibs.viewer.frame.SlideShowManager;
import org.gerhardb.jibs.viewer.frame.ViewerActions;
import org.gerhardb.jibs.viewer.shows.comic.ComicScreen;
import org.gerhardb.jibs.viewer.shows.full.FullScreen;
import org.gerhardb.jibs.viewer.sorter.SorterPanel;
import org.gerhardb.jibs.viewer.tree.FileTreePopUp;
import org.gerhardb.jibs6.Jibs6Hacks;
import org.gerhardb.lib.dirtree.DirectoryTreeNode;
import org.gerhardb.lib.dirtree.ExtendedDirectoryTree;
import org.gerhardb.lib.dirtree.IScrollDirTree;
import org.gerhardb.lib.dirtree.IUndo;
import org.gerhardb.lib.dirtree.filelist.FileList;
import org.gerhardb.lib.dirtree.filelist.FileListManager;
import org.gerhardb.lib.dirtree.filelist.FileListPlugins;
import org.gerhardb.lib.dirtree.rdp.BasicOptionsManager;
import org.gerhardb.lib.dirtree.rdp.IListShowTree;
import org.gerhardb.lib.dirtree.rdp.ILoad;
import org.gerhardb.lib.dirtree.rdp.ListShowTreeCoordinator;
import org.gerhardb.lib.dirtree.rdp.MoveManager;
import org.gerhardb.lib.dirtree.rdp.PathManager;
import org.gerhardb.lib.dirtree.rdp.RDPmanager;
import org.gerhardb.lib.dirtree.rdp.RDPplugins;
import org.gerhardb.lib.dirtree.rdp.TreeManager;
import org.gerhardb.lib.dirtree.rdp.TreeManagerSet;
import org.gerhardb.lib.image.ImageFactory;
import org.gerhardb.lib.io.FilenameFileFilter;
import org.gerhardb.lib.playlist.KeypadOps;
import org.gerhardb.lib.playlist.Scroller;
import org.gerhardb.lib.playlist.ScrollerChangeEvent;
import org.gerhardb.lib.playlist.ScrollerListener;
import org.gerhardb.lib.playlist.ScrollerSlider;
import org.gerhardb.lib.swing.SwingUtils;
import org.gerhardb.lib.swing.UIMenu;
import org.gerhardb.lib.util.ActionHelpers;
import org.gerhardb.lib.util.Icons;
import org.gerhardb.lib.util.Range;
import org.gerhardb.lib.util.startup.ActiveActions;
import org.gerhardb.lib.util.startup.AppStarter;
import org.gerhardb.lib.util.startup.Loading;

public class SortScreen
extends JFrame
implements IListShowTree,
IFrame,
IUndo,
IScrollDirTree,
TreeManagerSet,
FileListPlugins,
ILoad {
    public static final int TREE_MIN = 100;
    public static final int FILE_MIN = 100;
    public static final int EXIF_MIN = 0;
    boolean iNeedToFinalize = true;
    boolean iWasMaximized = false;
    boolean iNeedToInitializeShow = true;
    private JSplitPane myExifPicturePanel;
    JSplitPane myListPicturePanel = new JSplitPane(1);
    JSplitPane myListPictureTreePanel = new JSplitPane(1);
    IShow myShow = new LoadingShow();
    private PicInfoScrollPane myExifInfo;
    JMenuBar myMenuBar = new JMenuBar();
    ScrollerSlider mySlider;
    JToolBar myToolBar = new JToolBar();
    ViewerActions myActions;
    UIMenu myUImenu = new UIMenu(this, this.getAppIDandTargetType());
    Popups myPopups = new Popups(this);
    public SlideShowManager mySlideShowManager;
    public SorterPanel mySorterPanel;
    JMenu myMenuView;
    JMenuItem myItemViewOptions;
    private Loading myLoading;
    private boolean iAmFullScreen = false;
    JPanel myCenterPanel;
    private JFrame myCurrentTopFrame = this;
    private ListShowTreeCoordinator myLST;

    public SortScreen() {
        super("JIBS");
        try {
            ViewerPreferences.init();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, Jibs.getString("SortScreen.2") + ex.getMessage(), Jibs.getString("SortScreen.3"), 0);
            ex.printStackTrace();
        }
        this.myLST = new LSTX(this, this);
        this.myActions = new ViewerActions(this);
        try {
            new ActiveActions.MenuOverrides(this.myActions);
        }
        catch (NoClassDefFoundError ex) {
            ex.printStackTrace();
        }
        catch (UnsupportedClassVersionError ex) {
            ex.printStackTrace();
        }
        this.myLST.addActions(this.myActions);
        this.mySlideShowManager = new SlideShowManager(this);
        super.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SortScreen.this.exit();
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                SortScreen.this.exit();
            }
        });
        this.myLoading = new Loading(this);
        Runnable runMe = new Runnable(){

            public void run() {
                try {
                    SortScreen.this.build();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(SortScreen.this, Jibs.getString("SortScreen.5") + ex.getMessage() + "\n" + Jibs.getString("SortScreen.7") + "gerhardb@users.sourceforge.net", Jibs.getString("SortScreen.9"), 0);
                    ex.printStackTrace();
                }
            }
        };
        this.myLoading.start(runMe);
    }

    public String getAppIDandTargetType() {
        return "Images";
    }

    public JFrame getTopFrame() {
        return this;
    }

    public void showFile(File file) {
        this.myShow.showImage();
    }

    public ScrollerListener getScrollerListener() {
        return null;
    }

    public FilenameFileFilter getFilenameFileFilter() {
        return ImageFactory.getImageFactory().getFilter();
    }

    public boolean getCountTargetFiles() {
        return ViewerPreferences.countImageFilesInNodes();
    }

    public JPopupMenu getPopupMenu(TreePath path) {
        return new FileTreePopUp(this.myLST.getTree(), path, ViewerPreferences.countImageFilesInNodes());
    }

    public ListShowTreeCoordinator getLST() {
        return this.myLST;
    }

    public ExtendedDirectoryTree getTree() {
        return this.myLST.getTree();
    }

    public FileListManager getFileListManager() {
        return this.myLST.getFileListManager();
    }

    public TreeManager getTreeManager() {
        return this.myLST.getTreeManager();
    }

    public Range showingIndexes() {
        return this.myShow.showingIndexes();
    }

    public Scroller getScroller() {
        return this.myLST.getScroller();
    }

    public RDPplugins getRDPplugins() {
        return this.myLST;
    }

    public PathManager getPathManager() {
        return this.myLST.getPathManager();
    }

    public MoveManager getMoveManager() {
        return this.getRDPmanager().getMoveManager();
    }

    public void reloadScroller(int scrollBackTo) {
        this.myShow.reloadScroller(scrollBackTo);
    }

    public void reloadScroller() {
        this.myShow.reloadScroller();
    }

    public boolean isFullScreen() {
        return this.iAmFullScreen;
    }

    public int getResetRecommendation() {
        return this.getFileList().getResetRecommendation();
    }

    public void setCurrentDirectory(DirectoryTreeNode[] nodes, boolean nonTarget) {
        this.getFileListManager().setTargetDir(nodes, nonTarget);
    }

    public void setCurrentDirectory(DirectoryTreeNode node, boolean nonTarget) {
        this.getFileListManager().setTargetDir(node, nonTarget);
    }

    public void selectFiles(File[] filesToSelect) {
        this.getFileList().selectFiles(filesToSelect);
    }

    public void fileListUpdated() {
        this.mySlideShowManager.setSlideShowButtons(true);
    }

    public void addUndoable(UndoableEdit edit) {
        this.getRDPmanager().getMoveManager().addUndoable(edit);
    }

    public void redid() {
        this.myShow.reloadScroller();
    }

    public void undid(File file) {
        this.myShow.jumpTo(file);
    }

    public void setWaitCursor(boolean wait) {
        if (wait) {
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void gotoFullScreen(boolean startNow) {
        this.iWasMaximized = super.getExtendedState() == 6;
        FullScreen fs = new FullScreen(this, startNow);
        this.myCurrentTopFrame = fs.getFrame();
        super.setVisible(false);
        this.iAmFullScreen = true;
    }

    public void gotoComicScreen() {
        this.iWasMaximized = super.getExtendedState() == 6;
        ComicScreen comics = new ComicScreen(this);
        if (comics.isFullScreen()) {
            this.iAmFullScreen = true;
            this.myCurrentTopFrame = comics.getFrame();
            super.setVisible(false);
        }
    }

    public ViewerActions getActions() {
        return this.myActions;
    }

    public JFrame getFrame() {
        return this;
    }

    public ScrollerSlider getSlider() {
        return this.mySlider;
    }

    public FileList getFileList() {
        return this.myLST.getFileList();
    }

    public JFrame getCurrentTopFrame() {
        return this.myCurrentTopFrame;
    }

    public void gotoRegularScreen() {
        this.iAmFullScreen = false;
        this.myCurrentTopFrame = this;
        this.myShow.resetFocus();
        this.myShow.showImage();
        if (this.iWasMaximized) {
            super.setExtendedState(6);
        }
        this.initializeShow();
        super.setVisible(true);
    }

    public void setViewer(IShow show) {
        super.setCursor(Cursor.getPredefinedCursor(3));
        this.statusCurrentPage();
        if (this.myShow != null) {
            this.myShow.disconnect();
        }
        this.myShow = show;
        show.getSaver().resetToolbar();
        if (this.myItemViewOptions != null) {
            this.myMenuView.remove(this.myItemViewOptions);
        }
        this.myItemViewOptions = this.myShow.makePreferencesItem();
        if (this.myItemViewOptions != null) {
            this.myMenuView.add(this.myItemViewOptions);
        }
        this.myShow.connect();
        JComponent picturePanel = this.myShow.getImageDisplay();
        if (this.myExifPicturePanel != null) {
            int exifDividerLocation = this.myExifPicturePanel.getDividerLocation();
            this.myExifInfo.setPicturePanel(picturePanel);
            this.myExifPicturePanel.setRightComponent(picturePanel);
            this.myExifPicturePanel.setDividerLocation(exifDividerLocation);
        } else {
            this.myListPicturePanel.setRightComponent(picturePanel);
        }
        this.myLST.getScroller().requestFocus();
        super.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void showHelp() {
        boolean showedDesktopDialog = false;
        try {
            if (AppStarter.isJava6Enabled()) {
                showedDesktopDialog = Jibs6Hacks.helpToBrowser((JFrame)this);
            }
        }
        catch (NoClassDefFoundError ex) {
            JOptionPane.showMessageDialog(this, Jibs.getString("SortScreen.10"), Jibs.getString("SortScreen.51"), 1);
        }
        if (!showedDesktopDialog) {
            JOptionPane.showMessageDialog(this, Jibs.getString("SortScreen.10"), Jibs.getString("SortScreen.51"), 1);
        }
    }

    public void statusCurrentPage() {
        this.myLST.getStatusBarManager().statusCurrentPage();
    }

    public KeypadOps getKeypadOps() {
        return this.getRDPmanager();
    }

    public ExtendedDirectoryTree getExtendedDirectoryTree() {
        return this.getTree();
    }

    public IShow getShow() {
        return this.myShow;
    }

    public RDPmanager getRDPmanager() {
        return this.myLST.getRDPmanager();
    }

    public Popups getPopups() {
        return this.myPopups;
    }

    private void build() {
        this.loadingMsg("Waking Up!");
        this.mySlider = new ScrollerSlider(1, this.myLST.getScroller());
        this.mySlider.setInverted(true);
        this.mySlider.applyComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        this.getFileList().setModel(this.myLST.getScroller());
        this.myLST.getScroller().getScrollerKeyListener().setKeypadOps(this.getRDPmanager());
        File loadFile = new File(this.myLST.getPathManager().getDirectoryAbsolute(0));
        this.myLST.load(loadFile, this.myLoading, this, Thread.currentThread());
        this.loadingMsg(Jibs.getString("SortScreen.13"));
        this.enableEvents(64L);
        try {
            this.initMenuAndToolbar();
            this.layoutComponents();
            this.getRDPmanager().getMoveManager().updateUndoRedoButtons();
            this.mySlideShowManager.setupSlideShowListener();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("*** Unkonwn abnormal termination ***");
            System.exit(0);
        }
        this.myLST.getScroller().setSlideFlipDelay(ViewerPreferences.getSlideFlipDelay());
        this.setIconImage(Icons.icon(26).getImage());
        this.myUImenu.initLookAndFeel();
        SwingUtils.sizeScreen(this, 0.75f);
        this.validate();
        this.myListPictureTreePanel.setDividerLocation(this.myCenterPanel.getWidth() - ViewerPreferences.getTreePanelSize());
        SwingUtils.centerOnScreen(this);
        if (this.myItemViewOptions != null) {
            this.myMenuView.remove(this.myItemViewOptions);
            this.myMenuView.add(this.myItemViewOptions);
        }
        System.out.println("Loading Thread Complete.  Now joining awtComplete()");
    }

    boolean shouldBeFullScreen() {
        return ViewerPreferences.startFullScreen() && this.mySlideShowManager.myFullScreenBtn.isEnabled();
    }

    public void awtComplete() {
        this.showDefaultDirectory();
        if (this.shouldBeFullScreen()) {
            this.myLoading.dispose();
            this.myLoading = null;
            this.gotoFullScreen(ViewerPreferences.immediateShow());
        } else {
            this.gotoRegularScreen();
            this.initializeShow();
            this.myLST.getScroller().requestFocus();
            this.myLoading.dispose();
            this.myLoading = null;
        }
        System.out.println("\n**************************************************** \n*         JIBS Background Population Ended         * \n**************************************************** \n");
        String JIBS_2_8_0_NEEDS_INIT = "JIBS_2_8_0_NEEDS_INIT";
        if (ViewerPreferences.getPrefs().getBoolean(JIBS_2_8_0_NEEDS_INIT, true)) {
            JOptionPane.showMessageDialog(this, "Settings may have been reset", "Note", -1);
            this.myPopups.showSetup(1);
            ViewerPreferences.getPrefs().putBoolean(JIBS_2_8_0_NEEDS_INIT, false);
        }
    }

    synchronized void initializeShow() {
        if (this.iNeedToInitializeShow) {
            this.iNeedToInitializeShow = false;
            ViewerPreferences.setViewFrame(this);
            SwingUtils.centerOnScreen(this);
        }
    }

    void showDefaultDirectory() {
        String dir = null;
        if (PathManager.overrideStartPassedIn()) {
            dir = this.myLST.getPathManager().getDirectoryAbsolute(3);
        } else {
            BasicOptionsManager bom = this.myLST.getBasicOptionsManager();
            switch (bom.getStartType()) {
                case 2: {
                    dir = this.myLST.getPathManager().getDirectoryAbsolute(3);
                    try {
                        this.getFileListManager().setTargetDir(this.myLST.getPathManager().getDirectoryAbsolute(3));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    break;
                }
                case 1: {
                    dir = this.myLST.getPathManager().getDirectoryAbsolute(4);
                    break;
                }
            }
        }
        try {
            if (dir != null) {
                this.getFileListManager().setTargetDir(dir);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.mySlideShowManager.setSlideShowButtons(true);
    }

    private void layoutComponents() throws Exception {
        this.setSize(new Dimension(600, 600));
        this.setJMenuBar(this.myMenuBar);
        JScrollPane listComponent = new JScrollPane(this.getFileList());
        JPanel treePanel = new JPanel(false);
        listComponent.setMinimumSize(new Dimension(100, 50));
        treePanel.setMinimumSize(new Dimension(100, 50));
        if (ViewerPreferences.isExifPanelShowing()) {
            this.myExifInfo = new PicInfoScrollPane(true);
            this.myExifPicturePanel = new JSplitPane(1);
            ScrollerListener picChangeListener = new ScrollerListener(){

                public void scrollerChanged(ScrollerChangeEvent ce) {
                    File currentFile = SortScreen.this.myLST.getScroller().getCurrentFile();
                    SortScreen.this.myExifInfo.update(currentFile, SortScreen.this.myShow.getImageDisplay().getWidth(), SortScreen.this.myShow.getImageDisplay().getHeight());
                }
            };
            this.myLST.getScroller().addScrollerListener(picChangeListener);
            this.myExifInfo.setPicturePanel(this.myShow.getImageDisplay());
            this.myExifPicturePanel.setLeftComponent(this.myExifInfo);
            this.myExifPicturePanel.setRightComponent(this.myShow.getImageDisplay());
            this.myExifPicturePanel.setOneTouchExpandable(true);
            this.myExifPicturePanel.setDividerLocation(ViewerPreferences.getExifPanelSize());
            this.myListPicturePanel.setRightComponent(this.myExifPicturePanel);
        } else {
            this.myListPicturePanel.setRightComponent(this.myShow.getImageDisplay());
        }
        this.myListPicturePanel.setLeftComponent(listComponent);
        this.myListPicturePanel.setOneTouchExpandable(true);
        this.myListPicturePanel.setDividerLocation(ViewerPreferences.getListPicturePanelDividerLocation());
        this.myListPictureTreePanel.setLeftComponent(this.myListPicturePanel);
        this.myListPictureTreePanel.setRightComponent(treePanel);
        this.myListPictureTreePanel.setOneTouchExpandable(true);
        this.myListPictureTreePanel.setResizeWeight(1.0);
        this.mySorterPanel = new SorterPanel(this);
        this.myCenterPanel = new JPanel(new BorderLayout());
        this.myCenterPanel.add((Component)this.mySlider, "West");
        this.myCenterPanel.add((Component)this.myListPictureTreePanel, "Center");
        this.myCenterPanel.add((Component)this.mySorterPanel, "South");
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.myToolBar, "North");
        mainPanel.add((Component)this.myCenterPanel, "Center");
        mainPanel.add((Component)this.myLST.getStatusBarManager().getStatusPanel(), "South");
        this.getContentPane().add(mainPanel);
        treePanel.setLayout(new GridLayout());
        treePanel.add(new JScrollPane(this.getTree()));
    }

    private void initMenuAndToolbar() throws Exception {
        this.myLST.getScroller().setFrame(this);
        this.myMenuView = this.myActions.getViewMenu(this);
        this.myMenuBar.add(this.myActions.getFileMenu());
        this.myMenuBar.add(this.myActions.getEditMenu());
        this.myMenuBar.add(this.myLST.getSortManager().getSortMenu());
        this.myMenuBar.add(this.myMenuView);
        this.myMenuBar.add(this.myActions.getToolsMenu());
        this.myMenuBar.add(this.myActions.getToysMenu());
        this.myMenuBar.add(this.myUImenu.populateUIMenu(ActionHelpers.makeMenu("ui")));
        this.myMenuBar.add(Box.createHorizontalGlue());
        this.myMenuBar.add(this.myActions.getHelpMenu());
        this.myToolBar.add(this.myActions.makeSaveButton());
        this.myToolBar.add(this.myActions.getToolBarButton("file", "saveas"));
        this.myToolBar.add(this.myActions.getToolBarButton("file", "rename"));
        this.myToolBar.addSeparator();
        this.myToolBar.add(this.getRDPmanager().getMoveManager().getUndoButton());
        this.myToolBar.add(this.getRDPmanager().getMoveManager().getRedoButton());
        this.myToolBar.addSeparator();
        this.getFileListManager().addButtonsToToolBar(this.myToolBar, this.myActions);
        this.myToolBar.add(this.myActions.getToolBarButton("view", "reload"));
        this.myToolBar.addSeparator();
        this.myToolBar.add(this.myActions.getToolBarButton("edit", "left"));
        this.myToolBar.add(this.myActions.getToolBarButton("edit", "right"));
        this.myToolBar.add(this.myActions.getToolBarButton("edit", "shrink"));
        this.myToolBar.add(this.myActions.getToolBarButton("edit", "grow"));
        this.myToolBar.addSeparator();
        this.myToolBar.add(this.mySlideShowManager.getFullScreenButton());
        this.myToolBar.add(this.myActions.getToolBarButton("view", "comic"));
        this.myToolBar.add(this.mySlideShowManager.getFullScreenSlideShowButton());
        this.myToolBar.add(this.mySlideShowManager.getSlideShowButton());
        this.myToolBar.addSeparator();
        JButton clearBtn = this.myActions.getToolBarButton("edit", "clear");
        SelectedItemCountListener selectionCouter = new SelectedItemCountListener(this.getFileList(), clearBtn);
        this.myToolBar.add(selectionCouter.getToolBarLabel());
        this.myToolBar.add(clearBtn);
        this.myToolBar.addSeparator();
        this.myToolBar.add(Box.createHorizontalGlue());
        this.getRDPmanager().addButtonsToToolbar(this.myToolBar);
        this.myToolBar.addSeparator();
        this.myToolBar.add(this.myActions.getToolBarButton("help", "about"));
        this.myToolBar.add(this.myActions.getToolBarButton("help", "help"));
    }

    void loadingMsg(String msg) {
        if (this.myLoading != null) {
            this.myLoading.setMessage(msg);
        }
    }

    void exit() {
        if (this.iNeedToFinalize) {
            this.myShow.disconnect();
            this.iNeedToFinalize = false;
            if (this.myExifPicturePanel != null) {
                ViewerPreferences.setExifPanleSize(this.myExifPicturePanel.getDividerLocation());
            }
            ViewerPreferences.setListPicturePanelDividerLocation(this.myListPicturePanel.getDividerLocation());
            int w = this.myCenterPanel.getWidth() - this.myListPictureTreePanel.getDividerLocation();
            ViewerPreferences.setTreePanleSize(w);
            this.myLST.storeDirectories();
            this.myLST.getPathManager().flush();
            ViewerPreferences.flush();
            System.out.println("**************************************************** \n*               JIBS Exited Normally               * \n**************************************************** \n");
            System.out.println("JIBS OUT");
            AppStarter.closeDownApp();
            System.exit(0);
        }
    }
}

