/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.viewer.contact;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.viewer.contact.ContactSheetOptions;
import org.gerhardb.lib.print.PageablePreviewer;
import org.gerhardb.lib.print.PrintJobUtils;
import org.gerhardb.lib.print.PrintUtils;
import org.gerhardb.lib.print.PrintableBase;
import org.gerhardb.lib.swing.JPanelRows;

public class ContactSheetPrintOptions {
    ContactSheetOptions myBase;
    private static final String PAGE_WIDTH = "PAGE_WIDTH";
    private static final String PAGE_HEIGHT = "PAGE_HEIGHT";
    private static final String PRINTABLE_X = "PRINTABLE_X";
    private static final String PRINTABLE_Y = "PRINTABLE_Y";
    private static final String PRINTABLE_WIDTH = "PRINTABLE_WIDTH";
    private static final String PRINTABLE_HEIGHT = "PRINTABLE_HEIGHT";
    private static final String ORIENTATION = "ORIENTATION";

    ContactSheetPrintOptions(ContactSheetOptions base) {
        this.myBase = base;
        this.myBase.myContactSheet.setPageFormat(this.getSavedPageFormat());
    }

    private JButton[] makePrintBtns() {
        JButton[] rtnMe = new JButton[2];
        rtnMe[0] = new JButton(Jibs.getString("ContactSheetPrintOptions.3"));
        rtnMe[0].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ContactSheetPrintOptions.this.print();
            }
        });
        rtnMe[1] = new JButton(Jibs.getString("ContactSheetPrintOptions.4"));
        rtnMe[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PrintJobUtils.threadedDefaultPrint(ContactSheetPrintOptions.this.myBase.myContactSheet, ContactSheetPrintOptions.this.myBase.myFrame);
            }
        });
        return rtnMe;
    }

    JPanel getPanel() {
        JButton pageBtn = new JButton(Jibs.getString("ContactSheetOptions.2"));
        pageBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PageFormat showMe = ContactSheetPrintOptions.this.getSavedPageFormat();
                System.out.println("PageFormat A: " + PrintJobUtils.showPageFormat(showMe));
                PageFormat saveMe = PrintJobUtils.pageFormatDialog(showMe);
                System.out.println("PageFormat B: " + PrintJobUtils.showPageFormat(saveMe));
                ContactSheetPrintOptions.this.myBase.myContactSheet.setPageFormat(saveMe);
                System.out.println("PageFormat C: " + PrintJobUtils.showPageFormat(ContactSheetPrintOptions.this.myBase.myContactSheet.getPageFormat(0)));
                ContactSheetPrintOptions.this.saveOptions(saveMe);
            }
        });
        JButton previewBtn = new JButton(Jibs.getString("preview"));
        previewBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ContactSheetPrintOptions.this.preview();
            }
        });
        JPanelRows rtnMe = new JPanelRows();
        JPanel row = rtnMe.nextRow();
        row.add(pageBtn);
        row = rtnMe.nextRow(1);
        JButton[] printBtns = this.makePrintBtns();
        row.add(printBtns[0]);
        row.add(printBtns[1]);
        row.add(previewBtn);
        return rtnMe;
    }

    void preview() {
        this.saveOptions();
        JProgressBar bar = this.myBase.myContactSheet.getPreviewProgressBar();
        new PageablePreviewer(this.myBase.myContactSheet, this.makePrintBtns(), bar, false);
    }

    void print() {
        this.saveOptions();
        PageFormat showMe = this.getSavedPageFormat();
        PrintableBase printMe = this.myBase.myContactSheet.makeCopy();
        printMe.setPageFormat(showMe);
        PrintUtils.threadedDefaultPrint(printMe, this.myBase.myFrame);
    }

    PageFormat getSavedPageFormat() {
        PageFormat defaultFormat = this.myBase.myContactSheet.getPageFormat(0);
        Paper p = new Paper();
        p.setImageableArea(this.myBase.myPrefs.getDouble(PRINTABLE_X, defaultFormat.getImageableX()), this.myBase.myPrefs.getDouble(PRINTABLE_Y, defaultFormat.getImageableY()), this.myBase.myPrefs.getDouble(PRINTABLE_WIDTH, defaultFormat.getImageableWidth()), this.myBase.myPrefs.getDouble(PRINTABLE_HEIGHT, defaultFormat.getImageableHeight()));
        p.setSize(this.myBase.myPrefs.getDouble(PAGE_WIDTH, defaultFormat.getWidth()), this.myBase.myPrefs.getDouble(PAGE_HEIGHT, defaultFormat.getHeight()));
        PageFormat rtnMe = new PageFormat();
        rtnMe.setPaper(p);
        rtnMe.setOrientation(this.myBase.myPrefs.getInt(ORIENTATION, 1));
        return rtnMe;
    }

    void saveOptions() {
        this.myBase.iAmSaving = false;
        this.myBase.saveOptions();
    }

    void saveOptions(PageFormat pageFormat) {
        this.saveOptions();
        this.myBase.myPrefs.putDouble(PRINTABLE_X, pageFormat.getImageableX());
        this.myBase.myPrefs.putDouble(PRINTABLE_Y, pageFormat.getImageableY());
        this.myBase.myPrefs.putDouble(PRINTABLE_WIDTH, pageFormat.getImageableWidth());
        this.myBase.myPrefs.putDouble(PRINTABLE_HEIGHT, pageFormat.getImageableHeight());
        this.myBase.myPrefs.putDouble(PAGE_WIDTH, pageFormat.getWidth());
        this.myBase.myPrefs.putDouble(PAGE_HEIGHT, pageFormat.getHeight());
        this.myBase.myPrefs.putInt(ORIENTATION, pageFormat.getOrientation());
        System.out.println("SAVING PageFormat " + PrintJobUtils.showPageFormat(pageFormat));
    }
}

