/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.optimizer.NoDirectories;
import org.gerhardb.lib.io.EzLogger;
import org.gerhardb.lib.io.FileUtil;

public class FileLoopHelper {
    public static final String RELABEL_POSTFIX = "-jibs";
    static final DecimalFormat COUNT_FORMAT = new DecimalFormat("000000");
    JFrame myFrame;
    String myBaseTitle;
    JLabel myLabel;
    JProgressBar myBar;
    EzLogger myLog;
    JFormattedTextField myRelabelFld;
    int myRelabelCount = 0;
    int myMaxValue = 0;

    public FileLoopHelper(JFrame frame, String baseTitle, JFormattedTextField relabelFld, JLabel label, JProgressBar bar, File logFile) throws Exception {
        this.myFrame = frame;
        this.myBaseTitle = baseTitle;
        this.myRelabelFld = relabelFld;
        this.myLabel = label;
        this.myBar = bar;
        this.myBar.setValue(0);
        this.myBar.setMaximum(1);
        this.myBar.setIndeterminate(false);
        this.myLog = new EzLogger(logFile);
        this.myRelabelCount = FileLoopHelper.getIntFromField(this.myRelabelFld, 0);
    }

    public JProgressBar getBarX() {
        return this.myBar;
    }

    public void setValue(int value) {
        this.myBar.setValue(value);
        if (this.myMaxValue > 0) {
            float percent = (int)((float)value / (float)this.myMaxValue * 100.0f);
            String msg = this.myBaseTitle + " " + percent + "%";
            this.myFrame.setTitle(msg);
        } else {
            this.myFrame.setTitle(this.myBaseTitle);
        }
    }

    public void setMaximum(int max) {
        this.myMaxValue = max;
        this.myBar.setMaximum(this.myMaxValue);
    }

    public void setIndeterminate(boolean indeterminate) {
        this.myBar.setIndeterminate(indeterminate);
    }

    public void done() {
        this.myBar.setMaximum(1);
        this.myBar.setValue(1);
        this.myFrame.setTitle(this.myBaseTitle + " " + Jibs.getString("FileLoopHelper.6"));
    }

    public JLabel getLabel() {
        return this.myLabel;
    }

    public EzLogger getLog() {
        return this.myLog;
    }

    public void updateCountField() {
        this.myRelabelFld.setValue(new Integer(this.myRelabelCount));
    }

    public int getRelableCount() {
        return this.myRelabelCount;
    }

    public ArrayList getFilesFromDirectories(File[] dirArray) {
        NoDirectories noDirectories = new NoDirectories();
        ArrayList<File> outList = new ArrayList<File>();
        this.myBar.setMaximum(dirArray.length - 1);
        for (int i = 0; i < dirArray.length; ++i) {
            this.myBar.setValue(i);
            File dir = dirArray[i];
            this.myLabel.setText(Jibs.getString("FileLoopHelper.7") + " " + i + ": " + dir);
            File[] addThese = dir.listFiles(noDirectories);
            if (addThese == null) continue;
            for (int j = 0; j < addThese.length; ++j) {
                outList.add(addThese[j]);
            }
        }
        return outList;
    }

    public static boolean alreadyProcessed(String fileName) {
        return fileName.indexOf(RELABEL_POSTFIX) > -1;
    }

    public File renameUnique(File currFile) {
        String name = currFile.getName();
        if (FileLoopHelper.alreadyProcessed(name)) {
            return currFile;
        }
        String front = "";
        String back = "";
        int lastPeriod = name.lastIndexOf(46);
        if (lastPeriod < 0) {
            front = name;
        } else {
            if (lastPeriod > 0) {
                front = name.substring(0, lastPeriod);
            }
            if (lastPeriod < name.length()) {
                back = name.substring(lastPeriod);
            }
        }
        String newName = currFile.getParent() + File.separator + front + RELABEL_POSTFIX + COUNT_FORMAT.format(this.myRelabelCount++) + back;
        File newFile = new File(newName);
        if (!newFile.exists()) {
            currFile.renameTo(newFile);
            return newFile;
        }
        this.myLog.logLine(Jibs.getString("FileLoopHelper.11") + Jibs.getString("colon") + " " + newFile + "");
        return currFile;
    }

    public static int getIntFromField(JFormattedTextField field, int theDefault) {
        try {
            Object nbr = field.getValue();
            if (nbr instanceof Long) {
                return ((Long)nbr).intValue();
            }
            if (nbr instanceof Integer) {
                return (Integer)nbr;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return theDefault;
    }

    public static JFormattedTextField makeRelabelFld() {
        return new JFormattedTextField(new Integer(0));
    }

    public static boolean checkDirectory(String dir, JButton saveBtn) {
        if (dir == null || dir.trim().length() == 0) {
            return false;
        }
        try {
            FileUtil.validateDirectory(dir.toString());
        }
        catch (FileNotFoundException ex) {
            int create = JOptionPane.showConfirmDialog(saveBtn, dir + " " + Jibs.getString("FileLoopHelper.13"), Jibs.getString("FileLoopHelper.14"), 0);
            if (create == 0) {
                boolean rtnMe = false;
                File file = new File(dir);
                try {
                    rtnMe = file.mkdir();
                }
                catch (Exception exx) {
                    JOptionPane.showMessageDialog(saveBtn, exx.getMessage(), Jibs.getString("FileLoopHelper.15"), 0);
                    return false;
                }
                return rtnMe;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        int value = 100;
        int maxValue = 1000;
        System.out.println(Jibs.getString("FileLoopHelper.16") + " " + value + " " + Jibs.getString("FileLoopHelper.17") + maxValue);
        float amtDone = (float)value / (float)maxValue * 100.0f;
        System.out.println("amtDone  " + amtDone);
        int percent = (int)amtDone;
        String msg = "JIBS " + percent + "%";
        System.out.println(msg);
    }
}

