/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.textPad;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.textPad.TextPad;
import org.gerhardb.lib.dirtree.rdp.StatusBarManager;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.swing.SwingUtils;

public class TextPadOptionsDialog
extends JDialog {
    TextPad myTextPad;
    TreePanel myTreePanel;
    StatusBarManager.AutocopyFilenamePanel myAutocopyFilenamePanel;

    public TextPadOptionsDialog(TextPad owner) {
        super(owner, Jibs.getString("ViewerPreferencesDialog.12"), true);
        this.myTextPad = owner;
        this.myAutocopyFilenamePanel = this.myTextPad.myLST.getStatusBarManager().getAutocopyFilenamePanel();
        JPanel aRow = this.myAutocopyFilenamePanel.nextRow();
        aRow.add(this.myTextPad.getLST().getBasicOptionsManager().getStartupComponent(null));
        aRow.add(this.myTextPad.getLST().getBasicOptionsManager().getSortComponent());
        this.myTextPad.getLST().getBasicOptionsManager().adjustView();
        JTabbedPane jTabbed = new JTabbedPane();
        jTabbed.addTab("Basic", this.myAutocopyFilenamePanel);
        jTabbed.addTab(Jibs.getString("ViewerPreferencesDialog.15"), this.myTextPad.myLST.getPathManager().directoryPanel());
        JPanel thePanel = new JPanel(new BorderLayout());
        thePanel.add((Component)jTabbed, "Center");
        thePanel.add((Component)this.getOkCancelPanel(), "South");
        this.setContentPane(thePanel);
        this.pack();
        this.myTreePanel = new TreePanel();
        jTabbed.addTab(Jibs.getString("ViewerPreferencesDialog.11"), this.myTreePanel);
        SwingUtils.centerOnScreen(this);
        this.setVisible(true);
    }

    private void save() {
        this.myTextPad.myLST.getPathManager().save();
        this.myTextPad.getLST().getBasicOptionsManager().save();
        this.myAutocopyFilenamePanel.save();
        this.myTreePanel.save();
        try {
            TextPad.clsPrefs.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        super.setVisible(false);
        super.dispose();
        this.myTextPad.repaint();
    }

    private void cancel() {
        super.setVisible(false);
        super.dispose();
    }

    private JPanel getOkCancelPanel() {
        JButton btnSave = new JButton(Jibs.getString("save"));
        btnSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextPadOptionsDialog.this.save();
            }
        });
        JButton btnCancel = new JButton(Jibs.getString("cancel"));
        btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextPadOptionsDialog.this.cancel();
            }
        });
        JPanel okPanel = new JPanel();
        okPanel.add(btnSave);
        okPanel.add(btnCancel);
        return okPanel;
    }

    class TreePanel
    extends JPanelRows {
        JCheckBox myCountTextFilesBox = new JCheckBox("Separately count text files in directory tree (results in slower loads and moves)");
        boolean priorCountTarget;

        TreePanel() {
            this.priorCountTarget = TextPadOptionsDialog.this.myTextPad.getCountTargetFiles();
            this.myCountTextFilesBox.setSelected(TextPadOptionsDialog.this.myTextPad.getCountTargetFiles());
            this.myCountTextFilesBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    int picked;
                    if (TreePanel.this.myCountTextFilesBox.isSelected() && !((TreePanel)TreePanel.this).TextPadOptionsDialog.this.myTextPad.getCountTargetFiles() && (picked = JOptionPane.showConfirmDialog(TreePanel.this, "This save will take considerable time\nbecause the directory tree has to\nrecount all the files.", "Note", 2)) == 2) {
                        TreePanel.this.myCountTextFilesBox.setSelected(false);
                    }
                }
            });
            JPanel aRow = super.topRow();
            aRow.add(this.myCountTextFilesBox);
        }

        void save() {
            TextPad.clsPrefs.putBoolean("COUNT_TEXT_FILES", this.myCountTextFilesBox.isSelected());
            try {
                TextPad.clsPrefs.flush();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (this.priorCountTarget != this.myCountTextFilesBox.isSelected()) {
                TextPadOptionsDialog.this.myTextPad.myLST.getTree().setCountTargetFiles(this.myCountTextFilesBox.isSelected());
                TextPadOptionsDialog.this.myTextPad.myLST.getTreeManager().reloadAllNodes();
            }
        }
    }
}

