/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.textCompare;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.gerhardb.jibs.textCompare.TextComparePanel;
import org.gerhardb.lib.io.FileUtil;
import org.gerhardb.lib.swing.JPanelRows;

public class TextFilePanel
extends JPanelRows {
    private TextComparePanel myParent;
    private JTextArea myTextArea = new JTextArea(" ");
    private JLabel myFileName = new JLabel("none");
    private File myFile;
    private JButton myDeleteBtn = new JButton("Delete");

    public TextFilePanel(TextComparePanel parent) {
        this.myParent = parent;
        this.clear();
        this.myDeleteBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextFilePanel.this.myParent.delete(TextFilePanel.this.myFile);
            }
        });
        this.myTextArea.setLineWrap(false);
        this.myTextArea.setWrapStyleWord(true);
        this.myTextArea.setEditable(false);
        this.myTextArea.setRows(5);
        this.myTextArea.setColumns(20);
        JPanel aRow = this.topRow(new BorderLayout());
        aRow.add((Component)new JScrollPane(this.myTextArea), "Center");
        aRow = this.nextRow();
        aRow.add(new JLabel("File: "));
        aRow.add(this.myFileName);
        aRow = this.nextRow(new BorderLayout());
        aRow.add((Component)this.myDeleteBtn, "South");
    }

    JButton getDeleteButton() {
        return this.myDeleteBtn;
    }

    JScrollPane getTextArea() {
        JScrollPane rtnMe = new JScrollPane(this.myTextArea);
        rtnMe.setHorizontalScrollBarPolicy(32);
        rtnMe.setVerticalScrollBarPolicy(22);
        return rtnMe;
    }

    JPanel getFilePanel() {
        JPanel rtnMe = new JPanel(new FlowLayout(0));
        rtnMe.add(new JLabel("File: "));
        rtnMe.add(this.myFileName);
        return rtnMe;
    }

    void setFile(File file) {
        if (file != null && file.exists()) {
            this.myFile = file;
            this.myFileName.setText(this.myFile.getAbsolutePath());
            this.myDeleteBtn.setEnabled(true);
            try {
                String text = FileUtil.getStringFromFile(this.myFile);
                this.myTextArea.setText(text);
                this.myTextArea.setCaretPosition(0);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), this.myFile.getAbsolutePath(), 0);
                ex.printStackTrace();
            }
        }
    }

    void clear() {
        this.myDeleteBtn.setEnabled(false);
        this.myTextArea.setText("");
        this.myFileName.setText("");
    }
}

