/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.textCompare;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.gerhardb.jibs.textCompare.TextComparePanel;
import org.gerhardb.lib.io.DirListController;
import org.gerhardb.lib.swing.SwingUtils;
import org.gerhardb.lib.util.Icons;

public class TextCompareGUI
extends JFrame {
    public static String APP_NAME = "TextCompare";
    private static Preferences clsPrefs = Preferences.userRoot().node("/org/gerhardb/jibs/textCompare");
    boolean iExitOnClose;
    DirListController myWorkingList;

    public TextCompareGUI(boolean exitOnClose) {
        this.iExitOnClose = exitOnClose;
        this.setTitle("Text Compare");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                TextCompareGUI.this.exit();
            }
        });
        this.enableEvents(64L);
        try {
            this.layoutComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("*** Unkonwn abnormal termination ***");
            System.exit(99);
        }
        this.setIconImage(Icons.icon(26).getImage());
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TextCompareGUI.this.validate();
                TextCompareGUI.this.pack();
                SwingUtils.centerOnScreen(TextCompareGUI.this);
                TextCompareGUI.this.setVisible(true);
            }
        });
    }

    private void layoutComponents() throws Exception {
        TextComparePanel clearablePanel = new TextComparePanel(this);
        this.myWorkingList = new DirListController(clearablePanel, "Text Compare", "TextCompare", false, APP_NAME);
        JTabbedPane jTabbed = new JTabbedPane();
        jTabbed.addTab("Directories", this.myWorkingList.getPanel());
        jTabbed.addTab("Compare", new TextComparePanel(this));
        JPanel thePanel = new JPanel(new BorderLayout());
        thePanel.add((Component)jTabbed, "Center");
        this.setContentPane(new JScrollPane(thePanel));
    }

    private void exit() {
        try {
            clsPrefs.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.iExitOnClose) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public static void main(String[] args) {
        new TextCompareGUI(true);
    }
}

