/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.dirtools;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.dirtools.DirCopyPanel;
import org.gerhardb.lib.io.EzLogger;
import org.gerhardb.lib.io.FileUtil;
import org.gerhardb.lib.io.TargetFileExistsException;

public class WorkerCopy
implements Runnable {
    static final SimpleDateFormat LONG_DATE = new SimpleDateFormat("yyyy.MMMMM.dd HH:mm:ss");
    static final String FAILED = "FAILED\t";
    static final String SKIPPED = "SKIPPED\t";
    static final String SUCCEEDED = "SUCCEEDED\t";
    static final String ABORTED = "==> ABORTED <==";
    boolean iStop;
    DirCopyPanel myPanel;
    File myToDir;
    EzLogger myLog;
    File[] myExcludeDirectories;
    File[] myIncludeDirectories;

    public WorkerCopy(DirCopyPanel panel, String to) throws Exception {
        this.myPanel = panel;
        this.myToDir = new File(to);
        this.myExcludeDirectories = this.myPanel.myDirTools.myExcludeList.getDirArray();
        this.myIncludeDirectories = this.myPanel.myDirTools.myIncludeList.getDirArray();
        this.myLog = new EzLogger(this.myPanel.myLogFile);
        this.myLog.logLine("Copy To: " + this.myToDir);
    }

    void stop() {
        this.iStop = true;
    }

    public void run() {
        this.iStop = false;
        Date startDate = new Date();
        this.myLog.logLine("Started" + Jibs.getString("colon") + " " + LONG_DATE.format(startDate) + "");
        this.myLog.logLine("===========================================================================================");
        this.myPanel.myCurrentAction.setText("Started");
        for (int i = 0; i < this.myIncludeDirectories.length; ++i) {
            this.myLog.logLine("===========================================================================================");
            this.myLog.logLine("Copy From: " + this.myIncludeDirectories[i]);
            String newDirName = this.myToDir.getAbsolutePath() + "/" + WorkerCopy.getFinalDirFromPath(this.myIncludeDirectories[i]);
            File newToDir = new File(newDirName);
            if (!this.makeSureDirectoryIsThere(newToDir)) continue;
            try {
                this.processDirectory(this.myIncludeDirectories[i], newToDir);
                continue;
            }
            catch (Exception ex) {
                this.myLog.logLine("FAILED\tCould not PROCESS directory: " + this.myIncludeDirectories[i] + "    BECAUSE: " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        this.myLog.logLine("===========================================================================================");
        Date stopDate = new Date();
        this.myLog.logLine("Completed" + Jibs.getString("colon") + " " + LONG_DATE.format(stopDate) + "");
        this.myPanel.myCurrentAction.setText("Stopped");
        try {
            this.myLog.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void processDirectory(File fromDir, File toDir) {
        if (this.iStop) {
            this.myLog.logLine(ABORTED);
            return;
        }
        if (fromDir == null || !fromDir.isDirectory()) {
            this.myLog.logLine("FAILED\tNull or not a directory: " + fromDir);
            return;
        }
        this.myPanel.myCurrentAction.setText(fromDir.getAbsolutePath());
        File[] fromFiles = null;
        try {
            fromFiles = fromDir.listFiles();
        }
        catch (Exception ex) {
            this.myLog.logLine("FAILED\tCould not LOOK UP files in: " + fromDir);
        }
        if (fromFiles == null) {
            this.myLog.logLine("FAILED\tCould not LOOK UP files in: " + fromDir);
            return;
        }
        for (int i = 0; i < fromFiles.length; ++i) {
            if (this.iStop) {
                this.myLog.logLine(ABORTED);
                return;
            }
            if (fromFiles[i].isDirectory()) {
                String newDirName;
                File newToDir;
                boolean processDirectory = true;
                for (int j = 0; j < this.myExcludeDirectories.length; ++j) {
                    if (!fromFiles[i].equals(this.myExcludeDirectories[j])) continue;
                    this.myLog.logLine("EXCLUDED: " + fromFiles[i]);
                    processDirectory = false;
                }
                if (!processDirectory || !this.makeSureDirectoryIsThere(newToDir = new File(newDirName = toDir.getAbsolutePath() + "/" + WorkerCopy.getFinalDirFromPath(fromFiles[i])))) continue;
                try {
                    this.processDirectory(fromFiles[i], newToDir);
                }
                catch (Exception ex) {
                    this.myLog.logLine("FAILED\tCould not PROCESS directory: " + fromFiles[i] + "    BECAUSE: " + ex.getMessage());
                    ex.printStackTrace();
                }
                continue;
            }
            if (!fromFiles[i].isFile()) continue;
            try {
                if (fromFiles[i].length() > 0L) {
                    FileUtil.copyFileToDir(toDir, fromFiles[i]);
                    this.myLog.logLine(SUCCEEDED + fromFiles[i]);
                    continue;
                }
                this.myLog.logLine("ZERO LENGTH SKIPPED\t" + fromFiles[i]);
                continue;
            }
            catch (TargetFileExistsException ex) {
                this.myLog.logLine(SKIPPED + fromFiles[i]);
                continue;
            }
            catch (Exception ex) {
                this.myLog.logLine(FAILED + fromFiles[i]);
            }
        }
    }

    public static String getFinalDirFromPath(File dir) {
        int length = 0;
        File parent = dir.getParentFile();
        if (parent != null) {
            String parentPath = parent.getAbsolutePath();
            length = parentPath.endsWith("/") || parentPath.endsWith("\\") ? parentPath.length() : parentPath.length() + 1;
            String rtnMe = dir.getAbsolutePath().substring(length);
            return rtnMe;
        }
        String rtnMe = dir.getAbsolutePath().substring(0, 1);
        if (rtnMe.endsWith("/")) {
            rtnMe = "root";
        }
        return "drive_" + rtnMe;
    }

    private boolean makeSureDirectoryIsThere(File newDir) {
        try {
            if (newDir.exists()) {
                this.myLog.logLine("SKIPPED\tFound directory: " + newDir.getAbsolutePath());
            } else {
                newDir.mkdir();
                this.myLog.logLine("SUCCEEDED\tCreated directory: " + newDir.getAbsolutePath());
            }
            return true;
        }
        catch (Exception ex) {
            this.myLog.logLine("FAILED\tCould not create directory: " + newDir);
            return false;
        }
    }

    public static void main(String[] args) {
        System.out.println(WorkerCopy.getFinalDirFromPath(new File("/")));
        System.out.println(WorkerCopy.getFinalDirFromPath(new File("D:")));
        System.out.println(WorkerCopy.getFinalDirFromPath(new File("D:\\")));
        System.out.println(WorkerCopy.getFinalDirFromPath(new File("D:\\foo")));
        System.out.println(WorkerCopy.getFinalDirFromPath(new File("D:\\foo\\bar")));
    }
}

