/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.concatenater;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.concatenater.ThreadedConcatenater;
import org.gerhardb.lib.io.DirectoriesOnlyFileFilter;
import org.gerhardb.lib.io.DragDropList;
import org.gerhardb.lib.swing.JFileChooserExtra;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.swing.SwingUtils;
import org.gerhardb.lib.util.Icons;
import org.gerhardb.lib.util.StopCheckButton;

public class Concatenater
extends JFrame {
    public static String APP_NAME = "Concatenate";
    private static final String LAST_DIR = "ConcatFrame.LastDir";
    private static final Preferences clsPrefs = Preferences.userRoot().node("/org/gerhardb/app/imgbrowse/ConcatFrame");
    JTextField myFileName = new JTextField(60);
    DefaultListModel myFiles = new DefaultListModel();
    JList myFileList = new DragDropList(this.myFiles, true);
    StopCheckButton myStopCheckBtn;
    DefaultBoundedRangeModel myRange = new DefaultBoundedRangeModel();
    JProgressBar myBar = new JProgressBar(this.myRange);

    public Concatenater(boolean iExitOnClose) {
        super(Jibs.getString("Concatenater.3"));
        this.myStopCheckBtn = new StopCheckButton();
        if (iExitOnClose) {
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    System.exit(0);
                }
            });
        }
        this.layoutComponents();
        this.setIconImage(Icons.icon(26).getImage());
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Concatenater.this.pack();
                Concatenater.this.setVisible(true);
                SwingUtils.centerOnScreen(Concatenater.this);
            }
        });
    }

    private void layoutComponents() {
        this.setSize(new Dimension(600, 600));
        JButton addBtn = new JButton(Jibs.getString("Concatenater.4"));
        addBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Concatenater.this.myRange.setValue(0);
                Concatenater.this.myBar.setStringPainted(false);
                Concatenater.this.addFiles();
            }
        });
        JButton doBtn = new JButton(Jibs.getString("Concatenater.5"));
        doBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Concatenater.this.concat();
            }
        });
        JButton clearBtn = new JButton(Jibs.getString("Concatenater.6"));
        clearBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Concatenater.this.myRange.setValue(0);
                Concatenater.this.myBar.setStringPainted(false);
                Concatenater.this.myFiles.clear();
                Concatenater.this.myFileName.setText("");
            }
        });
        JButton btnToDirectory = new JButton("...");
        btnToDirectory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                File currFile = new File(Concatenater.this.myFileName.getText());
                String LAST = "lastDir";
                String lastDirectory = clsPrefs.get("lastDir", null);
                if (lastDirectory == null) {
                    lastDirectory = System.getProperty("user.home");
                }
                if ((lastDirectory = DirectoriesOnlyFileFilter.lookupDir("Joined file directory", lastDirectory, Concatenater.this)) != null) {
                    clsPrefs.put("lastDir", lastDirectory);
                    Concatenater.this.myFileName.setText(lastDirectory + File.separator + currFile.getName());
                }
            }
        });
        JPanelRows topPanel = new JPanelRows(1);
        JPanel row = topPanel.topRow();
        row.add(new JLabel(Jibs.getString("Concatenater.8")));
        row = topPanel.nextRow();
        row.add(new JLabel(Jibs.getString("Concatenater.11")));
        JPanelRows bottomPanel = new JPanelRows();
        row = bottomPanel.topRow(1);
        row.add(addBtn);
        row.add(clearBtn);
        row = bottomPanel.nextRow();
        row.add(new JLabel(Jibs.getString("Concatenater.13") + Jibs.getString("colon") + " "));
        row.add(this.myFileName);
        row.add(btnToDirectory);
        row = bottomPanel.nextRow(1);
        row.add(doBtn);
        row.add(this.myStopCheckBtn.getStopButton());
        row = bottomPanel.nextRow(1);
        Dimension dim = this.myBar.getPreferredSize();
        dim.width = 500;
        this.myBar.setPreferredSize(dim);
        row.add(this.myBar);
        JScrollPane middle = new JScrollPane(this.myFileList);
        JPanel thePanel = new JPanel(new BorderLayout());
        thePanel.add((Component)topPanel, "North");
        thePanel.add((Component)middle, "Center");
        thePanel.add((Component)bottomPanel, "South");
        this.setContentPane(new JScrollPane(thePanel));
    }

    void addFiles() {
        String lastDir = clsPrefs.get(LAST_DIR, null);
        JFileChooserExtra chooser = new JFileChooserExtra(lastDir);
        chooser.setSaveName(APP_NAME, Jibs.getString("Concatenater.14"));
        chooser.setDialogTitle(Jibs.getString("Concatenater.15"));
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(true);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            File[] picked = chooser.getSelectedFiles();
            if (picked[0] != null) {
                this.myFileName.setText(picked[0].toString());
            }
            try {
                clsPrefs.put(LAST_DIR, chooser.getCurrentDirectory().toString());
                clsPrefs.flush();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            for (int i = 0; i < picked.length; ++i) {
                this.myFiles.addElement(picked[i]);
            }
        }
    }

    void concat() {
        Object[] obj = this.myFiles.toArray();
        File[] files = new File[obj.length];
        for (int i = 0; i < obj.length; ++i) {
            files[i] = new File(obj[i].toString());
        }
        ThreadedConcatenater tc = new ThreadedConcatenater(new File(this.myFileName.getText()), files, this, this.myStopCheckBtn, this.myRange, this.myBar, true);
        new Thread(tc).start();
    }

    public static void main(String[] args) {
        new Concatenater(true);
    }
}

