/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.concatenater;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.concatenater.ThreadedConcatenater;
import org.gerhardb.lib.io.FileNameComparatorInsensative;
import org.gerhardb.lib.swing.JFileChooserExtra;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.swing.SwingUtils;
import org.gerhardb.lib.util.Icons;
import org.gerhardb.lib.util.StopCheckButton;

public class AutoConcatenate
extends JFrame {
    public static String APP_NAME = "AutoConcatenate";
    private static final String LAST_DIR = "LastDir";
    private static final String READY = "Ready";
    private static final Preferences clsPrefs = Preferences.userRoot().node("/org/gerhardb/jibs/concatenater/auto");
    JTextField myRootDir = new JTextField(60);
    DefaultBoundedRangeModel myRange = new DefaultBoundedRangeModel();
    JProgressBar myBar = new JProgressBar(this.myRange);
    StopCheckButton myStopCheckBtn = new StopCheckButton();

    public AutoConcatenate(boolean iExitOnClose) {
        super("Auto Joiner");
        this.layoutComponents();
        this.myRootDir.setText(clsPrefs.get(LAST_DIR, null));
        this.setIconImage(Icons.icon(26).getImage());
        if (iExitOnClose) {
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    System.exit(0);
                }
            });
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                AutoConcatenate.this.pack();
                SwingUtils.centerOnScreen(AutoConcatenate.this);
                AutoConcatenate.this.setVisible(true);
            }
        });
    }

    private void layoutComponents() {
        this.myBar.setStringPainted(true);
        this.myBar.setString(READY);
        this.setSize(new Dimension(600, 600));
        JButton goBtn = new JButton("Auto Join");
        goBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoConcatenate.this.go();
            }
        });
        JButton rootBtn = new JButton("...");
        rootBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AutoConcatenate.this.selectRoot();
            }
        });
        JPanelRows topPanel = new JPanelRows(1);
        JPanel aRow = topPanel.topRow();
        aRow.add(new JLabel("Automatically joins files in a sequence like foo.mpg.001, foo.mpg.002 to foo.mpg"));
        aRow = topPanel.nextRow();
        aRow.add(new JLabel(" "));
        aRow = topPanel.nextRow();
        aRow.add(new JLabel("Select the diretory containing the files to be joined."));
        aRow = topPanel.nextRow();
        aRow.add(new JLabel("Directory" + Jibs.getString("colon") + " "));
        aRow.add(this.myRootDir);
        aRow.add(rootBtn);
        aRow = topPanel.nextRow();
        aRow.add(goBtn);
        aRow.add(this.myStopCheckBtn.getStopButton());
        aRow = topPanel.nextRow(new BorderLayout());
        aRow.add((Component)this.myBar, "Center");
        this.setContentPane(topPanel);
    }

    void selectRoot() {
        File picked;
        this.myBar.setString(READY);
        JFileChooserExtra chooser = new JFileChooserExtra(clsPrefs.get(LAST_DIR, null));
        chooser.setSaveName(APP_NAME, Jibs.getString("RecreateDirectories.21"));
        chooser.setApproveButtonText(Jibs.getString("RecreateDirectories.22"));
        chooser.setDialogTitle("Directory to scan for auto-join");
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0 && (picked = chooser.getSelectedFile()) != null) {
            this.myRootDir.setText(picked.toString());
            try {
                clsPrefs.put(LAST_DIR, picked.toString());
                clsPrefs.flush();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    void go() {
        String rootString = this.myRootDir.getText();
        File rootFile = new File(rootString);
        if (!rootFile.exists()) {
            JOptionPane.showMessageDialog(this, "Directory does not exist: " + rootString, "Problem with Diretory", 0);
            return;
        }
        if (this.myStopCheckBtn.isStopped()) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            ConcatAll ca = new ConcatAll(rootFile);
            new Thread(ca).start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, ex.getMessage(), Jibs.getString("Auto-Joiner"), 0);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public static void main(String[] args) {
        new AutoConcatenate(true);
    }

    private class ConcatAll
    implements Runnable {
        String fileName = null;
        String newFileName = null;
        ArrayList list = null;
        File myCARootDir;

        ConcatAll(File rootDir) {
            this.myCARootDir = rootDir;
        }

        public void run() {
            boolean needToFinish = false;
            System.out.println("Root Dir is: " + this.myCARootDir);
            File[] files = this.myCARootDir.listFiles();
            Arrays.sort(files, new FileNameComparatorInsensative());
            for (int i = 0; i < files.length; ++i) {
                if (AutoConcatenate.this.myStopCheckBtn.isStopped()) {
                    return;
                }
                this.fileName = files[i].getName();
                System.out.println(files[i]);
                if (this.fileName.endsWith(".01") || this.fileName.endsWith(".001") || this.fileName.endsWith(".0001")) {
                    this.start();
                    needToFinish = true;
                }
                if (this.list == null) continue;
                if (this.fileToAdd()) {
                    this.list.add(files[i]);
                    continue;
                }
                this.finish();
                needToFinish = false;
            }
            if (needToFinish) {
                this.finish();
            }
            AutoConcatenate.this.myBar.setString("Done");
            System.out.println("ALL DONE!!!");
        }

        private void start() {
            System.out.println("STARTING");
            if (this.list != null) {
                this.finish();
            }
            this.newFileName = this.fileName.substring(0, this.fileName.lastIndexOf("."));
            File saveTo = null;
            saveTo = new File(this.myCARootDir + File.separator + this.newFileName);
            if (!saveTo.exists()) {
                System.out.println("=====> PROCESSING: " + saveTo);
                this.list = new ArrayList(100);
            } else {
                System.out.println("=====> SKIPPING: " + saveTo);
            }
        }

        private boolean fileToAdd() {
            if (this.fileName.startsWith(this.newFileName)) {
                StringTokenizer st = new StringTokenizer(this.fileName, ".");
                String lastToken = st.nextToken();
                while (st.hasMoreTokens()) {
                    lastToken = st.nextToken();
                }
                try {
                    Integer.parseInt(lastToken);
                    System.out.println("Adding: " + this.fileName);
                    return true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            System.out.println("Not Adding: " + this.fileName);
            return false;
        }

        private void finish() {
            System.out.println("FINISHING");
            File[] files = new File[this.list.size()];
            files = this.list.toArray(files);
            this.list = null;
            AutoConcatenate.this.myBar.setStringPainted(false);
            File saveTo = new File(this.myCARootDir + File.separator + this.newFileName);
            System.out.println("SAVING TO: " + saveTo);
            ThreadedConcatenater tc = new ThreadedConcatenater(saveTo, files, AutoConcatenate.this, AutoConcatenate.this.myStopCheckBtn, AutoConcatenate.this.myRange, AutoConcatenate.this.myBar, false);
            tc.run();
        }
    }
}

