/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.camera;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.camera.CameraPreferences;
import org.gerhardb.jibs.util.FileLoopHelper;
import org.gerhardb.lib.image.ImageUtilDrew;

public class WorkerCamera
implements Runnable {
    public static final String FILE_DATE_FORMAT = "yyyy.MM.dd-HH.mm.ss";
    public static final SimpleDateFormat FILE_DATE = new SimpleDateFormat("yyyy.MM.dd-HH.mm.ss");
    public static final SimpleDateFormat LONG_DATE = new SimpleDateFormat("yyyy.MMMMM.dd HH:mm:ss");
    File[] myDirectories;
    FileLoopHelper myHelper = null;
    File[] myFiles;
    boolean iStop;
    int myRelabelCount = CameraPreferences.getRelabelNumber();
    boolean iRenameUnique;
    boolean iRenameEXIF;

    public WorkerCamera(File[] directories, boolean rename, boolean exif, FileLoopHelper helper) throws Exception {
        this.myDirectories = directories;
        this.myHelper = helper;
        this.myHelper.setValue(0);
        this.myHelper.setMaximum(1);
        this.myHelper.setIndeterminate(false);
        this.myHelper.getLog().logLine(Jibs.getString("WorkerCamera.4") + Jibs.getString("colon") + " ");
        for (int i = 0; i < this.myDirectories.length; ++i) {
            this.myHelper.getLog().logLine("   " + this.myDirectories[i].getAbsolutePath() + "");
        }
        this.iRenameUnique = rename;
        this.iRenameEXIF = exif;
        this.myHelper.getLog().logLine(Jibs.getString("WorkerCamera.7") + Jibs.getString("colon") + " ");
        this.myHelper.getLog().logLine("   " + Jibs.getString("WorkerCamera.8") + Jibs.getString("colon") + " " + this.iRenameUnique + "");
        if (this.iRenameUnique) {
            this.myHelper.getLog().logLine("      " + Jibs.getString("WorkerCamera.10") + Jibs.getString("colon") + " " + "-jibs" + "");
            this.myHelper.getLog().logLine("");
            this.myHelper.getLog().logLine("      " + Jibs.getString("WorkerCamera.13") + Jibs.getString("colon") + " " + this.myRelabelCount + "");
        }
        this.myHelper.getLog().logLine("   " + Jibs.getString("WorkerCamera.3") + Jibs.getString("colon") + " " + this.iRenameEXIF + "");
        this.myHelper.getLog().logLine("===========================================================================================");
    }

    void stop() {
        this.iStop = true;
    }

    public void run() {
        this.iStop = false;
        this.myHelper.getLog().logLine("===========================================================================================");
        Date startDate = new Date();
        this.myHelper.getLog().logLine(Jibs.getString("WorkerCamera.2") + Jibs.getString("colon") + " " + LONG_DATE.format(startDate) + "");
        if (this.continueRun()) {
            this.myHelper.getLabel().setText(Jibs.getString("WorkerCamera.1"));
            ArrayList outList = this.myHelper.getFilesFromDirectories(this.myDirectories);
            this.myFiles = outList.toArray(new File[outList.size()]);
            this.myHelper.getLog().logLine("===========================================================================================");
            this.myHelper.getLog().logLine(Jibs.getString("WorkerCamera.0") + Jibs.getString("colon") + " " + this.myFiles.length + "");
            this.myHelper.setValue(0);
            this.myHelper.setMaximum(this.myFiles.length - 1);
            for (int i = 0; i < this.myFiles.length && !this.iStop; ++i) {
                this.myHelper.setValue(i);
                int count = i + 1;
                String progress = Jibs.getString("WorkerCamera.37") + " " + count + " " + Jibs.getString("WorkerCamera.38") + " " + this.myFiles.length;
                this.myHelper.getLabel().setText(progress);
                if (this.myFiles[i] == null) continue;
                this.processIndex(i);
                this.myFiles[i] = null;
            }
            this.myHelper.getLog().logLine("===========================================================================================");
            this.myHelper.getLog().logLine(Jibs.getString("WorkerCamera.39") + " " + this.myFiles.length + " " + Jibs.getString("WorkerCamera.40"));
        }
        Date stopDate = new Date();
        this.myHelper.getLog().logLine(Jibs.getString("WorkerCamera.41") + Jibs.getString("colon") + " " + LONG_DATE.format(stopDate) + "");
        long seconds = (stopDate.getTime() - startDate.getTime()) / 1000L;
        this.myHelper.getLog().logLine(Jibs.getString("WorkerCamera.42") + Jibs.getString("colon") + " " + seconds + "");
        this.myHelper.getLabel().setText(Jibs.getString("WorkerCamera.30"));
        try {
            this.myHelper.getLog().close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.myHelper.updateCountField();
        try {
            CameraPreferences.setRelabelNumber(this.myHelper.getRelableCount());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.myHelper.done();
    }

    boolean continueRun() {
        return this.iRenameUnique || this.iRenameEXIF;
    }

    void processIndex(int index) {
        File oldName;
        if (this.myFiles[index] == null) {
            return;
        }
        File newName = oldName = this.myFiles[index];
        if (this.iRenameEXIF) {
            newName = this.renameExif(oldName);
        }
        if (this.iRenameUnique) {
            newName = this.myHelper.renameUnique(newName);
        }
        if (!oldName.equals(newName)) {
            this.myHelper.getLog().logLine("   " + Jibs.getString("WorkerCamera.31") + Jibs.getString("colon") + " " + oldName.getAbsolutePath() + "      " + Jibs.getString("WorkerCamera.32") + Jibs.getString("colon") + " " + newName.getAbsolutePath() + "");
        }
    }

    private File renameExif(File currFile) {
        try {
            String newName;
            File newFile;
            ImageUtilDrew drew = new ImageUtilDrew(currFile);
            Date picDate = drew.getPicDate();
            if (picDate != null && !(newFile = new File(newName = currFile.getParent() + File.separator + FILE_DATE.format(picDate) + ".jpg")).equals(currFile)) {
                currFile.renameTo(newFile);
                return newFile;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return currFile;
    }
}

