/*
 * Created on 13.09.2006
 */
package de.ssfuture.tools.updater;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;

/**
 * @author Sebastian Schleemilch
 */
public class Pack {
	String packdir;
	LoggingInterface log;
	
	/**
	 * @param targetjar
	 * @param mainclass
	 * @param compression
	 * @throws FileNotFoundException
	 * @throws IOException
	 * compession: 0-9, -1 =  DEFAULT_COMPRESSION;
	 */
	public Pack(String targetjar, String mainclass, int compression, LoggingInterface logging) 
		throws FileNotFoundException, IOException {
		log = logging;
		File dir = new File(System.getProperty("user.home"), "ssfupdater/");
		if(! dir.exists()) {
			throw new IOException("Error: " + dir.getPath() + " doest exist. Cant pack anything.");
		}
		packdir = dir.getPath();
		log.defaultLog( "Working dir:" + packdir );
		
		File metainf = new File(packdir, "META-INF");
		metainf.mkdir();
		
		FileOutputStream fos = new FileOutputStream(new File(metainf, "MANIFEST.MF"));
		fos.write(("Main-Class: " + mainclass + "\nCreated-By: Compressed with SSfuture Update Pack\n\n").getBytes());
		fos.close();
		
		JarOutputStream jos = new JarOutputStream(
				new FileOutputStream(targetjar));
		if(compression != -1)
			jos.setLevel(compression);
		addEntries(dir, jos);
		jos.flush();
		jos.close();
		
		// Make Adler32 checksum
		log.defaultLog("Checksum: ");
		FileInputStream in = new FileInputStream(targetjar);
		Adler32 adler = new Adler32();
		CheckedInputStream cis = new CheckedInputStream(in, adler);
		while(cis.read() != -1)
			;
		in.close();
		String checksum = Long.toHexString(adler.getValue());
		System.out.println(checksum);
		FileOutputStream checksum_fos = new FileOutputStream(targetjar + ".a32");
		checksum_fos.write(checksum.getBytes());
		checksum_fos.close();
	}

	private void addEntries(File dir, JarOutputStream jos) throws IOException {
		File[] list = dir.listFiles();
		for(int i = 0; i < list.length; i++) {
			if(list[i].isDirectory())
				addEntries(list[i], jos);
			else {
				String filename = list[i].toString();
				// Remove absolute dir and prestanding '\' or '/'
				filename = filename.substring(packdir.length() + 1);
				filename = filename.replace("\\", "/");
				log.defaultLog("Add: " + filename);
				ZipEntry entry = new ZipEntry(filename);
				jos.putNextEntry(entry);
				
				InputStream ins = new FileInputStream(list[i]);
				BufferedInputStream bis = new BufferedInputStream(ins);
				BufferedOutputStream bos = new BufferedOutputStream(jos);
				
				for(int d ; (d = bis.read()) != -1; )
					bos.write( (byte)d );
				
				bos.flush();
				jos.closeEntry();
			}
		}
	}
	
	public static void main(String[] args) {
		try {
			Pack p = new Pack("out.jar", "hero.class", -1, new DefaultConsoleLogging());
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
