/*
 * Created on 15.09.2006
 */
package de.ssfuture.tools.jfonttools.comparison;

import java.awt.Color;
import java.awt.Font;

import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;

import de.ssfuture.tools.jfonttools.WindowPositionTools;

/**
 * @author Sebastian Schleemilch
 */
public class FontWindow extends JFrame {
	JEditorPane preview = new JEditorPane();
	
	public FontWindow(Font[] fonts, Color bg, Color fg, float size, int style, String text) {
		super("Font comparison");
		preview.setEditable(false);
		preview.setContentType("text/html");
		
		String htmlcode = "<html>" +
				"<body bgcolor=\"#" + Integer.toHexString(bg.getRGB()) +
				"\">";
		for(int i = 0; i < fonts.length; i++) {
			if(i != 0)
				htmlcode += "<br><hr><br>";
			htmlcode += "<blockquote><h3><i><b>" + fonts[i].getName() + 
			"</b></i></h3></blockquote><br>";
			htmlcode += "<h1><font face=\"" + fonts[i].getName() + 
			"\" color=\"#" + Integer.toHexString(fg.getRGB()) + "\">" + 
			text + "</font></h1>";
		}
		htmlcode += "</body></html>";
		preview.setText(htmlcode);
		
		WindowPositionTools.center_left(this);
		getContentPane().add(new JScrollPane(preview), "Center");
		
		setVisible(true);	
	}

}
