/*
 * Created on 14.09.2006
 */
package de.ssfuture.tools.jfonttools;

import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URLEncoder;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

/**
 * @author Sebastian Schleemilch
 */
public class ReportBugDialog extends JDialog implements ActionListener {
	JTextArea report = new JTextArea();
	JButton send_btn = new JButton("Send report");
	JButton copyToMemory_btn = new JButton("Copy to memory");
	
	public ReportBugDialog(Frame parent) {
		super(parent, "Report a bug", true);
		getContentPane().add(new JScrollPane(report), "Center");
		report.setText("Just write a short report like this one: \n\n" +
				"My name is ___ and I like to report a bug in your software.\n" +
				"I found the bug on the ___ modul, exactly ____\n" +
				"\nThank you for your work!\nSincerely,\n\n" +
				"___");
		WindowPositionTools.middle(this);
		JPanel buttonpanel = new JPanel(new FlowLayout(FlowLayout.RIGHT));
		buttonpanel.add(copyToMemory_btn);
		copyToMemory_btn.addActionListener(this);
		buttonpanel.add(send_btn);
		send_btn.addActionListener(this);
		getContentPane().add(buttonpanel, "South");
		
		setVisible(true);
	}
	
	public void actionPerformed(ActionEvent e) {
		Object src = e.getSource();
		if(src.equals(send_btn)) {
			if(sendEmail("schleemilch@gmail.com", "JFontTools Bug Report", 
					report.getText() + "\n\nSoftware Version: " + JFontTools.serialVersionUID))
				JOptionPane.showMessageDialog(this, 
						"<html><h1>Thank you!</h1></html>", 
						"Thank you!", JOptionPane.PLAIN_MESSAGE);
			else
				JOptionPane.showMessageDialog(this, 
						"<html>" +
						"<h1>Error!</h1><br>Sorry - currently the send function only works on Windows systems.<br>" +
						"Please use the <br>Copy to memory</b> Button and send me the content via Email with subject 'JFontTools Bug Report' to:<br>" +
						"schleemilch@gmail.com<br>" +
						"<h3>Thank you for reporting a bug!</h3>" +
						"</html>", 
						"Error", JOptionPane.ERROR_MESSAGE);
		}
		else if(src.equals(copyToMemory_btn)) {
			Clipboard clipb = Toolkit.getDefaultToolkit().getSystemClipboard();
			clipb.setContents(new StringSelection( 
					report.getText() + "\n\nSoftware Version: " + JFontTools.serialVersionUID ), null);
			JOptionPane.showMessageDialog(this, "DONE");
		}
	}
	
	public boolean sendEmail(String emailTo, String subject, String body) {
		String subj = URLEncoder.encode(subject);
		String bodyVal = URLEncoder.encode(body);
		try {
			Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler mailto:"
					+ emailTo + "?subject=" + subject
					+"&body=" + body);
		} catch (IOException e) {
			e.printStackTrace();
			return false;
		}
		return true;
	}

}
