/*
 * Decompiled with CFR 0.152.
 */
package shared.dialog;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SpringLayout;
import shared.aa.JAALabel;
import shared.progbar.JProgBar;
import shared.proglistener.ProgListener;
import shared.proglistener.ProgNotify;

public class JWaitDialog
extends JDialog
implements ProgListener {
    private JAALabel m_label;
    private JProgBar m_bar;
    private JFrame m_frame;
    private String m_cancelStr;
    private boolean m_bCancel = false;
    private int m_width = 450;
    private String m_labelText;
    private int m_min = 0;
    private int m_max = 1000;
    private boolean m_bIndeterminate;

    public JWaitDialog(JFrame jFrame, String string, String string2) {
        super(jFrame, string, true);
        this.m_frame = jFrame;
        this.m_cancelStr = string2;
    }

    public JWaitDialog(JFrame jFrame, String string) {
        super(jFrame, string, false);
        this.m_frame = jFrame;
        this.m_cancelStr = null;
    }

    public JWaitDialog(JFrame jFrame, String string, int n) {
        super(jFrame, string, false);
        this.m_frame = jFrame;
        this.m_cancelStr = null;
        this.m_width = n;
    }

    public JWaitDialog(JFrame jFrame, String string, String string2, int n) {
        super(jFrame, string, false);
        this.m_frame = jFrame;
        this.m_cancelStr = null;
        this.m_width = n;
    }

    public void setIndeterminate(boolean bl) {
        this.m_bIndeterminate = bl;
    }

    public boolean wasCancelled() {
        return this.m_bCancel;
    }

    protected void doInit() {
        this.setDefaultCloseOperation(0);
        Container container = this.getContentPane();
        SpringLayout springLayout = new SpringLayout();
        container.setLayout(springLayout);
        this.m_label = new JAALabel(this.m_labelText);
        container.add(this.m_label);
        springLayout.putConstraint("West", (Component)this.m_label, 10, "West", (Component)container);
        springLayout.putConstraint("North", (Component)this.m_label, 10, "North", (Component)container);
        this.m_bar = new JProgBar(this.m_min, this.m_max);
        this.m_bar.setIndeterminate(this.m_bIndeterminate);
        container.add(this.m_bar);
        springLayout.putConstraint("West", (Component)this.m_bar, 0, "West", (Component)this.m_label);
        springLayout.putConstraint("South", (Component)this.m_bar, 30, "North", (Component)this.m_bar);
        springLayout.putConstraint("East", (Component)this.m_bar, -10, "East", (Component)container);
        springLayout.putConstraint("North", (Component)this.m_bar, 5, "South", (Component)this.m_label);
        if (this.m_cancelStr != null) {
            JButton jButton = new JButton(this.m_cancelStr);
            container.add(jButton);
            springLayout.putConstraint("HorizontalCenter", (Component)jButton, 0, "HorizontalCenter", (Component)container);
            springLayout.putConstraint("South", (Component)jButton, -10, "South", (Component)container);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JWaitDialog.this.m_bCancel = true;
                    JWaitDialog.this.stop();
                }
            });
        }
        this.pack();
        this.setSize(this.m_width, this.m_cancelStr != null ? 130 : 100);
        this.setResizable(false);
        this.setLocationRelativeTo(this.m_frame);
    }

    public void setRange(int n, int n2) {
        this.m_min = n;
        this.m_max = n2;
    }

    public void getRangeMin() {
    }

    public int getRangeMax() {
        return this.m_max;
    }

    public boolean start() {
        this.doInit();
        this.setVisible(true);
        return !this.m_bCancel;
    }

    public boolean stop() {
        this.setVisible(false);
        this.dispose();
        return !this.m_bCancel;
    }

    public void setLabel(String string) {
        this.m_labelText = string;
        if (this.m_label != null) {
            this.m_label.setText(string);
        }
    }

    public boolean notify(ProgNotify progNotify) {
        this.m_bar.setValue(progNotify.getProgress());
        this.m_bar.setString(progNotify.getMessage());
        return this.m_bCancel;
    }
}

