/*
 * Decompiled with CFR 0.152.
 */
package shared.checklist;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.UIManager;
import shared.checklist.JCheckListData;

final class JCheckListListener
extends MouseAdapter
implements KeyListener {
    protected JList m_list;
    protected int m_checkBoxWidth = 0;

    protected void doToggleCheck() {
        int n = this.m_list.getSelectedIndex();
        if (n >= 0) {
            Object e = this.m_list.getModel().getElementAt(n);
            assert (e instanceof JCheckListData);
            if (e instanceof JCheckListData) {
                JCheckListData jCheckListData;
                jCheckListData.setChecked(!(jCheckListData = (JCheckListData)e).isChecked());
                this.m_list.repaint();
            }
        }
    }

    public JCheckListListener(JList jList) {
        this.m_list = jList;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == ' ') {
            this.doToggleCheck();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.m_checkBoxWidth == 0) {
            this.m_checkBoxWidth = ((Icon)UIManager.get("CheckBox.icon")).getIconWidth() + (Integer)UIManager.get("CheckBox.textIconGap") / 2;
        }
        if (mouseEvent.getX() <= this.m_checkBoxWidth) {
            this.doToggleCheck();
        }
    }
}

