/*
 * Decompiled with CFR 0.152.
 */
package jexifviewer;

import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.net.URL;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import jexifviewer.JMainFrame;
import jexifviewer.JSettings;
import shared.cvshelper.Cvs;
import shared.files.JPathHelper;

@Cvs(header="$Header: /home/reiner/cvs/Java/JExifViewer/src/jexifviewer/Main.java,v 1.8 2010/04/03 07:59:53 reiner Exp $")
public final class Main {
    public static final String m_version = "1.8";
    public static final String m_versionString = "Author: Reiner Pr\u00f6ls\nVersion: 1.8\nCopyright \u00a9 2006-2010 by Reiner Pr\u00f6ls\nLicense: GPLv3";
    public static JMainFrame m_mainFrame;
    public static JSettings m_settings;
    public static ImageIcon m_icon16;
    public static ImageIcon m_icon32;
    public static Locale m_sysLocale;
    public static SimpleDateFormat m_shortDayOfWeekFormat;
    public static URL m_url_map;

    public static String getMessageBoxCaption() {
        String string = null;
        try {
            string = m_settings.getResBundle().getString("caption");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null) {
            string = new String("JExifViewer");
        }
        return string;
    }

    public static String getString(String string, boolean bl) {
        return m_settings.getResBundleString(string, bl);
    }

    public static String getString(String string) {
        return Main.getString(string, true);
    }

    private static void initGui(String[] stringArray) {
        String[] stringArray2;
        Cloneable cloneable;
        m_icon16 = new ImageIcon(Main.class.getResource("icon16x16.png"));
        m_icon32 = new ImageIcon(Main.class.getResource("icon32x32.png"));
        m_url_map = Main.class.getResource("map.png");
        if (m_settings.isDebug()) {
            cloneable = System.getProperties();
            stringArray2 = ((Properties)cloneable).propertyNames();
            while (stringArray2.hasMoreElements()) {
                String string = (String)stringArray2.nextElement();
                String string2 = System.getProperty(string);
                System.err.println(string + ": " + string2);
            }
        }
        if (!m_settings.init("JExifViewerLang", "JExifViewer")) {
            System.exit(1);
        }
        cloneable = new DateFormatSymbols();
        stringArray2 = new String[8];
        stringArray2[0] = "";
        for (int i = 0; i < 7; ++i) {
            stringArray2[i + 1] = Main.getString(String.format("weekday_short_%1$d", i));
        }
        ((DateFormatSymbols)cloneable).setShortWeekdays(stringArray2);
        m_shortDayOfWeekFormat.setDateFormatSymbols((DateFormatSymbols)cloneable);
        m_mainFrame = new JMainFrame();
        m_mainFrame.setDefaultCloseOperation(3);
        Main.setSize();
        m_mainFrame.setVisible(true);
    }

    public static void setSize() {
        Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        m_mainFrame.setMaximizedBounds(rectangle);
        m_mainFrame.setPreferredSize(m_settings.getSize());
        m_mainFrame.setLocation(m_settings.getLocation());
        m_mainFrame.setSize(m_settings.getSize());
    }

    public static void main(String[] stringArray) {
        final String[] stringArray2 = (String[])stringArray.clone();
        m_settings = new JSettings(true);
        m_settings.load(JPathHelper.addSeparator(System.getProperty("user.home")) + "jexifviewer.properties", m_version);
        m_sysLocale = Locale.getDefault();
        if (m_settings.getLocale().length() > 0) {
            Locale.setDefault(new Locale(m_settings.getLocale()));
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Main.initGui(stringArray2);
            }
        });
    }

    static {
        m_shortDayOfWeekFormat = new SimpleDateFormat("E");
    }
}

