/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.DispatchData;
import com.xrefactory.jedit.XrefCharBuffer;
import com.xrefactory.jedit.XrefTask;
import com.xrefactory.jedit.s;
import java.awt.Component;
import java.io.File;
import javax.swing.JOptionPane;

public class XrefTaskForTagFile
extends XrefTask
implements Runnable {
    DispatchData data;
    boolean showReport;
    static XrefTaskForTagFile activeProcess = null;
    static boolean running = false;
    Object lock = new String("This thread lock");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        activeProcess = this;
        try {
            this.startThis();
            XrefCharBuffer report = this.getTaskOutput(this.data);
            if (this.showReport) {
                s.showTagFileReport(report, this.data.callerComponent);
            }
        }
        catch (Exception eee) {
            if (s.debug) {
                eee.printStackTrace(System.err);
            }
            JOptionPane.showMessageDialog(s.getProbableParent(this.data.callerComponent), eee, "Xrefactory Error", 0);
        }
        this.killThis(false);
        activeProcess = null;
        running = false;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    public XrefTaskForTagFile(String opt, DispatchData data, boolean showReport) {
        this.xrefOutputFile = new File(s.tagProcessingReportFile);
        this.keepOutputFile = true;
        this.data = data;
        this.showReport = showReport;
        this.restartable = false;
        this.startingOption.clear();
        this.startingOption.add("-o");
        this.startingOption.add(this.xrefOutputFile.getAbsolutePath());
        String project = s.getOrComputeActiveProject();
        if (project == null) {
            return;
        }
        s.displayProjectInformationLater();
        this.startingOption.add("-p");
        this.startingOption.add(project);
        this.startingOption.add(opt);
        this.startingOption.add("-errors");
        this.addModifiedFilesOptions(this.startingOption, true);
    }

    public static boolean passCheckForRunningProcess(String message, Component caller) {
        while (running) {
            int res = JOptionPane.showConfirmDialog(caller, message, "Tag processing", 1);
            if (res == 0) {
                if (activeProcess == null) continue;
                activeProcess.killThis(false);
                continue;
            }
            if (res != 2) continue;
            return false;
        }
        return true;
    }

    public static XrefTaskForTagFile runXrefOnTagFile(String option, String message, boolean showReport, DispatchData data) {
        if (!XrefTaskForTagFile.passCheckForRunningProcess("A Tag maintenance process is yet running. Kill it?", data.callerComponent)) {
            return null;
        }
        DispatchData ndata = new DispatchData(data);
        ndata.progressMessage = message;
        XrefTaskForTagFile task = new XrefTaskForTagFile(option, ndata, showReport);
        running = true;
        task.run();
        return task;
    }
}

