/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.DispatchData;
import com.xrefactory.jedit.Opt;
import com.xrefactory.jedit.Progress;
import com.xrefactory.jedit.XrefCharBuffer;
import com.xrefactory.jedit.XrefStringArray;
import com.xrefactory.jedit.s;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.Selection;

public class XrefTask {
    public boolean killed = false;
    public Process pp = null;
    public OutputStream oo = null;
    public InputStream ii = null;
    public boolean restartable = true;
    XrefStringArray startingOption = new XrefStringArray();
    XrefStringArray tmpOption = new XrefStringArray();
    Progress progress = null;
    LinkedList temporaryFiles = new LinkedList();
    File xrefOutputFile;
    boolean keepOutputFile = false;

    public void killThis(boolean verbose) {
        this.killed = true;
        if (s.debug) {
            System.err.println("killing the process");
        }
        if (this.progress != null) {
            this.progress.setVisible(false);
            this.progress = null;
        }
        if (this.pp != null) {
            this.pp.destroy();
            this.pp = null;
            if (verbose) {
                SwingUtilities.invokeLater(new s.MessageDisplayer("Xrefactory task killed", true));
            }
        } else if (verbose) {
            SwingUtilities.invokeLater(new s.MessageDisplayer("No task to kill", true));
        }
        if (this.oo != null) {
            try {
                this.oo.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.oo = null;
        }
        if (this.ii != null) {
            try {
                this.ii.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.ii = null;
        }
        try {
            this.deleteXrefOutputFile();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.removeTemporaryFiles();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void startThis() throws IOException {
        Runtime rt = Runtime.getRuntime();
        XrefStringArray ex = new XrefStringArray();
        ex.add(s.xrefTaskPath);
        ex.add("-xrefactory-II");
        ex.add("-editor=jedit");
        ex.add("-xrefrc=" + s.configurationFile);
        ex.add("-crlfconversion");
        ex.add("-crconversion");
        ex.add(this.startingOption);
        String[] cmds = ex.toCmdArray();
        if (s.debug) {
            String dd = "";
            int i = 0;
            while (i < cmds.length) {
                dd = dd + cmds[i] + " ";
                ++i;
            }
            System.err.println(dd);
        }
        this.pp = rt.exec(cmds);
        this.oo = this.pp.getOutputStream();
        this.ii = this.pp.getInputStream();
        this.killed = false;
    }

    public void saveEditedBufferToTemporaryFile(Buffer buffer, String tmpFile) {
        try {
            buffer.save(s.view, tmpFile, false);
            File ofl = new File(tmpFile);
            this.temporaryFiles.add(new TmpBufferFile(buffer, ofl));
        }
        catch (Exception e) {
            if (s.debug) {
                e.printStackTrace(System.err);
            }
            JOptionPane.showMessageDialog((Component)s.view, "While saving tmp files: " + e, "Xrefactory Error", 0);
        }
    }

    void deleteXrefOutputFile() {
        if (this.xrefOutputFile != null && this.xrefOutputFile.exists() && !s.debug) {
            this.xrefOutputFile.delete();
        }
    }

    void removeTemporaryFiles() {
        if (!this.keepOutputFile) {
            this.deleteXrefOutputFile();
        }
        while (!this.temporaryFiles.isEmpty()) {
            TmpBufferFile ff = (TmpBufferFile)this.temporaryFiles.getFirst();
            this.temporaryFiles.removeFirst();
            if (s.debug) continue;
            ff.savedAsFile.delete();
        }
    }

    void passeBufferThrougTmpFile(XrefStringArray args, Buffer buff) {
        File xrefTmpFile = s.getNewTmpFileName();
        String xrefTmpFilename = xrefTmpFile.getAbsolutePath();
        args.add("-preload");
        args.add(buff.getPath());
        args.add(xrefTmpFilename);
        this.saveEditedBufferToTemporaryFile(buff, xrefTmpFilename);
    }

    public synchronized void addModifiedFilesOptions(XrefStringArray args, boolean addCurrent) {
        Buffer[] buffs = jEdit.getBuffers();
        Buffer cb = s.getBuffer();
        int i = 0;
        while (i < buffs.length) {
            if (buffs[i].isDirty() && (buffs[i] != cb || addCurrent)) {
                this.passeBufferThrougTmpFile(args, buffs[i]);
            }
            ++i;
        }
        VFSManager.waitForRequests();
    }

    public synchronized void addCurrentFileOptions(XrefStringArray args) {
        Selection selection = s.getTextArea().getSelectionAtOffset(s.getTextArea().getCaretPosition());
        this.passeBufferThrougTmpFile(args, s.getBuffer());
        VFSManager.waitForRequests();
        args.add(s.getBuffer().getPath());
        if (selection == null) {
            args.add("-olcursor=" + s.getTextArea().getCaretPosition());
            args.add("-olmark=" + s.getTextArea().getCaretPosition());
        } else {
            args.add("-olcursor=" + selection.getEnd());
            args.add("-olmark=" + selection.getStart());
        }
    }

    public void addFileProcessingOptions(XrefStringArray args) {
        this.addModifiedFilesOptions(args, false);
        this.addCurrentFileOptions(args);
    }

    void sendDataToRunningProcess(String data) throws IOException {
        if (s.debug) {
            System.err.println("sending " + data);
        }
        PrintStream ss = new PrintStream(this.oo);
        ss.println(data);
        this.oo.flush();
        if (s.debug) {
            System.err.println("sent");
        }
    }

    public XrefCharBuffer getTaskOutput(DispatchData data) {
        XrefCharBuffer res = new XrefCharBuffer();
        int c = 32;
        boolean loop = true;
        try {
            while (loop) {
                res.clear();
                while (c != -1 && Character.isWhitespace((char)c)) {
                    c = this.ii.read();
                }
                while (c != -1 && loop) {
                    res.append("" + (char)c);
                    if (s.debug) {
                        System.err.println("got : " + c + "==" + (char)c);
                    }
                    if (c == 62) {
                        loop = false;
                    }
                    c = this.ii.read();
                }
                loop = false;
                if (res.toString().equals("<progress>")) {
                    boolean loop2 = true;
                    int val = 0;
                    while (c != -1 && loop2) {
                        if (c >= 48 && c <= 57) {
                            val = val * 10 + c - 48;
                        } else {
                            loop2 = false;
                        }
                        c = this.ii.read();
                    }
                    if (s.debug) {
                        System.err.println("progress == " + val);
                    }
                    if (this.progress == null) {
                        this.progress = Progress.crNew(data.callerComponent, data.progressMessage);
                    }
                    if (s.debug) {
                        System.err.println("setting progress to " + val);
                    }
                    if (!this.progress.setProgress(val)) {
                        this.killThis(true);
                        loop = false;
                        continue;
                    }
                    loop = true;
                    continue;
                }
                if (!res.toString().equals("<sync>")) {
                    if (this.killed) {
                        res.clear();
                    } else {
                        if (this.pp != null) {
                            this.pp.destroy();
                        }
                        if (this.ii != null) {
                            while (c != -1) {
                                res.append("" + (char)c);
                                c = this.ii.read();
                            }
                        }
                        if (s.debug) {
                            System.err.println("kill due to synchro problem");
                        }
                        new Exception().printStackTrace(System.err);
                        JOptionPane.showMessageDialog(s.getProbableParent(data.callerComponent), "Internal Error, synchro problem: " + res.toString(), "Xrefactory Error", 0);
                        res.clear();
                        if (s.debug) {
                            res.appendFileContent(this.xrefOutputFile);
                        }
                        this.killThis(false);
                    }
                } else {
                    res.clear();
                    res.appendFileContent(this.xrefOutputFile);
                    this.deleteXrefOutputFile();
                    this.removeTemporaryFiles();
                }
                if (this.progress == null) continue;
                this.progress.setVisible(false);
                this.progress = null;
            }
        }
        catch (Exception e) {
            if (s.debug) {
                e.printStackTrace();
            }
            JOptionPane.showMessageDialog(s.getProbableParent(data.callerComponent), "Communication problem: " + e, "Xrefactory Error", 0);
        }
        return res;
    }

    public synchronized XrefCharBuffer callProcess(XrefStringArray args, DispatchData data) {
        String putargs = null;
        XrefCharBuffer res = new XrefCharBuffer();
        boolean freshProcess = false;
        putargs = args.toString();
        putargs = putargs + " end-of-options\n";
        try {
            if (this.pp == null && this.restartable) {
                this.startThis();
            }
            this.sendDataToRunningProcess(putargs);
        }
        catch (Exception e) {
            if (!this.restartable) {
                if (s.debug) {
                    e.printStackTrace();
                }
                JOptionPane.showMessageDialog(s.getProbableParent(data.callerComponent), "Internal Error: process exited " + e, "Xrefactory Error", 0);
                return res;
            }
            this.killThis(false);
            try {
                this.startThis();
                this.sendDataToRunningProcess(putargs);
            }
            catch (Exception e2) {
                this.killThis(false);
                if (s.debug) {
                    e2.printStackTrace();
                }
                JOptionPane.showMessageDialog(s.getProbableParent(data.callerComponent), "Internal Error: can't start process: " + e2, "Xrefactory Error", 0);
                if (s.debug) {
                    e.printStackTrace();
                }
                return res;
            }
        }
        res = this.getTaskOutput(data);
        return res;
    }

    public static void addCommonOptions(XrefStringArray options, DispatchData data) {
        options.add("-user");
        options.add(s.getViewParameter(data.viewId));
        String project = Opt.activeProject();
        if (s.activeProject != null) {
            options.add("-p");
            options.add(s.activeProject);
        }
        if (!jEdit.getBooleanProperty((String)"xrefactory.browser-src-code-in-references", (boolean)false)) {
            options.add("-rlistwithoutsrc");
        }
    }

    public XrefCharBuffer callProcessOnFile(XrefStringArray args, DispatchData data) {
        XrefCharBuffer res = new XrefCharBuffer();
        Object off = null;
        Object ofl = null;
        try {
            XrefStringArray options = new XrefStringArray(args);
            this.addFileProcessingOptions(options);
            XrefTask.addCommonOptions(options, data);
            res = this.callProcess(options, data);
        }
        catch (Exception e) {
            if (s.debug) {
                e.printStackTrace();
            }
            JOptionPane.showMessageDialog((Component)s.view, "Internal Error while passing file to task: " + e, "Xrefactory Error", 0);
        }
        return res;
    }

    public XrefCharBuffer callProcess(String[] options, DispatchData data) {
        this.tmpOption.clear();
        int i = 0;
        while (i < options.length) {
            if (options[i] != null) {
                this.tmpOption.add(options[i]);
            }
            ++i;
        }
        XrefTask.addCommonOptions(this.tmpOption, data);
        return this.callProcess(this.tmpOption, data);
    }

    public XrefCharBuffer callProcessSingleOpt(String option, DispatchData data) {
        return this.callProcess(new String[]{option}, data);
    }

    public XrefCharBuffer callProcessOnFileNoSaves(String[] options, DispatchData data) {
        this.tmpOption.clear();
        int i = 0;
        while (i < options.length) {
            this.tmpOption.add(options[i]);
            ++i;
        }
        XrefTask.addCommonOptions(this.tmpOption, data);
        this.addCurrentFileOptions(this.tmpOption);
        return this.callProcess(this.tmpOption, data);
    }

    public XrefCharBuffer callProcessOnFile(String[] options, DispatchData data) {
        this.tmpOption.clear();
        int i = 0;
        while (i < options.length) {
            this.tmpOption.add(options[i]);
            ++i;
        }
        return this.callProcessOnFile(this.tmpOption, data);
    }

    public XrefCharBuffer callProcessOnFileSingleOpt(String option, DispatchData data) {
        this.tmpOption.clear();
        if (option != null) {
            this.tmpOption.add(option);
        }
        return this.callProcessOnFile(this.tmpOption, data);
    }

    static class TmpBufferFile {
        Buffer buffer;
        File savedAsFile;

        TmpBufferFile(Buffer buffer, File file) {
            this.buffer = buffer;
            this.savedAsFile = file;
        }
    }
}

