/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.Dispatch;
import com.xrefactory.jedit.DispatchData;
import com.xrefactory.jedit.XrefCharBuffer;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JTextArea;

class XrefRefListArea
extends JTextArea {
    DispatchData data;
    int lastSelectedLine = -1;

    void renewSelection() {
        try {
            int cp = this.getCaretPosition();
            int ln = this.getLineOfOffset(cp);
            if (ln != this.lastSelectedLine) {
                this.lastSelectedLine = ln;
                DispatchData ndata = new DispatchData(this.data, (Component)this);
                XrefCharBuffer receipt = ndata.xTask.callProcessSingleOpt("-olcxgoto" + (ln + 1), ndata);
                Dispatch.dispatch(receipt, ndata);
            }
            this.setCaretPosition(this.getLineEndOffset(ln) - 1);
            this.moveCaretPosition(this.getLineStartOffset(ln));
            this.getCaret().setSelectionVisible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void previous() {
        try {
            int cp = this.getCaretPosition();
            int ln = this.getLineOfOffset(cp);
            int lb = this.getLineStartOffset(ln);
            this.moveCaretPosition(lb - 1);
            this.renewSelection();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void next() {
        try {
            int cp = this.getCaretPosition();
            int ln = this.getLineOfOffset(cp);
            int le = this.getLineEndOffset(ln);
            this.moveCaretPosition(le + 1);
            this.renewSelection();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void highlightReference(int actn) {
        try {
            this.moveCaretPosition(this.getLineStartOffset(actn) + 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lastSelectedLine = actn;
        this.renewSelection();
    }

    public void setCurrentRef(int n) {
        this.highlightReference(n);
    }

    public void setRefs(String list, int actn) {
        this.setText(list);
        this.repaint();
        this.highlightReference(actn);
    }

    XrefRefListArea(DispatchData data) {
        this("", data);
    }

    XrefRefListArea(String list, DispatchData data) {
        super(list);
        this.data = data;
        this.setEditable(false);
        MouseAdapter ma = new MouseAdapter();
        this.addMouseListener(ma);
        this.addMouseMotionListener(ma);
        this.addKeyListener(ma);
    }

    class MouseAdapter
    extends java.awt.event.MouseAdapter
    implements MouseMotionListener,
    KeyListener {
        MouseAdapter() {
        }

        public void mouseClicked(MouseEvent e) {
            XrefRefListArea.this.lastSelectedLine = -1;
            XrefRefListArea.this.renewSelection();
            e.consume();
        }

        public void mouseDragged(MouseEvent e) {
            XrefRefListArea.this.renewSelection();
            e.consume();
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            int code = e.getKeyCode();
            if (code == 38) {
                XrefRefListArea.this.previous();
                e.consume();
            } else if (code == 40) {
                XrefRefListArea.this.next();
                e.consume();
            }
        }

        public void keyReleased(KeyEvent e) {
            XrefRefListArea.this.renewSelection();
        }

        public void keyTyped(KeyEvent e) {
        }
    }
}

