/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.AWTPump;
import com.xrefactory.jedit.s;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

class Progress
extends JDialog {
    ProgressPanel panel;
    Component parent;

    public boolean setProgress(int val) {
        this.panel.setProgress(val);
        this.paint(this.getGraphics());
        if (!this.isVisible()) {
            return false;
        }
        AWTPump.pumpEventsForHierarchy(s.getParentDialog(this));
        return this.isVisible();
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.dispose();
            return true;
        }
        return super.handleEvent(event);
    }

    public static Progress crNew(Component parent, String message) {
        Progress res;
        JDialog parentd = s.getParentDialog(parent);
        if (parentd != null) {
            res = new Progress((Dialog)parentd, message);
        } else {
            JFrame parentf = s.getParentFrame(parent);
            res = new Progress((Frame)parentf, message);
        }
        return res;
    }

    void init(Component parent, String message) {
        this.parent = parent;
        this.panel = new ProgressPanel(message);
        this.setContentPane(this.panel);
        this.pack();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    Progress(Dialog parent, String message) {
        super(parent, "Progress");
        this.init(parent, message);
    }

    Progress(Frame parent, String message) {
        super(parent, "Progress");
        this.init(parent, message);
    }

    public static class ProgressPanel
    extends JPanel {
        private int count;
        private int max;
        ProgressBar bar;

        void setProgress(int v) {
            this.count = v;
        }

        ProgressPanel(String message) {
            int y = -1;
            JComponent[] buttons = new JButton[]{new ButtonCancel()};
            this.bar = new ProgressBar(100);
            this.setLayout(new GridBagLayout());
            s.addGbcComponent(this, 0, ++y, 3, 1, 1, 1, 1, new JPanel());
            s.addGbcComponent(this, 1, ++y, 1, 1, 1, 1, 1, new JLabel(message));
            s.addGbcComponent(this, 0, ++y, 1, 1, 1, 1, 1, new JPanel());
            s.addGbcComponent(this, 1, y, 1, 1, 100, 1, 1, this.bar);
            s.addGbcComponent(this, 2, y, 1, 1, 1, 1, 1, new JPanel());
            s.addGbcComponent(this, 0, ++y, 3, 1, 1, 1, 1, new JPanel());
            s.addExtraButtonLine(this, 0, ++y, 3, 1, 1, 1, buttons, true);
            s.addGbcComponent(this, 0, ++y, 3, 1, 1, 1, 1, new JPanel());
        }

        class ButtonCancel
        extends JButton
        implements ActionListener {
            ButtonCancel() {
                super("Cancel");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent e) {
                s.getParentDialog(this).setVisible(false);
            }
        }

        public class ProgressBar
        extends JPanel {
            public void paint(Graphics g) {
                Dimension frameDimension = this.getSize();
                double percentComplete = (double)ProgressPanel.this.count * 100.0 / (double)ProgressPanel.this.max;
                int barPixelWidth = (frameDimension.width - 2) * ProgressPanel.this.count / ProgressPanel.this.max;
                g.setColor(Color.red);
                g.fillRect(1, 1, barPixelWidth, frameDimension.height - 2);
                g.setColor(Color.black);
                g.drawRect(0, 0, frameDimension.width - 1, frameDimension.height - 1);
            }

            public ProgressBar(int totalItems) {
                ProgressPanel.this.count = 0;
                ProgressPanel.this.max = totalItems;
                this.setLayout(null);
                this.addNotify();
                this.setPreferredSize(new Dimension(400, 10));
            }
        }
    }
}

