/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.XrefCharBuffer;
import com.xrefactory.jedit.s;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;

public class ExtractMethodDialog
extends JDialog {
    public ExtractMethodDialog(String invocation, String theHead, String theTail, int targetLine, String xtype) {
        super((Frame)s.view, "Xrefactory Extraction");
        this.setContentPane(new ExtractMethodPanel(invocation, theHead, theTail, targetLine, xtype));
        this.setModal(true);
        this.pack();
        this.setLocationRelativeTo((Component)s.view);
        this.setVisible(true);
    }

    public static class ExtractMethodPanel
    extends JPanel
    implements KeyListener {
        String bodyString;
        String invocationString;
        JTextField name;
        int definitionLine;
        int invocationLine;

        void actionContinue() {
            int sl;
            int sb;
            JEditTextArea text = s.getTextArea();
            Buffer buff = s.getBuffer();
            s.getParentDialog(this).setVisible(false);
            Selection[] sels = text.getSelection();
            if (sels.length == 0) {
                SwingUtilities.invokeLater(new s.MessageDisplayer("No selection found", true));
                return;
            }
            Selection sel = sels[0];
            if (sel.getStart() < sel.getEnd()) {
                sb = sel.getStart();
                sl = sel.getEnd() - sel.getStart();
            } else {
                sb = sel.getEnd();
                sl = sel.getStart() - sel.getEnd();
            }
            buff.remove(sb, sl);
            buff.insert(sb, this.invocationString);
            int sbline = buff.getLineOfOffset(sb);
            int invlines = s.getNumberOfCharOccurences(this.invocationString, '\n');
            buff.indentLines(sbline, sbline + invlines - 1);
            this.invocationLine = sbline + 1;
            int bodylines = s.getNumberOfCharOccurences(this.bodyString, '\n');
            buff.insert(buff.getLineStartOffset(this.definitionLine - 1), this.bodyString);
            this.invocationLine += bodylines;
            buff.indentLines(this.definitionLine - 1, this.definitionLine - 1 + bodylines - 1);
        }

        void actionCancel() {
            s.xExtractMethod = null;
            s.getParentDialog(this).setVisible(false);
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            int code = e.getKeyCode();
            if (code == 27) {
                e.consume();
                this.actionCancel();
            } else if (code == 10) {
                e.consume();
                this.actionContinue();
            }
        }

        ExtractMethodPanel(String invocation, String theHead, String theTail, int definitionLine, String xtype) {
            this.definitionLine = definitionLine;
            s.xExtractMethod = this;
            JComponent[] buttons = new JButton[]{new ButtonCancel(), new ButtonContinue()};
            this.setLayout(new GridBagLayout());
            XrefCharBuffer mm = new XrefCharBuffer();
            mm.append("\n");
            mm.append(theHead);
            mm.append("\t//original code starts here\n");
            mm.append(s.getTextArea().getSelectedText());
            if (mm.lastChar() != '\n') {
                mm.append("\n");
            }
            mm.append("\t//original code ends here\n");
            mm.append(theTail);
            JTextArea newMethod = new JTextArea(mm.toString());
            newMethod.setEditable(false);
            newMethod.setBackground(s.light_gray);
            newMethod.setTabSize(4);
            JScrollPane newMethodSc = new JScrollPane(newMethod);
            mm.clear();
            mm.append(theHead);
            mm.append(s.getTextArea().getSelectedText());
            if (mm.lastChar() != '\n') {
                mm.append("\n");
            }
            mm.append(theTail);
            this.bodyString = mm.toString();
            mm.clear();
            mm.append("\n");
            mm.append(invocation);
            JTextArea invoked = new JTextArea(mm.toString());
            invoked.setEditable(false);
            invoked.setBackground(s.light_gray);
            invoked.setTabSize(4);
            mm.clear();
            mm.append(invocation);
            this.invocationString = mm.toString();
            this.name = xtype.length() > 1 ? new JTextField(xtype.substring(0, xtype.length() - 1)) : new JTextField("newMethod");
            this.name.addKeyListener(this);
            int y = 0;
            s.addGbcComponent(this, 0, y, 4, 1, 1, 1, 1, new JPanel());
            s.addGbcComponent(this, 0, ++y, 4, 1, 1, 1, 1, new JLabel("Xrefactory Proposes Following New Definition:", 0));
            s.addGbcComponent(this, 0, ++y, 4, 1, 1, 1, 1, new JPanel());
            s.addGbcComponent(this, 0, ++y, 1, 1, 1, 1, 1, new JPanel());
            s.addGbcComponent(this, 1, y, 2, 1, 100, 100, 1, newMethodSc);
            s.addGbcComponent(this, 3, y, 1, 1, 1, 1, 1, new JPanel());
            s.addGbcComponent(this, 0, ++y, 4, 1, 1, 1, 1, new JLabel("with Invocation:", 0));
            s.addGbcComponent(this, 0, ++y, 1, 1, 1, 1, 1, new JPanel());
            s.addGbcComponent(this, 1, y, 2, 1, 100, 10, 1, new JScrollPane(invoked));
            s.addGbcComponent(this, 3, y, 1, 1, 1, 1, 1, new JPanel());
            s.addGbcComponent(this, 0, ++y, 4, 1, 1, 1, 1, new JPanel());
            s.addGbcComponent(this, 0, ++y, 4, 1, 1, 1, 1, new JSeparator());
            s.addGbcComponent(this, 0, ++y, 4, 1, 1, 1, 1, new JPanel());
            s.addGbcComponent(this, 0, ++y, 4, 1, 1, 1, 1, new JPanel());
            s.addGbcComponent(this, 1, ++y, 1, 1, 1, 1, 1, new JLabel("To be renamed to: ", 2));
            s.addGbcComponent(this, 2, y, 1, 1, 1000, 1, 2, this.name);
            s.addGbcComponent(this, 0, ++y, 4, 1, 1, 1, 1, new JPanel());
            s.addExtraButtonLine(this, 0, ++y, 4, 1, 1, 1, buttons, true);
            s.addGbcComponent(this, 0, ++y, 4, 1, 1, 1, 1, new JPanel());
        }

        class ButtonContinue
        extends JButton
        implements ActionListener {
            ButtonContinue() {
                super("Apply");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent e) {
                ExtractMethodPanel.this.actionContinue();
            }
        }

        class ButtonCancel
        extends JButton
        implements ActionListener {
            ButtonCancel() {
                super("Cancel");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent e) {
                ExtractMethodPanel.this.actionCancel();
            }
        }
    }
}

