/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.CompletionDialog;
import com.xrefactory.jedit.Dispatch;
import com.xrefactory.jedit.DispatchData;
import com.xrefactory.jedit.Opt;
import com.xrefactory.jedit.XrefCharBuffer;
import com.xrefactory.jedit.s;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.jEdit;

public class CompletionDialog3
extends JDialog {
    static final int trimWidth;
    static final int trimHeight;
    DispatchData data;
    XrefCharBuffer completions = new XrefCharBuffer();
    LineData[] lns;
    JPanel table;
    JScrollPane scrollPane;
    int selectedLine = 0;
    int insertOffset;
    Buffer insertBuffer;
    String insertFile;
    String typedId;
    HistoryItem[] history = new HistoryItem[100];
    int historyIndex = 0;
    CompletionKeyAdapter keyAdapter = new CompletionKeyAdapter();
    public static CompletionDialog3 lastcDialog;
    int x;
    int y;
    int mx;
    int my;

    void callCompletionGoto() {
        int line = this.selectedLine + 1;
        DispatchData ndata = new DispatchData(this.data, (Component)this);
        XrefCharBuffer receipt = ndata.xTask.callProcessSingleOpt("-olcxcgoto" + line, ndata);
        Dispatch.dispatch(receipt, ndata);
    }

    void moveSelection(int nsel) {
        if (this.lns.length - 1 == 1) {
            return;
        }
        if (nsel < 0) {
            nsel = 0;
        }
        if (nsel > this.lns.length - 2) {
            nsel = this.lns.length - 2;
        }
        this.lns[this.selectedLine].p1.setBackground(this.lns[this.selectedLine].bgColor);
        this.lns[this.selectedLine].p2.setBackground(this.lns[this.selectedLine].bgColor);
        this.lns[this.selectedLine].p3.setBackground(this.lns[this.selectedLine].bgColor);
        this.selectedLine = nsel;
        this.lns[this.selectedLine].p1.setBackground(s.completionSelectionColor);
        this.lns[this.selectedLine].p2.setBackground(s.completionSelectionColor);
        this.lns[this.selectedLine].p3.setBackground(s.completionSelectionColor);
        JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
        int scrollmin = jScrollBar.getValue();
        int scrollsize = (int)this.scrollPane.getViewportBorderBounds().getHeight();
        int scrollmax = scrollmin + scrollsize;
        Point ll = new Point();
        ll = this.lns[this.selectedLine].p1.getLocation(ll);
        if (ll.y < scrollmin) {
            jScrollBar.setValue(ll.y);
        } else if (ll.y + this.lns[this.selectedLine].p1.getHeight() > scrollmax) {
            jScrollBar.setValue(ll.y + this.lns[this.selectedLine].p1.getHeight() - scrollsize);
        }
    }

    int tableLineHeight() {
        int lineheight = this.table.getHeight() / (this.lns.length - 1);
        return lineheight;
    }

    int scrollPaneDisplyedLines() {
        return (int)(this.scrollPane.getViewportBorderBounds().getHeight() / (double)this.tableLineHeight());
    }

    int searchForwardForSymbol(String sym) {
        String s2 = sym.toLowerCase();
        int slen = s2.length();
        int i = this.selectedLine;
        while (i < this.lns.length - 1) {
            if (this.completions.substring(this.lns[i].cidents, this.lns[i].cidents + slen).toLowerCase().equals(s2)) {
                return i;
            }
            ++i;
        }
        return i;
    }

    void recordHistory() {
        if (this.historyIndex >= 100) {
            System.arraycopy(this.history, 1, this.history, 0, 99);
            --this.historyIndex;
        }
        if (this.history[this.historyIndex] == null) {
            this.history[this.historyIndex] = new HistoryItem();
        }
        this.history[this.historyIndex].typedId = this.typedId;
        this.history[this.historyIndex].selection = this.selectedLine;
        ++this.historyIndex;
    }

    void escapeFromCompletionDialog() {
        String cc = jEdit.getBooleanProperty((String)"xrefactory.completion-del-pending-id") ? s.completionIdBeforeCaret + s.completionIdAfterCaret : s.completionIdBeforeCaret;
        s.insertCompletionDoNotMoveCaret(this.insertBuffer, this.insertOffset, cc);
        this.closeDialog();
    }

    public void keyPressedAction(KeyEvent e) {
        char key = e.getKeyChar();
        int code = e.getKeyCode();
        int mod = e.getModifiers();
        if (code != 38 && code != 40 && code != 224 && code != 225 && code != 33 && code != 34 && code != 37 && code != 39 && code != 36 && code != 35) {
            e.consume();
        }
        if (code == 10) {
            int line = this.selectedLine + 1;
            this.setVisible(false);
            DispatchData ndata = new DispatchData(this.data, (Component)this);
            XrefCharBuffer receipt = ndata.xTask.callProcessSingleOpt("-olcomplselect" + line, ndata);
            Dispatch.dispatch(receipt, ndata);
        } else if (code == 32 && (e.getModifiers() & 2) != 0) {
            this.closeDialog();
            CompletionDialog.completion(s.view);
        } else if (code == 32) {
            this.callCompletionGoto();
            SwingUtilities.invokeLater(new s.FocusRequester(this.table));
        } else if (code == 8) {
            if (this.historyIndex > 0) {
                --this.historyIndex;
                this.typedId = this.history[this.historyIndex].typedId;
                this.moveSelection(this.history[this.historyIndex].selection);
                s.insertCompletion(this.insertBuffer, this.insertOffset, this.typedId);
            }
        } else if (code == 27) {
            this.escapeFromCompletionDialog();
            if ((e.getModifiers() & 8) == 0 && (e.getModifiers() & 2) == 0) {
                s.moveToPosition(s.getParentView(this), this.insertFile, this.insertOffset + s.completionIdBeforeCaret.length());
            }
        } else if (code == 40) {
            this.moveSelection(this.selectedLine + 1);
            e.consume();
        } else if (code == 38) {
            this.moveSelection(this.selectedLine - 1);
            e.consume();
        } else if (code == 34) {
            this.moveSelection(this.selectedLine + this.scrollPaneDisplyedLines());
            e.consume();
        } else if (code == 33) {
            this.moveSelection(this.selectedLine - this.scrollPaneDisplyedLines());
            e.consume();
        } else if (Character.isLetterOrDigit(key) || key == '_' || key == '$') {
            this.recordHistory();
            this.typedId = this.typedId + key;
            int nsel = this.searchForwardForSymbol(this.typedId);
            if (nsel < this.lns.length - 1) {
                int symIndex = this.lns[nsel].cidents;
                this.typedId = this.completions.substring(symIndex, symIndex + this.typedId.length());
            }
            this.moveSelection(nsel);
            s.insertCompletion(this.insertBuffer, this.insertOffset, this.typedId);
        } else if ("`~!@#$%^&*()_+|-=\\{}[]:\";'<>?,./".indexOf(key) != -1) {
            this.closeDialog();
            s.getBuffer().insert(s.getCaretPosition(), "" + key);
        }
    }

    void closeDialog() {
        this.setVisible(false);
    }

    public static Color colorShift(Color c, int cs) {
        int r = c.getRed() + cs;
        int g = c.getGreen() + cs;
        int b = c.getBlue() + cs;
        if (r > 255) {
            r = 255;
        }
        if (g > 255) {
            g = 255;
        }
        if (b > 255) {
            b = 255;
        }
        return new Color(r, g, b);
    }

    public JPanel crCompletionStringLine(int from, int to, Font f1, Font f2, Color c1, Color c2) {
        int i = from;
        while (i < to) {
            if (!Character.isJavaIdentifierPart(this.completions.buf[i]) && this.completions.buf[i] != '.') break;
            ++i;
        }
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        JLabel l1 = new JLabel(this.completions.substring(from, i));
        l1.setForeground(c1);
        l1.setFont(f1);
        p.add(l1);
        JLabel l2 = new JLabel(this.completions.substring(i, to));
        l2.setForeground(c2);
        l2.setFont(f2);
        p.add(l2);
        return p;
    }

    void setBackgroundColors() {
        Color[] bgc = new Color[]{jEdit.getColorProperty((String)"xrefactory.completion-bgcolor", (Color)s.completionBgDefaultColor), jEdit.getColorProperty((String)"xrefactory.completion-bgcolor2", (Color)s.completionBgDefaultColor2)};
        int ci = 0;
        int i = 0;
        while (i < this.lns.length - 1) {
            Color cc;
            if (i > 0 && !this.lns[i].vclasses.equals(this.lns[i - 1].vclasses)) {
                ci = (ci + 1) % 2;
            }
            this.lns[i].bgColor = cc = bgc[ci];
            this.lns[i].p1.setBackground(cc);
            this.lns[i].p2.setBackground(cc);
            this.lns[i].p3.setBackground(cc);
            ++i;
        }
    }

    public void refreshTable() {
        int n = this.lns.length - 1;
        this.table = new JPanel();
        this.table.setLayout(null);
        Font f1 = jEdit.getFontProperty((String)"xrefactory.completion-symbol-font", (Font)s.defaultComplSymFont);
        Font f2 = jEdit.getFontProperty((String)"xrefactory.completion-font", (Font)s.defaultFont);
        Color c1 = jEdit.getColorProperty((String)"xrefactory.completion-symbol-fgcolor", (Color)Color.black);
        Color c2 = jEdit.getColorProperty((String)"xrefactory.completion-fgcolor", (Color)Color.black);
        int maxwidth1 = 0;
        int maxwidth2 = 0;
        int maxwidth3 = 0;
        int maxheight = 0;
        int i = 0;
        while (i < this.lns.length - 1) {
            int heigh;
            JLabel l1 = this.lns[i].lines == this.lns[i].cidents ? new JLabel(" ") : new JLabel(this.completions.substring(this.lns[i].lines, this.lns[i].cidents), 4);
            l1.setForeground(c2);
            l1.setFont(f2);
            l1.setOpaque(true);
            this.table.add(l1);
            this.lns[i].p1 = l1;
            Dimension dim = l1.getMinimumSize();
            int width = (int)dim.getWidth();
            if (width > maxwidth1) {
                maxwidth1 = width;
            }
            if ((heigh = (int)dim.getHeight()) > maxheight) {
                maxheight = heigh;
            }
            JPanel p = this.crCompletionStringLine(this.lns[i].cidents, this.lns[i + 1].lines, f1, f2, c1, c2);
            if (s.javaVersion.compareTo("1.4.0") >= 0) {
                p.setFocusable(true);
            }
            p.setBorder(null);
            this.table.add(p);
            this.lns[i].p2 = p;
            Dimension dim2 = p.getMinimumSize();
            int width2 = (int)dim2.getWidth();
            if (width2 > maxwidth2) {
                maxwidth2 = width2;
            }
            if ((heigh = (int)dim2.getHeight()) > maxheight) {
                maxheight = heigh;
            }
            JLabel l2 = this.lns[i].vclasses == null ? new JLabel(" ") : new JLabel(this.lns[i].vclasses, 2);
            l2.setForeground(c2);
            l2.setFont(f2);
            l2.setOpaque(true);
            this.table.add(l2);
            this.lns[i].p3 = l2;
            dim = l2.getMinimumSize();
            width = (int)dim.getWidth();
            if (width > maxwidth3) {
                maxwidth3 = width;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.lns.length - 1) {
            this.lns[i2].p1.setLocation(0, i2 * maxheight);
            this.lns[i2].p1.setSize(maxwidth1, maxheight);
            this.lns[i2].p2.setLocation(maxwidth1, i2 * maxheight);
            this.lns[i2].p2.setSize(maxwidth2, maxheight);
            this.lns[i2].p3.setLocation(maxwidth1 + maxwidth2, i2 * maxheight);
            this.lns[i2].p3.setSize(maxwidth3, maxheight);
            ++i2;
        }
        int totalWidth = maxwidth1 + maxwidth2 + maxwidth3;
        Dimension totalDim = new Dimension(totalWidth, maxheight * (this.lns.length - 1));
        this.table.setSize(totalWidth, maxheight * (this.lns.length - 1));
        this.table.setMinimumSize(totalDim);
        this.table.setPreferredSize(totalDim);
        if (s.javaVersion.compareTo("1.4.0") >= 0) {
            this.table.setFocusable(true);
        }
        this.table.addKeyListener(this.keyAdapter);
        this.table.addMouseListener(new CompletionMouseAdapter());
        this.table.addMouseMotionListener(new CompletionMouseMotionAdapter());
        this.setBackgroundColors();
        this.moveSelection(0);
    }

    public void showDialog() {
        this.refreshTable();
        Dimension dim = new Dimension(this.table.getPreferredSize());
        this.scrollPane.setViewportView(this.table);
        Insets insets = this.scrollPane.getInsets();
        dim.height += insets.top + insets.bottom;
        dim.width += insets.left + insets.right;
        if (s.javaVersion.compareTo("1.4.0") < 0) {
            dim.height += trimHeight;
            dim.width += trimWidth;
        }
        int maxWidth = Opt.completionDialogMaxWidth();
        int maxHeight = Opt.completionDialogMaxHeight();
        if (dim.height > maxHeight) {
            dim.width = (int)((double)dim.width + this.scrollPane.getVerticalScrollBar().getPreferredSize().getWidth());
            dim.height = maxHeight;
        }
        if (dim.width > maxWidth) {
            dim.width = maxWidth;
            dim.height = (int)((double)dim.height + this.scrollPane.getHorizontalScrollBar().getPreferredSize().getHeight());
            if (dim.height > maxHeight) {
                dim.height = maxHeight;
            }
        }
        this.setSize(dim);
        this.moveSelection(0);
        Point recLocation = s.recommendedLocation((Component)s.getTextArea());
        recLocation.x -= this.lns[0].p1.getWidth();
        this.setLocation(recLocation);
        s.moveOnScreen(this);
        this.setVisible(true);
        this.x = this.getX();
        this.y = this.getY();
        SwingUtilities.invokeLater(new s.FocusRequester(this.table));
    }

    void initCompletionCoordinates() {
        this.typedId = s.completionIdBeforeCaret;
        this.insertOffset = s.getCaretPosition() - s.completionIdBeforeCaret.length();
        this.insertBuffer = s.getBuffer();
        this.insertFile = s.getFileName();
        this.historyIndex = 0;
    }

    static CompletionDialog3 initCompletionDialog(DispatchData data, int number, int noFocus) {
        if (lastcDialog == null) {
            lastcDialog = new CompletionDialog3();
        } else if (lastcDialog.isVisible()) {
            lastcDialog.setVisible(false);
            lastcDialog = new CompletionDialog3();
        } else {
            lastcDialog = new CompletionDialog3();
        }
        CompletionDialog3.lastcDialog.data = data;
        CompletionDialog3.lastcDialog.completions.clear();
        CompletionDialog3.lastcDialog.lns = new LineData[number + 1];
        lastcDialog.initCompletionCoordinates();
        return lastcDialog;
    }

    static void showCompletionDialog() {
        lastcDialog.showDialog();
    }

    CompletionDialog3() {
        super((Frame)s.view, "");
        if (s.javaVersion.compareTo("1.4.0") >= 0) {
            this.setUndecorated(true);
        } else {
            this.setResizable(false);
        }
        this.table = new JPanel();
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(5);
        this.setContentPane(this.scrollPane);
        this.enableEvents(8L);
    }

    static {
        JDialog dlg = new JDialog();
        dlg.pack();
        Dimension fdim = dlg.getSize();
        Dimension cdim = dlg.getContentPane().getSize();
        dlg.dispose();
        trimWidth = fdim.width - cdim.width;
        trimHeight = fdim.height - cdim.height;
        lastcDialog = null;
    }

    public class CompletionKeyAdapter
    extends KeyAdapter {
        public void keyPressed(KeyEvent e) {
            CompletionDialog3.this.keyPressedAction(e);
        }

        public void keyReleased(KeyEvent e) {
            e.consume();
        }

        public void keyTyped(KeyEvent e) {
            e.consume();
        }
    }

    public class HistoryItem {
        String typedId;
        int selection;
    }

    public static class LineData {
        int lines;
        int cidents;
        String vclasses;
        Color bgColor;
        JComponent p1;
        JComponent p2;
        JComponent p3;

        LineData(int lines, int cidents, String vcls) {
            this.lines = lines;
            this.cidents = cidents;
            this.vclasses = vcls;
            this.bgColor = null;
            this.p3 = null;
            this.p2 = null;
            this.p1 = null;
        }
    }

    public class CompletionMouseMotionAdapter
    extends MouseMotionAdapter {
        public void mouseDragged(MouseEvent e) {
            if ((e.getModifiers() & 0x10) != 0) {
                int cx = e.getX();
                int cy = e.getY();
                int dx = cx - CompletionDialog3.this.mx;
                int dy = cy - CompletionDialog3.this.my;
                CompletionDialog3.this.x += dx;
                CompletionDialog3.this.y += dy;
                CompletionDialog3.this.setLocation(CompletionDialog3.this.x, CompletionDialog3.this.y);
            }
        }
    }

    public class CompletionMouseAdapter
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            CompletionDialog3.this.mx = e.getX();
            CompletionDialog3.this.my = e.getY();
        }

        public void mouseClicked(MouseEvent e) {
            if ((e.getModifiers() & 0x10) != 0) {
                int lineheight;
                int y = e.getY();
                int line = y / (lineheight = CompletionDialog3.this.tableLineHeight());
                if (line < 0) {
                    line = 0;
                }
                if (line >= CompletionDialog3.this.lns.length - 1) {
                    line = CompletionDialog3.this.lns.length - 2;
                }
                CompletionDialog3.this.moveSelection(line);
                CompletionDialog3.this.callCompletionGoto();
            }
        }
    }
}

