/*
 * 01/09/2002 - 20:43:57
 *
 * NewsChecker.java -
 * Copyright (C) 2002 Csaba Kertsz
 * kcsaba@jdictionary.info
 * www.jdictionary.info
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package info.jdictionary;

import java.net.URL;
import java.util.Vector;
import java.io.DataInputStream;
import info.jdictionary.events.NewsEvent;
import info.jdictionary.listeners.NewsListener;

public class NewsChecker extends Thread {

    private URL url;
    private JDictionary jDictionary;
    private int latestVersion;
    private Vector newsListeners = new Vector();

    public NewsChecker(JDictionary jDictionary) {
        this.jDictionary = jDictionary;
        try {
            this.url = new URL(JDictionary.getString("InfoServerURL") + "/" + JDictionary.getString("LatestNewsFile"));
        }
        catch(java.net.MalformedURLException e) {this.url = null;}
    }


    public void run() {
        latestVersion = getLatestVersion();
        if(latestVersion > jDictionary.getPrefs().lastCheckedNewsVersion)
            notifyNewsListeners(latestVersion);
    }


    private int getLatestVersion() {
        if(url == null)
            return 0;
        byte[] b = new byte[32];
        try {
            DataInputStream dis = new DataInputStream(url.openStream());
            dis.read(b);
        } catch (java.io.IOException e) {
            return 0;
        }
        Float f = new Float(new String(b));
        return f.intValue();
    }


    public int getLatest() {
        return latestVersion;
    }


    void notifyNewsListeners(int latestVersion) {
        Vector tmpList;
        String newsURL = jDictionary.getString("NewsPage");
        NewsEvent event = new NewsEvent(this, latestVersion, newsURL);
        synchronized(this) {
            tmpList = (Vector)newsListeners.clone();
        }
        for(int i = 0; i < tmpList.size(); i++) {
            ((NewsListener)tmpList.elementAt(i)).newsUpdated(event);
        }
    }


    public synchronized void addNewsListener(NewsListener listener) {
        newsListeners.addElement(listener);
    }


    public synchronized void removeNewsListener(NewsListener listener) {
        newsListeners.removeElement(listener);
    }
}