/*
 * Decompiled with CFR 0.152.
 */
package info.jdictionary.pluginstuff;

import info.jdictionary.JDictionary;
import info.jdictionary.Plugin;
import info.jdictionary.Prefs;
import info.jdictionary.events.PluginFilesChangeEvent;
import info.jdictionary.events.PluginScanFinishedEvent;
import info.jdictionary.events.PluginSelectionEvent;
import info.jdictionary.events.PluginStructureChangeEvent;
import info.jdictionary.listeners.PluginFilesChangeListener;
import info.jdictionary.listeners.PluginScanFinishedListener;
import info.jdictionary.listeners.PluginSelectionListener;
import info.jdictionary.listeners.PluginStructureChangeListener;
import info.jdictionary.pluginstuff.PluginInfoSheet;
import info.jdictionary.pluginstuff.PluginLoader;
import java.io.File;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class PluginManager {
    HashMap plugins = new HashMap();
    File[] pluginFiles;
    JDictionary jDictionary;
    PluginInfoSheet selectedPlugin;
    String selectedSubPlugin;
    Vector pluginStructureChangeListeners = new Vector();
    Vector pluginFilesChangeListeners = new Vector();
    Vector pluginSelectionListeners = new Vector();
    Vector pluginScanFinishedListeners = new Vector();
    ScanThread scanThread;

    public PluginManager(JDictionary jDictionary) {
        this.jDictionary = jDictionary;
    }

    void pushPlugin(PluginInfoSheet infoSheet, Plugin plugin) {
        if (!this.plugins.containsKey(infoSheet)) {
            this.plugins.put(infoSheet, new ArrayList());
        }
        ((ArrayList)this.plugins.get(infoSheet)).add(plugin);
    }

    public ArrayList getPlugin(PluginInfoSheet infoSheet) {
        if (this.plugins.containsKey(infoSheet)) {
            return (ArrayList)this.plugins.get(infoSheet);
        }
        return null;
    }

    void removePlugin(PluginInfoSheet infoSheet) {
        Iterator it = ((AbstractList)this.getPlugin(infoSheet)).iterator();
        while (it.hasNext()) {
            ((Plugin)it.next()).stop();
        }
        this.plugins.remove(infoSheet);
        if (this.selectedPlugin == infoSheet) {
            this.selectPlugin(null);
        }
        this.notifyPluginRemovedListeners(infoSheet);
    }

    public void removeAllPlugins() {
        Object[] sheets = this.getSheets();
        int n = 0;
        while (n < sheets.length) {
            this.removePlugin((PluginInfoSheet)sheets[n++]);
        }
    }

    public Object[] getSheets() {
        return this.plugins.keySet().toArray();
    }

    public int getNumberOfLoadedPlugins() {
        return this.plugins.size();
    }

    public int getNumberOfPluginFiles() {
        return this.getPluginFiles().length;
    }

    public void checkPluginDirForChanges() {
        File[] fileList = this.getPluginFiles();
        File[] knownPluginFiles = this.pluginFiles;
        if (knownPluginFiles == null && fileList != null) {
            this.notifyPluginFilesChangedListeners(fileList);
        } else if (knownPluginFiles.length != fileList.length) {
            this.notifyPluginFilesChangedListeners(fileList);
        } else {
            for (int i = 0; i < knownPluginFiles.length; ++i) {
                int j;
                for (j = 0; j < fileList.length && !fileList[j].equals(knownPluginFiles[i]); ++j) {
                }
                if (j != fileList.length) continue;
                this.notifyPluginFilesChangedListeners(fileList);
                break;
            }
        }
        this.pluginFiles = fileList;
    }

    private File[] getGlobalPluginFiles() {
        String globalPluginDirPath = this.jDictionary.getGlobalPluginDirPath();
        if (globalPluginDirPath == null) {
            return new File[0];
        }
        String[] globalPlugins = new File(globalPluginDirPath).list();
        if (globalPlugins == null) {
            globalPlugins = new String[]{};
        }
        File[] files = new File[globalPlugins.length];
        for (int i = 0; i < globalPlugins.length; ++i) {
            files[i] = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(globalPluginDirPath))).append(JDictionary.getFileSeparator()).append(globalPlugins[i]))));
        }
        return files;
    }

    private File[] getLocalPluginFiles() {
        String localPluginDirPath = this.jDictionary.getPluginDirPath();
        if (localPluginDirPath == null) {
            return new File[0];
        }
        String[] localPlugins = new File(localPluginDirPath).list();
        if (localPlugins == null) {
            localPlugins = new String[]{};
        }
        File[] files = new File[localPlugins.length];
        for (int i = 0; i < localPlugins.length; ++i) {
            files[i] = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(localPluginDirPath))).append(JDictionary.getFileSeparator()).append(localPlugins[i]))));
        }
        return files;
    }

    private File[] getAvailablePluginFiles() {
        File[] localPlugins = this.getLocalPluginFiles();
        File[] globalPlugins = this.getGlobalPluginFiles();
        File[] pluginFiles = new File[globalPlugins.length + localPlugins.length];
        for (int i = 0; i < globalPlugins.length; ++i) {
            pluginFiles[i] = globalPlugins[i];
        }
        for (int j = 0; j < localPlugins.length; ++j) {
            pluginFiles[i++] = localPlugins[j];
        }
        return pluginFiles;
    }

    public File[] getPluginFiles() {
        File[] allPluginFiles = this.getAvailablePluginFiles();
        ArrayList<File> pluginFiles = new ArrayList<File>();
        for (int i = 0; i < allPluginFiles.length; ++i) {
            int j;
            if (this.isThereNewerPluginFileAvailable(allPluginFiles[i].getName())) continue;
            for (j = 0; j < pluginFiles.size() && !((File)pluginFiles.get(j)).getName().equals(allPluginFiles[i].getName()); ++j) {
            }
            if (j < pluginFiles.size()) continue;
            pluginFiles.add(allPluginFiles[i]);
        }
        File[] result = new File[pluginFiles.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (File)pluginFiles.get(i);
        }
        return result;
    }

    public boolean isItInstalled(PluginInfoSheet infoSheet) {
        Iterator sheetsIterator = this.plugins.keySet().iterator();
        while (sheetsIterator.hasNext()) {
            PluginInfoSheet tempSheet = (PluginInfoSheet)sheetsIterator.next();
            if (!infoSheet.getFileName().equals(tempSheet.getFileName()) || this.extractVersionNumberFromFileName(infoSheet.getFileName()) != this.extractVersionNumberFromFileName(tempSheet.getFileName())) continue;
            return true;
        }
        return false;
    }

    public float getNewestVersion(PluginInfoSheet infoSheet) {
        Iterator sheetsIterator = this.plugins.keySet().iterator();
        float newestVersion = 0.0f;
        while (sheetsIterator.hasNext()) {
            PluginInfoSheet tempSheet = (PluginInfoSheet)sheetsIterator.next();
            if (!infoSheet.getFileName().equals(tempSheet.getFileName()) || !(Float.parseFloat(tempSheet.getVersion()) > newestVersion)) continue;
            newestVersion = Float.parseFloat(tempSheet.getVersion());
        }
        return newestVersion;
    }

    public float extractVersionNumberFromFileName(String fileName) {
        int s = fileName.lastIndexOf("-");
        int e = fileName.lastIndexOf(".jar");
        if (s > -1 && s < e) {
            return Float.parseFloat(new String(fileName.substring(s + 1, e)).replace('_', '.'));
        }
        return 0.0f;
    }

    public String getNameWithoutVersion(String fileName) {
        int s = fileName.lastIndexOf("-");
        if (s > -1) {
            return fileName.substring(0, s);
        }
        s = fileName.lastIndexOf(".jar");
        if (s > -1) {
            return fileName.substring(0, s);
        }
        return fileName;
    }

    public boolean isPluginFileLoadedWithName(String fileName) {
        Object[] sheets = this.getSheets();
        for (int n = 0; n < sheets.length; ++n) {
            String name = ((PluginInfoSheet)sheets[n]).getFileName();
            if (!name.equals(fileName)) continue;
            return true;
        }
        return false;
    }

    public boolean isPluginFileLoaded(File file) {
        Object[] sheets = this.getSheets();
        for (int n = 0; n < sheets.length; ++n) {
            File tempFile = ((PluginInfoSheet)sheets[n]).getFile();
            if (!file.equals(tempFile)) continue;
            return true;
        }
        return false;
    }

    public boolean isItActive(String fileName) {
        String name = this.getNameWithoutVersion(fileName);
        Iterator it = ((AbstractList)this.jDictionary.getPrefs().InActivePlugins).iterator();
        while (it.hasNext()) {
            if (!((String)it.next()).equals(name)) continue;
            return false;
        }
        return true;
    }

    public void selectPlugin(PluginInfoSheet sheet) {
        this.selectPlugin(sheet, null);
    }

    public void selectPlugin(PluginInfoSheet sheet, String subPluginName) {
        ArrayList plugin = this.getPlugin(sheet);
        if (sheet == null && subPluginName == null) {
            this.selectedPlugin = null;
            this.selectedSubPlugin = null;
            this.notifyPluginSelectedListeners();
            return;
        }
        if (sheet == this.selectedPlugin && subPluginName == this.selectedSubPlugin || sheet == this.selectedPlugin && subPluginName == null) {
            return;
        }
        if (plugin == null) {
            this.selectedPlugin = null;
            this.selectedSubPlugin = null;
            this.notifyPluginSelectedListeners();
            return;
        }
        this.selectedPlugin = sheet;
        for (int i = 0; i < plugin.size(); ++i) {
            if (!plugin.get(i).toString().equals(subPluginName)) continue;
            this.selectedSubPlugin = subPluginName;
            this.notifyPluginSelectedListeners();
            return;
        }
        this.selectedSubPlugin = null;
        this.notifyPluginSelectedListeners();
    }

    public PluginInfoSheet getSelectedPlugin() {
        return this.selectedPlugin;
    }

    public String getSelectedSubPlugin() {
        return this.selectedSubPlugin;
    }

    public void setActive(String fileName) {
        String name = this.getNameWithoutVersion(fileName);
        ((AbstractCollection)this.jDictionary.getPrefs().InActivePlugins).remove(name);
    }

    public void setInActive(String fileName) {
        String name = this.getNameWithoutVersion(fileName);
        this.jDictionary.getPrefs().InActivePlugins.add(name);
    }

    public void cleanUpInactivePluginList() {
        Iterator inactivePlugins = ((AbstractList)this.jDictionary.getPrefs().InActivePlugins).iterator();
        while (inactivePlugins.hasNext()) {
            if (this.isItAvailable(inactivePlugins.next().toString(), false)) continue;
            inactivePlugins.remove();
        }
    }

    public boolean isThereNewerPluginFileAvailable(String fileName) {
        File[] pluginFiles = this.getAvailablePluginFiles();
        float version = this.extractVersionNumberFromFileName(fileName);
        for (int i = 0; i < pluginFiles.length; ++i) {
            float tempVersion;
            if (!this.getNameWithoutVersion(pluginFiles[i].getName()).equals(this.getNameWithoutVersion(fileName)) || !((tempVersion = this.extractVersionNumberFromFileName(pluginFiles[i].getName())) > version)) continue;
            return true;
        }
        return false;
    }

    public boolean isThereNewerGlobalPluginFileAvailable(String fileName) {
        File[] pluginFiles = this.getGlobalPluginFiles();
        float version = this.extractVersionNumberFromFileName(fileName);
        for (int i = 0; i < pluginFiles.length; ++i) {
            float tempVersion;
            if (!this.getNameWithoutVersion(pluginFiles[i].getName()).equals(this.getNameWithoutVersion(fileName)) || !((tempVersion = this.extractVersionNumberFromFileName(pluginFiles[i].getName())) > version)) continue;
            return true;
        }
        return false;
    }

    public boolean isThereNewerLocalPluginFileAvailable(String fileName) {
        File[] pluginFiles = this.getLocalPluginFiles();
        float version = this.extractVersionNumberFromFileName(fileName);
        for (int i = 0; i < pluginFiles.length; ++i) {
            float tempVersion;
            if (!this.getNameWithoutVersion(pluginFiles[i].getName()).equals(this.getNameWithoutVersion(fileName)) || !((tempVersion = this.extractVersionNumberFromFileName(pluginFiles[i].getName())) > version)) continue;
            return true;
        }
        return false;
    }

    public boolean isItAvailable(String fileName, boolean careWithVersion) {
        File[] files = this.getPluginFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!(careWithVersion ? files[i].getName().equals(fileName) : this.getNameWithoutVersion(files[i].getName()).equals(this.getNameWithoutVersion(fileName)))) continue;
            return true;
        }
        return false;
    }

    public boolean isExist(File pluginFile) {
        File[] pluginFiles = this.getPluginFiles();
        for (int i = 0; i < pluginFiles.length; ++i) {
            if (!pluginFiles[i].equals(pluginFile)) continue;
            return true;
        }
        return false;
    }

    public void scanPlugins() {
        new Thread(){

            public void run() {
                while (PluginManager.this.scanThread != null && PluginManager.this.scanThread.isAlive()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                PluginManager.this.scanThread = new ScanThread();
                PluginManager.this.scanThread.start();
            }
        }.start();
    }

    void cleanupPlugins() {
        Object[] sheets = this.getSheets();
        for (int n = 0; n < sheets.length; ++n) {
            PluginInfoSheet sheet = (PluginInfoSheet)sheets[n];
            File pluginFile = sheet.getFile();
            if (this.isExist(pluginFile) && this.isItActive(pluginFile.getName())) continue;
            this.removePlugin(sheet);
        }
    }

    long getSize(ZipFile zipFile) {
        File f = new File(zipFile.getName());
        return f.length();
    }

    void notifyPluginAddedListeners(PluginInfoSheet sheet) {
        Vector tmpList;
        PluginStructureChangeEvent event = new PluginStructureChangeEvent(this, sheet);
        PluginManager pluginManager = this;
        synchronized (pluginManager) {
            tmpList = (Vector)this.pluginStructureChangeListeners.clone();
        }
        for (int i = 0; i < tmpList.size(); ++i) {
            ((PluginStructureChangeListener)tmpList.elementAt(i)).pluginAdded(event);
        }
    }

    void notifyPluginRemovedListeners(PluginInfoSheet sheet) {
        Vector tmpList;
        PluginStructureChangeEvent event = new PluginStructureChangeEvent(this, sheet);
        PluginManager pluginManager = this;
        synchronized (pluginManager) {
            tmpList = (Vector)this.pluginStructureChangeListeners.clone();
        }
        for (int i = 0; i < tmpList.size(); ++i) {
            ((PluginStructureChangeListener)tmpList.elementAt(i)).pluginRemoved(event);
        }
    }

    void notifyPluginFilesChangedListeners(File[] fileList) {
        Vector tmpList;
        this.cleanUpInactivePluginList();
        PluginFilesChangeEvent event = new PluginFilesChangeEvent(this, fileList);
        PluginManager pluginManager = this;
        synchronized (pluginManager) {
            tmpList = (Vector)this.pluginFilesChangeListeners.clone();
        }
        for (int i = 0; i < tmpList.size(); ++i) {
            ((PluginFilesChangeListener)tmpList.elementAt(i)).pluginFilesChanged(event);
        }
    }

    void notifyPluginSelectedListeners() {
        Vector tmpList;
        PluginSelectionEvent event = new PluginSelectionEvent(this, this.selectedPlugin, this.selectedSubPlugin);
        PluginManager pluginManager = this;
        synchronized (pluginManager) {
            tmpList = (Vector)this.pluginSelectionListeners.clone();
        }
        for (int i = 0; i < tmpList.size(); ++i) {
            ((PluginSelectionListener)tmpList.elementAt(i)).pluginSelected(event);
        }
    }

    void notifyPluginScanFinishedListeners() {
        Vector tmpList;
        PluginScanFinishedEvent event = new PluginScanFinishedEvent(this, this.plugins);
        PluginManager pluginManager = this;
        synchronized (pluginManager) {
            tmpList = (Vector)this.pluginScanFinishedListeners.clone();
        }
        for (int i = 0; i < tmpList.size(); ++i) {
            ((PluginScanFinishedListener)tmpList.elementAt(i)).pluginScanFinished(event);
        }
    }

    public synchronized void addPluginStructureChangeListener(PluginStructureChangeListener listener) {
        this.pluginStructureChangeListeners.addElement(listener);
    }

    public synchronized void removePluginStructureChangeListener(PluginStructureChangeListener listener) {
        this.pluginStructureChangeListeners.removeElement(listener);
    }

    public synchronized void addPluginFilesChangeListener(PluginFilesChangeListener listener) {
        this.pluginFilesChangeListeners.addElement(listener);
    }

    public synchronized void removePluginFilesChangeListener(PluginFilesChangeListener listener) {
        this.pluginFilesChangeListeners.removeElement(listener);
    }

    public synchronized void addPluginSelectionListener(PluginSelectionListener listener) {
        this.pluginSelectionListeners.addElement(listener);
    }

    public synchronized void removePluginSelectionListener(PluginSelectionListener listener) {
        this.pluginSelectionListeners.removeElement(listener);
    }

    public synchronized void addPluginScanFinishedListener(PluginScanFinishedListener listener) {
        this.pluginScanFinishedListeners.addElement(listener);
    }

    public synchronized void removePluginScanFinishedListener(PluginScanFinishedListener listener) {
        this.pluginScanFinishedListeners.removeElement(listener);
    }

    class ScanThread
    extends Thread {
        ScanThread() {
        }

        public void run() {
            PluginManager.this.cleanupPlugins();
            PluginManager.this.checkPluginDirForChanges();
            boolean loadLastUsed = true;
            int i = 0;
            File[] baseDirFiles = PluginManager.this.getPluginFiles();
            while (i < baseDirFiles.length) {
                File fileToLoad = baseDirFiles[i];
                try {
                    if (loadLastUsed) {
                        loadLastUsed = false;
                        Prefs prefs = PluginManager.this.jDictionary.getPrefs();
                        if (prefs.lastSelectedPlugin != null && PluginManager.this.isItAvailable(prefs.lastSelectedPlugin.getFileName(), true) && PluginManager.this.isItActive(prefs.lastSelectedPlugin.getFileName())) {
                            fileToLoad = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(PluginManager.this.jDictionary.getGlobalPluginDirPath()))).append(JDictionary.getFileSeparator()).append(PluginManager.this.jDictionary.getPrefs().lastSelectedPlugin.getFileName()))));
                            if (!fileToLoad.exists()) {
                                fileToLoad = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(PluginManager.this.jDictionary.getPluginDirPath()))).append(JDictionary.getFileSeparator()).append(PluginManager.this.jDictionary.getPrefs().lastSelectedPlugin.getFileName()))));
                            }
                            i = -1;
                        }
                    }
                    if (!PluginManager.this.isItActive(fileToLoad.getName())) {
                        ++i;
                        continue;
                    }
                    if (PluginManager.this.isPluginFileLoaded(fileToLoad)) {
                        System.out.println(String.valueOf(String.valueOf(new StringBuffer("Plugin ").append(fileToLoad.getName()).append(" is already loaded"))));
                        ++i;
                        continue;
                    }
                    ZipFile jarFile = null;
                    try {
                        jarFile = new ZipFile(fileToLoad);
                    }
                    catch (ZipException e) {
                        System.out.println(String.valueOf(String.valueOf(new StringBuffer("The plugin file named: ").append(fileToLoad.getName()).append(" is corrupted. Trying to delete..."))));
                        try {
                            fileToLoad.delete();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++i;
                        continue;
                    }
                    System.out.println("\nscanPlugins(): Processing file: ".concat(String.valueOf(String.valueOf(jarFile.getName()))));
                    if (jarFile != null) {
                        System.out.println("Loading InfoSheet from file named: ".concat(String.valueOf(String.valueOf(jarFile.getName()))));
                        PluginInfoSheet sheet = PluginInfoSheet.CreateInfoSheet(fileToLoad);
                        if (sheet == null) {
                            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Unable to load InfoSheet from file named: ").append(jarFile.getName()).append(" Skipping..."))));
                            ++i;
                            try {
                                jarFile.close();
                            }
                            catch (IOException iOException) {}
                            continue;
                        }
                        if (Float.parseFloat(sheet.getMinJDictionaryVersion()) > JDictionary.getJDictionaryVersion()) {
                            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Unable to load plugin named ").append(sheet.getName()).append(" (JDictionary version ").append(sheet.getMinJDictionaryVersion()).append(" or higher needed) Skipping..."))));
                            ++i;
                            try {
                                jarFile.close();
                            }
                            catch (IOException iOException) {}
                            continue;
                        }
                        sheet.setFileName(fileToLoad.getName());
                        sheet.setSize(Long.toString(fileToLoad.length()));
                        PluginLoader pluginLoader = new PluginLoader(jarFile.getName());
                        Enumeration<? extends ZipEntry> entries = jarFile.entries();
                        while (entries.hasMoreElements()) {
                            Class<?> pluginClass;
                            Object plugin;
                            String entryName = entries.nextElement().getName();
                            if (!entryName.endsWith("Plugin.class") || !((plugin = (pluginClass = pluginLoader.loadClass(entryName)).newInstance()) instanceof Plugin)) continue;
                            PluginManager.this.pushPlugin(sheet, (Plugin)plugin);
                        }
                        PluginManager.this.notifyPluginAddedListeners(sheet);
                    }
                    ++i;
                    jarFile.close();
                }
                catch (Exception e) {
                    System.out.println(String.valueOf(String.valueOf(new StringBuffer("scanPlugins(): An error occurred while loading plugin named: ").append(fileToLoad.getName()).append(" Skipping..."))));
                    e.printStackTrace();
                    ++i;
                }
            }
            PluginManager.this.notifyPluginScanFinishedListeners();
        }
    }
}

